/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.asn1;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.renderer.RbelHtmlFacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import de.gematik.rbellogger.util.GenericPrettyPrinter;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelAsn1Facet
implements RbelFacet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelAsn1Facet.class);
    private static final GenericPrettyPrinter<ASN1Encodable> ASN1_PRETTY_PRINTER = new GenericPrettyPrinter<ASN1Encodable>(asn1 -> !(asn1 instanceof ASN1Sequence) && !(asn1 instanceof ASN1Set), Object::toString, asn1 -> StreamSupport.stream(((Iterable)asn1).spliterator(), false));
    private final RbelElement unparsedBytes;
    private final ASN1Encodable asn1Content;

    @Override
    public RbelMultiMap<RbelElement> getChildElements() {
        return new RbelMultiMap<RbelElement>().with("unparsedBytes", this.unparsedBytes);
    }

    @ConstructorProperties(value={"unparsedBytes", "asn1Content"})
    @Generated
    RbelAsn1Facet(RbelElement unparsedBytes, ASN1Encodable asn1Content) {
        this.unparsedBytes = unparsedBytes;
        this.asn1Content = asn1Content;
    }

    @Generated
    public static RbelAsn1FacetBuilder builder() {
        return new RbelAsn1FacetBuilder();
    }

    @Generated
    public RbelAsn1FacetBuilder toBuilder() {
        return new RbelAsn1FacetBuilder().unparsedBytes(this.unparsedBytes).asn1Content(this.asn1Content);
    }

    @Generated
    public RbelElement getUnparsedBytes() {
        return this.unparsedBytes;
    }

    @Generated
    public ASN1Encodable getAsn1Content() {
        return this.asn1Content;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelAsn1Facet)) {
            return false;
        }
        RbelAsn1Facet other = (RbelAsn1Facet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RbelElement this$unparsedBytes = this.getUnparsedBytes();
        RbelElement other$unparsedBytes = other.getUnparsedBytes();
        if (this$unparsedBytes == null ? other$unparsedBytes != null : !this$unparsedBytes.equals(other$unparsedBytes)) {
            return false;
        }
        ASN1Encodable this$asn1Content = this.getAsn1Content();
        ASN1Encodable other$asn1Content = other.getAsn1Content();
        return !(this$asn1Content == null ? other$asn1Content != null : !this$asn1Content.equals(other$asn1Content));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelAsn1Facet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelElement $unparsedBytes = this.getUnparsedBytes();
        result = result * 59 + ($unparsedBytes == null ? 43 : $unparsedBytes.hashCode());
        ASN1Encodable $asn1Content = this.getAsn1Content();
        result = result * 59 + ($asn1Content == null ? 43 : $asn1Content.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelAsn1Facet(unparsedBytes=" + String.valueOf(this.getUnparsedBytes()) + ", asn1Content=" + String.valueOf(this.getAsn1Content()) + ")";
    }

    static {
        RbelHtmlRenderer.registerFacetRenderer(new RbelHtmlFacetRenderer(){

            @Override
            public boolean checkForRendering(RbelElement element) {
                return element.hasFacet(RbelAsn1Facet.class);
            }

            @Override
            public ContainerTag performRendering(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
                return TagCreator.div((DomContent[])new DomContent[]{TagCreator.pre((String)ASN1_PRETTY_PRINTER.prettyPrint(element.getFacetOrFail(RbelAsn1Facet.class).getAsn1Content())).withClass("binary"), TagCreator.br(), RbelHtmlRenderingToolkit.ancestorTitle().with((DomContent)RbelHtmlRenderingToolkit.vertParentTitle().with(renderingToolkit.convertNested(element)))});
            }

            @Override
            public int order() {
                return 10000;
            }
        });
    }

    @Generated
    public static class RbelAsn1FacetBuilder {
        @Generated
        private RbelElement unparsedBytes;
        @Generated
        private ASN1Encodable asn1Content;

        @Generated
        RbelAsn1FacetBuilder() {
        }

        @Generated
        public RbelAsn1FacetBuilder unparsedBytes(RbelElement unparsedBytes) {
            this.unparsedBytes = unparsedBytes;
            return this;
        }

        @Generated
        public RbelAsn1FacetBuilder asn1Content(ASN1Encodable asn1Content) {
            this.asn1Content = asn1Content;
            return this;
        }

        @Generated
        public RbelAsn1Facet build() {
            return new RbelAsn1Facet(this.unparsedBytes, this.asn1Content);
        }

        @Generated
        public String toString() {
            return "RbelAsn1Facet.RbelAsn1FacetBuilder(unparsedBytes=" + String.valueOf(this.unparsedBytes) + ", asn1Content=" + String.valueOf(this.asn1Content) + ")";
        }
    }
}

