/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.asn1;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.data.core.RbelListFacet;
import de.gematik.rbellogger.data.core.RbelNestedFacet;
import de.gematik.rbellogger.data.core.RbelRootFacet;
import de.gematik.rbellogger.data.core.RbelValueFacet;
import de.gematik.rbellogger.exceptions.RbelConversionException;
import de.gematik.rbellogger.facets.asn1.RbelAsn1Facet;
import de.gematik.rbellogger.facets.asn1.RbelAsn1TaggedValueFacet;
import de.gematik.rbellogger.facets.pki.OidDictionary;
import de.gematik.rbellogger.util.RbelException;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.input.BoundedInputStream;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1PrintableString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERPrintableString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConverterInfo(onlyActivateFor={"asn1"})
public class RbelAsn1Converter
extends RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelAsn1Converter.class);

    @Override
    public void consumeElement(RbelElement rbelElement, RbelConversionExecutor context) {
        if (rbelElement.getContent().size() < 3 || rbelElement.hasFacet(RbelRootFacet.class)) {
            return;
        }
        this.tryToParseAsn1Structure(rbelElement.getContent().toInputStream(), context, rbelElement).or(() -> this.decodeIntoInputStream(rbelElement, Base64.getDecoder()).flatMap(stream -> this.tryToParseAsn1Structure((InputStream)stream, context, rbelElement))).or(() -> this.decodeIntoInputStream(rbelElement, Base64.getUrlDecoder()).flatMap(stream -> this.tryToParseAsn1Structure((InputStream)stream, context, rbelElement))).ifPresent(facet -> rbelElement.addFacet(new RbelRootFacet<RbelAsn1Facet>((RbelAsn1Facet)facet)));
    }

    private Optional<InputStream> decodeIntoInputStream(RbelElement rbelElement, Base64.Decoder decoder) {
        try {
            return Optional.ofNullable(decoder.wrap(this.trimmedInputStream(rbelElement)));
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
    }

    private InputStream trimmedInputStream(RbelElement element) {
        int start;
        byte[] data = element.getContent().toByteArray();
        int end = data.length;
        for (start = 0; start < end && Character.isWhitespace((char)data[start]); ++start) {
        }
        while (end > start && Character.isWhitespace((char)data[end - 1])) {
            --end;
        }
        BoundedInputStream result = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(data))).setMaxCount((long)end)).get();
        if ((long)start != result.skip((long)start)) {
            throw new RbelConversionException("Error while skipping whitespace", element, (RbelConverterPlugin)this);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<RbelAsn1Facet> tryToParseAsn1Structure(InputStream data, RbelConversionExecutor converter, RbelElement element) {
        if (data.available() < 3) return Optional.empty();
        if (element.hasFacet(RbelAsn1Facet.class)) {
            return Optional.empty();
        }
        Optional<RbelAsn1Facet> result = Optional.empty();
        try (ASN1InputStream input = new ASN1InputStream(data);){
            ASN1Primitive primitive;
            while ((primitive = input.readObject()) != null) {
                if (element.hasFacet(RbelAsn1Facet.class) || element.hasFacet(RbelAsn1TaggedValueFacet.class)) {
                    log.trace("Stream with multiple ASN.1 Instances encountered! Skipping");
                    Optional<RbelAsn1Facet> optional = Optional.empty();
                    return optional;
                }
                if (primitive instanceof ASN1Sequence || element.getParentNode() != null && (element.getParentNode().hasFacet(RbelAllowAsn1FragmentsFacet.class) || element.getParentNode().hasFacet(RbelAsn1Facet.class))) {
                    result = Optional.ofNullable(this.convertToAsn1Facet((ASN1Encodable)primitive, converter, element));
                }
                if (input.available() == 0) continue;
                result.ifPresent(facet -> element.getFacets().remove(facet));
                Optional<RbelAsn1Facet> optional = Optional.empty();
                return optional;
            }
            Optional<RbelAsn1Facet> optional = result;
            return optional;
        }
        catch (IOException | RuntimeException e) {
            log.trace("Error while parsing element {}", (Object)element, (Object)e);
            return Optional.empty();
        }
    }

    private RbelAsn1Facet convertToAsn1Facet(ASN1Encodable asn1, RbelConversionExecutor converter, RbelElement parentNode) throws IOException {
        RbelAsn1Facet result = RbelAsn1Facet.builder().asn1Content(asn1).build();
        parentNode.addFacet(result);
        if (asn1 instanceof ASN1Sequence || asn1 instanceof ASN1Set) {
            this.convertSequence((Iterable)asn1, converter, parentNode);
        } else if (asn1 instanceof ASN1TaggedObject) {
            ASN1TaggedObject asn1TaggedObject = (ASN1TaggedObject)asn1;
            this.convertTaggedObject(converter, parentNode, asn1TaggedObject);
        } else if (asn1 instanceof ASN1Integer) {
            ASN1Integer asn1Integer = (ASN1Integer)asn1;
            parentNode.addFacet(RbelValueFacet.of(asn1Integer.getValue()));
        } else if (asn1 instanceof ASN1ObjectIdentifier) {
            ASN1ObjectIdentifier asn1ObjectIdentifier = (ASN1ObjectIdentifier)asn1;
            RbelAsn1Converter.convertOid(parentNode, asn1ObjectIdentifier);
        } else if (asn1 instanceof ASN1OctetString) {
            ASN1OctetString asn1OctetString = (ASN1OctetString)asn1;
            this.convertOctetString(converter, parentNode, asn1OctetString);
        } else if (asn1 instanceof ASN1BitString) {
            ASN1BitString asn1BitString = (ASN1BitString)asn1;
            this.convertBitString(converter, parentNode, asn1BitString);
        } else if (asn1 instanceof ASN1PrintableString) {
            ASN1PrintableString asn1String = (ASN1PrintableString)asn1;
            this.convertPrintableString(asn1, converter, parentNode, asn1String);
        } else if (asn1 instanceof ASN1String) {
            ASN1String asn1String = (ASN1String)asn1;
            this.convertString(asn1, converter, parentNode, asn1String);
        } else if (asn1 instanceof ASN1Boolean) {
            ASN1Boolean asn1Boolean = (ASN1Boolean)asn1;
            parentNode.addFacet(RbelValueFacet.of(asn1Boolean.isTrue()));
        } else if (asn1 instanceof ASN1Null) {
            parentNode.addFacet(RbelValueFacet.of(null));
        } else if (asn1 instanceof ASN1UTCTime) {
            ASN1UTCTime asn1UTCTime = (ASN1UTCTime)asn1;
            RbelAsn1Converter.convertUtcTime(asn1, parentNode, asn1UTCTime);
        } else if (asn1 instanceof ASN1GeneralizedTime) {
            ASN1GeneralizedTime asn1GeneralizedTime = (ASN1GeneralizedTime)asn1;
            RbelAsn1Converter.convertGeneralizedTime(asn1, parentNode, asn1GeneralizedTime);
        } else if (asn1 instanceof ASN1Enumerated) {
            ASN1Enumerated asn1Enumerated = (ASN1Enumerated)asn1;
            parentNode.addFacet(RbelValueFacet.of(asn1Enumerated.getValue()));
        } else {
            log.warn("Unable to convert " + asn1.getClass().getSimpleName() + "!");
        }
        return result;
    }

    private static void convertGeneralizedTime(ASN1Encodable asn1, RbelElement parentNode, ASN1GeneralizedTime asn1GeneralizedTime) {
        try {
            parentNode.addFacet(RbelValueFacet.of(ZonedDateTime.ofInstant(asn1GeneralizedTime.getDate().toInstant(), ZoneId.of("UTC"))));
        }
        catch (ParseException e) {
            throw new RbelException("Error during time-conversion of " + String.valueOf(asn1), e);
        }
    }

    private static void convertUtcTime(ASN1Encodable asn1, RbelElement parentNode, ASN1UTCTime asn1UTCTime) {
        try {
            parentNode.addFacet(RbelValueFacet.of(ZonedDateTime.ofInstant(asn1UTCTime.getAdjustedDate().toInstant(), ZoneId.of("UTC"))));
        }
        catch (ParseException e) {
            throw new RbelException("Error during time-conversion of " + String.valueOf(asn1), e);
        }
    }

    private void convertString(ASN1Encodable asn1, RbelConversionExecutor converter, RbelElement parentNode, ASN1String asn1String) {
        parentNode.addFacet(RbelValueFacet.of(asn1String.getString()));
        this.addCharsetInformation(parentNode, asn1);
        this.tryToParseEmbeddedContentAndAddFacetIfPresent(converter, parentNode, asn1String.getString().getBytes(parentNode.getElementCharset()));
    }

    private void convertPrintableString(ASN1Encodable asn1, RbelConversionExecutor converter, RbelElement parentNode, ASN1PrintableString asn1String) {
        parentNode.addFacet(RbelValueFacet.of(asn1String.getString()));
        this.addCharsetInformation(parentNode, asn1);
        this.tryToParseEmbeddedContentAndAddFacetIfPresent(converter, parentNode, asn1String.getOctets());
    }

    private void convertBitString(RbelConversionExecutor converter, RbelElement parentNode, ASN1BitString asn1BitString) {
        byte[] octets = asn1BitString.getOctets();
        parentNode.addFacet(RbelValueFacet.of(octets));
        this.tryToParseEmbeddedContentAndAddFacetIfPresent(converter, parentNode, octets);
    }

    private void convertOctetString(RbelConversionExecutor converter, RbelElement parentNode, ASN1OctetString asn1OctetString) {
        byte[] octets = asn1OctetString.getOctets();
        parentNode.addFacet(RbelValueFacet.of(octets));
        this.tryToParseEmbeddedContentAndAddFacetIfPresent(converter, parentNode, octets);
    }

    private static void convertOid(RbelElement parentNode, ASN1ObjectIdentifier asn1ObjectIdentifier) {
        parentNode.addFacet(RbelValueFacet.of(asn1ObjectIdentifier.getId()));
        OidDictionary.buildAndAddAsn1OidFacet(parentNode, asn1ObjectIdentifier.getId());
    }

    private void convertTaggedObject(RbelConversionExecutor converter, RbelElement parentNode, ASN1TaggedObject asn1TaggedObject) throws IOException {
        int tagNo = asn1TaggedObject.getTagNo();
        ASN1Primitive nestedObject = asn1TaggedObject.getBaseObject().toASN1Primitive();
        RbelElement nestedElement = new RbelElement(nestedObject.getEncoded(), parentNode);
        this.convertToAsn1Facet((ASN1Encodable)nestedObject, converter, nestedElement);
        parentNode.addFacet(new RbelAsn1TaggedValueFacet(RbelElement.wrap(BigInteger.valueOf(tagNo).toByteArray(), parentNode, tagNo), nestedElement));
    }

    private void convertSequence(Iterable<ASN1Encodable> asn1, RbelConversionExecutor converter, RbelElement parentNode) throws IOException {
        ArrayList<RbelElement> rbelSequence = new ArrayList<RbelElement>();
        for (ASN1Encodable encodable : asn1) {
            RbelElement newChild = new RbelElement(encodable.toASN1Primitive().getEncoded(), parentNode);
            this.convertToAsn1Facet(encodable, converter, newChild);
            rbelSequence.add(newChild);
        }
        parentNode.addFacet(RbelListFacet.builder().childNodes(rbelSequence).build());
    }

    private void addCharsetInformation(RbelElement parentNode, ASN1Encodable asn1) {
        if (asn1 instanceof DERPrintableString || asn1 instanceof DERIA5String) {
            parentNode.setCharset(Optional.of(StandardCharsets.US_ASCII));
        } else {
            parentNode.setCharset(Optional.of(StandardCharsets.UTF_8));
        }
    }

    private void tryToParseEmbeddedContentAndAddFacetIfPresent(RbelConversionExecutor converter, RbelElement parentNode, byte[] octets) {
        RbelElement nestedElement = new RbelElement(octets, parentNode);
        RbelNestedFacet facet = new RbelNestedFacet(nestedElement);
        try {
            parentNode.addFacet(facet);
            converter.convertElement(nestedElement);
            nestedElement.getFacets().stream().filter(RbelRootFacet.class::isInstance).map(RbelRootFacet.class::cast).filter(f -> f.getRootFacet() instanceof RbelAsn1Facet).toList().forEach(f -> nestedElement.getFacets().remove(f));
        }
        catch (RuntimeException e) {
            parentNode.getFacets().remove(facet);
        }
    }

    public static class RbelAllowAsn1FragmentsFacet
    implements RbelFacet {
        private boolean shouldParse = true;

        @Generated
        public boolean isShouldParse() {
            return this.shouldParse;
        }

        @Generated
        public void setShouldParse(boolean shouldParse) {
            this.shouldParse = shouldParse;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RbelAllowAsn1FragmentsFacet)) {
                return false;
            }
            RbelAllowAsn1FragmentsFacet other = (RbelAllowAsn1FragmentsFacet)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isShouldParse() == other.isShouldParse();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RbelAllowAsn1FragmentsFacet;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isShouldParse() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "RbelAsn1Converter.RbelAllowAsn1FragmentsFacet(shouldParse=" + this.isShouldParse() + ")";
        }

        @ConstructorProperties(value={"shouldParse"})
        @Generated
        public RbelAllowAsn1FragmentsFacet(boolean shouldParse) {
            this.shouldParse = shouldParse;
        }

        @Generated
        public RbelAllowAsn1FragmentsFacet() {
        }
    }
}

