/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.exceptions;

import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelNoteFacet;
import de.gematik.test.tiger.exceptions.GenericTigerException;
import java.util.Base64;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;

public class RbelConversionException
extends GenericTigerException {
    private RbelElement currentElement;
    private RbelConverterPlugin converter;

    public RbelConversionException(String s) {
        super(s);
    }

    public RbelConversionException(Exception e) {
        super((Throwable)e);
    }

    public RbelConversionException(String msg, Throwable e) {
        super(msg, e);
    }

    public RbelConversionException(Exception e, RbelElement value) {
        super((Throwable)e);
        this.currentElement = value;
    }

    public RbelConversionException(Exception e, RbelElement currentElement, RbelConverterPlugin plugin) {
        super((Throwable)e);
        this.currentElement = currentElement;
        this.converter = plugin;
    }

    public RbelConversionException(String msg, Exception e, RbelElement currentElement, RbelConverterPlugin plugin) {
        super(msg, (Throwable)e);
        this.currentElement = currentElement;
        this.converter = plugin;
    }

    public RbelConversionException(String message, RbelElement currentElement, RbelConverterPlugin plugin) {
        super(message);
        this.currentElement = currentElement;
        this.converter = plugin;
    }

    public RbelConversionException(String msg, Exception e, RbelElement value) {
        super(msg, (Throwable)e);
        this.currentElement = value;
    }

    public static RbelConversionException wrapIfNotAConversionException(Exception input, RbelConverterPlugin plugin, RbelElement currentElement) {
        if (input instanceof RbelConversionException) {
            RbelConversionException conversionException = (RbelConversionException)((Object)input);
            conversionException.setCurrentElement(currentElement);
            conversionException.setConverter(plugin);
            return conversionException;
        }
        return new RbelConversionException(input, currentElement, plugin);
    }

    public void printDetailsToLog(Logger log) {
        log.atDebug().log(this::generateGenericConversionErrorMessage);
        log.debug("Stack trace", (Throwable)((Object)this));
        if (log.isTraceEnabled()) {
            log.trace("Content in failed conversion-attempt was {} bytes: {}", (Object)this.currentElement.getRawContent().length, (Object)this.currentElement.getRawStringContent());
            if (this.currentElement.getParentNode() != null) {
                log.trace("Parent-Content in failed conversion-attempt was (B64-encoded) {}", (Object)Base64.getEncoder().encodeToString(this.currentElement.getParentNode().getRawContent()));
            }
        }
    }

    private String generateGenericConversionErrorMessage() {
        return "Exception during conversion with plugin '" + this.chooseAppropriateScreenNameForConverter() + "' (" + this.getMessage() + ")";
    }

    private String chooseAppropriateScreenNameForConverter() {
        if (StringUtils.isEmpty((CharSequence)this.converter.getClass().getSimpleName())) {
            return this.converter.getClass().getName();
        }
        return this.converter.getClass().getSimpleName();
    }

    public void addErrorNoteFacetToElement() {
        if (this.currentElement == null) {
            return;
        }
        this.currentElement.addFacet(new RbelNoteFacet(this.generateGenericConversionErrorMessage() + "\n\n" + ExceptionUtils.getStackTrace((Throwable)((Object)this)), RbelNoteFacet.NoteStyling.ERROR));
    }

    @Generated
    public RbelElement getCurrentElement() {
        return this.currentElement;
    }

    @Generated
    public RbelConverterPlugin getConverter() {
        return this.converter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelConversionException)) {
            return false;
        }
        RbelConversionException other = (RbelConversionException)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RbelElement this$currentElement = this.getCurrentElement();
        RbelElement other$currentElement = other.getCurrentElement();
        if (this$currentElement == null ? other$currentElement != null : !this$currentElement.equals(other$currentElement)) {
            return false;
        }
        RbelConverterPlugin this$converter = this.getConverter();
        RbelConverterPlugin other$converter = other.getConverter();
        return !(this$converter == null ? other$converter != null : !this$converter.equals(other$converter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelConversionException;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        RbelElement $currentElement = this.getCurrentElement();
        result = result * 59 + ($currentElement == null ? 43 : $currentElement.hashCode());
        RbelConverterPlugin $converter = this.getConverter();
        result = result * 59 + ($converter == null ? 43 : $converter.hashCode());
        return result;
    }

    @Generated
    public void setCurrentElement(RbelElement currentElement) {
        this.currentElement = currentElement;
    }

    @Generated
    public void setConverter(RbelConverterPlugin converter) {
        this.converter = converter;
    }
}

