/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.util;

import com.google.common.html.HtmlEscapers;
import de.gematik.rbellogger.RbelOptions;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.data.core.RbelRootFacet;
import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.rbellogger.util.RbelContextDecorator;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class RbelElementTreePrinter {
    private final RbelElement rootElement;
    private Class<? extends RbelFacet> onlyPrintElementsWithFacet;
    private final int maximumLevels;
    private final boolean printContent;
    private final boolean printKeys;
    private final boolean printFacets;
    private final boolean printColors;
    private final boolean printParsingTimes;
    private final boolean htmlEscaping;
    private final boolean addJexlResponseLinkCssClass;

    public String execute() {
        RbelElement position = new RbelElement();
        position.addFacet(new RbelFacet(){

            @Override
            public RbelMultiMap<RbelElement> getChildElements() {
                return new RbelMultiMap<RbelElement>().with(RbelElementTreePrinter.this.findKeyOfRootElement(), RbelElementTreePrinter.this.rootElement);
            }
        });
        if (this.onlyPrintElementsWithFacet != null) {
            this.rootElement.getFacet(this.onlyPrintElementsWithFacet).ifPresent(position::addFacet);
        }
        String rawResult = this.executeRecursive(position, "", Math.max(this.maximumLevels, this.maximumLevels + 1));
        if (this.htmlEscaping) {
            return this.performHtmlEscaping(rawResult);
        }
        return rawResult;
    }

    private String performHtmlEscaping(String rawResult) {
        return HtmlEscapers.htmlEscaper().escape(rawResult).replace(RbelAnsiColors.RESET.toString(), "</span>").replace(RbelAnsiColors.RED_BOLD.toString(), "<span class='text-warning " + (this.addJexlResponseLinkCssClass ? "jexlResponseLink' style='cursor: pointer;'" : "'") + ">").replace(RbelAnsiColors.CYAN.toString(), "<span class='text-info'>").replace(RbelAnsiColors.YELLOW_BRIGHT.toString(), "<span class='text-danger has-text-weight-bold'>").replace(RbelAnsiColors.GREEN.toString(), "<span class='text-warning'>").replace(RbelAnsiColors.BLUE.toString(), "<span class='text-success'>").replace("\n", "<br/>");
    }

    private String findKeyOfRootElement() {
        return Optional.ofNullable(this.rootElement.getParentNode()).map(RbelElement::getChildNodesWithKey).stream().flatMap(RbelMultiMap::stream).filter(pair -> pair.getValue() == this.rootElement).map(Map.Entry::getKey).findFirst().orElse("");
    }

    private String executeRecursive(RbelElement position, String padding, int remainingLevels) {
        if (remainingLevels <= 0) {
            return "";
        }
        if (this.onlyPrintElementsWithFacet != null && !position.hasFacet(this.onlyPrintElementsWithFacet)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<String, RbelElement>> iterator = position.getChildNodesWithKey().iterator();
        while (iterator.hasNext()) {
            String padString;
            String switchString;
            String linkSign;
            Map.Entry<String, RbelElement> childNode = iterator.next();
            String string = linkSign = childNode.getValue().hasFacet(RbelRootFacet.class) ? ">" : "\u2500";
            if (iterator.hasNext()) {
                switchString = "\u251c" + linkSign + "\u2500";
                padString = "|  ";
            } else {
                switchString = "\u2514" + linkSign + "\u2500";
                padString = "   ";
            }
            result.append(this.colorCommand(RbelAnsiColors.YELLOW_BRIGHT)).append(padding).append(switchString).append(this.colorCommand(RbelAnsiColors.RESET));
            result.append(this.colorCommand(RbelAnsiColors.RED_BOLD)).append(childNode.getKey()).append(this.colorCommand(RbelAnsiColors.RESET));
            result.append(this.printContentOf(childNode.getValue()));
            result.append(this.printFacets(childNode.getValue()));
            result.append("\n");
            if (childNode.getValue().getChildNodes().isEmpty()) continue;
            result.append(this.executeRecursive(childNode.getValue(), padding + padString, remainingLevels - 1));
        }
        return result.toString();
    }

    private String printFacets(RbelElement value) {
        if (!this.printFacets) {
            return "";
        }
        String facetsString = value.getFacets().stream().map(Object::getClass).map(Class::getSimpleName).filter(s -> !"RbelRootFacet".equals(s)).filter(s -> !"RbelListFacet".equals(s)).filter(s -> !"RbelNestedFacet".equals(s)).filter(s -> !"RbelMapFacet".equals(s)).collect(Collectors.joining(","));
        if (StringUtils.isEmpty((CharSequence)facetsString)) {
            return "";
        }
        return this.colorCommand(RbelAnsiColors.CYAN) + " (" + facetsString + ")" + this.colorCommand(RbelAnsiColors.RESET);
    }

    private String printContentOf(RbelElement value) {
        if (!this.printContent) {
            return "";
        }
        Object content = this.printParsingTimes ? (double)(value.getConversionTimeInNanos() / 1000L) / 1000.0 + "ms " : "";
        content = (String)content + RbelContextDecorator.forceStringConvert(value);
        return " (" + this.colorCommand(RbelAnsiColors.BLUE) + StringUtils.abbreviate((String)((String)content).replace("\n", "\\n").replace("\r", "\\r"), (int)0, (int)RbelOptions.getRbelPathTreeViewValueOutputLength()) + this.colorCommand(RbelAnsiColors.RESET) + ")";
    }

    private String colorCommand(RbelAnsiColors color) {
        if (this.printColors) {
            return color.toString();
        }
        return "";
    }

    @Generated
    private static Class<? extends RbelFacet> $default$onlyPrintElementsWithFacet() {
        return null;
    }

    @Generated
    private static int $default$maximumLevels() {
        return Integer.MAX_VALUE;
    }

    @Generated
    private static boolean $default$printContent() {
        return true;
    }

    @Generated
    private static boolean $default$printKeys() {
        return false;
    }

    @Generated
    private static boolean $default$printFacets() {
        return true;
    }

    @Generated
    private static boolean $default$printColors() {
        return true;
    }

    @Generated
    private static boolean $default$printParsingTimes() {
        return false;
    }

    @Generated
    private static boolean $default$htmlEscaping() {
        return false;
    }

    @Generated
    private static boolean $default$addJexlResponseLinkCssClass() {
        return false;
    }

    @Generated
    public static RbelElementTreePrinterBuilder builder() {
        return new RbelElementTreePrinterBuilder();
    }

    @ConstructorProperties(value={"rootElement", "onlyPrintElementsWithFacet", "maximumLevels", "printContent", "printKeys", "printFacets", "printColors", "printParsingTimes", "htmlEscaping", "addJexlResponseLinkCssClass"})
    @Generated
    private RbelElementTreePrinter(RbelElement rootElement, Class<? extends RbelFacet> onlyPrintElementsWithFacet, int maximumLevels, boolean printContent, boolean printKeys, boolean printFacets, boolean printColors, boolean printParsingTimes, boolean htmlEscaping, boolean addJexlResponseLinkCssClass) {
        this.rootElement = rootElement;
        this.onlyPrintElementsWithFacet = onlyPrintElementsWithFacet;
        this.maximumLevels = maximumLevels;
        this.printContent = printContent;
        this.printKeys = printKeys;
        this.printFacets = printFacets;
        this.printColors = printColors;
        this.printParsingTimes = printParsingTimes;
        this.htmlEscaping = htmlEscaping;
        this.addJexlResponseLinkCssClass = addJexlResponseLinkCssClass;
    }

    @Generated
    public static class RbelElementTreePrinterBuilder {
        @Generated
        private RbelElement rootElement;
        @Generated
        private boolean onlyPrintElementsWithFacet$set;
        @Generated
        private Class<? extends RbelFacet> onlyPrintElementsWithFacet$value;
        @Generated
        private boolean maximumLevels$set;
        @Generated
        private int maximumLevels$value;
        @Generated
        private boolean printContent$set;
        @Generated
        private boolean printContent$value;
        @Generated
        private boolean printKeys$set;
        @Generated
        private boolean printKeys$value;
        @Generated
        private boolean printFacets$set;
        @Generated
        private boolean printFacets$value;
        @Generated
        private boolean printColors$set;
        @Generated
        private boolean printColors$value;
        @Generated
        private boolean printParsingTimes$set;
        @Generated
        private boolean printParsingTimes$value;
        @Generated
        private boolean htmlEscaping$set;
        @Generated
        private boolean htmlEscaping$value;
        @Generated
        private boolean addJexlResponseLinkCssClass$set;
        @Generated
        private boolean addJexlResponseLinkCssClass$value;

        @Generated
        RbelElementTreePrinterBuilder() {
        }

        @Generated
        public RbelElementTreePrinterBuilder rootElement(RbelElement rootElement) {
            this.rootElement = rootElement;
            return this;
        }

        @Generated
        public RbelElementTreePrinterBuilder onlyPrintElementsWithFacet(Class<? extends RbelFacet> onlyPrintElementsWithFacet) {
            this.onlyPrintElementsWithFacet$value = onlyPrintElementsWithFacet;
            this.onlyPrintElementsWithFacet$set = true;
            return this;
        }

        @Generated
        public RbelElementTreePrinterBuilder maximumLevels(int maximumLevels) {
            this.maximumLevels$value = maximumLevels;
            this.maximumLevels$set = true;
            return this;
        }

        @Generated
        public RbelElementTreePrinterBuilder printContent(boolean printContent) {
            this.printContent$value = printContent;
            this.printContent$set = true;
            return this;
        }

        @Generated
        public RbelElementTreePrinterBuilder printKeys(boolean printKeys) {
            this.printKeys$value = printKeys;
            this.printKeys$set = true;
            return this;
        }

        @Generated
        public RbelElementTreePrinterBuilder printFacets(boolean printFacets) {
            this.printFacets$value = printFacets;
            this.printFacets$set = true;
            return this;
        }

        @Generated
        public RbelElementTreePrinterBuilder printColors(boolean printColors) {
            this.printColors$value = printColors;
            this.printColors$set = true;
            return this;
        }

        @Generated
        public RbelElementTreePrinterBuilder printParsingTimes(boolean printParsingTimes) {
            this.printParsingTimes$value = printParsingTimes;
            this.printParsingTimes$set = true;
            return this;
        }

        @Generated
        public RbelElementTreePrinterBuilder htmlEscaping(boolean htmlEscaping) {
            this.htmlEscaping$value = htmlEscaping;
            this.htmlEscaping$set = true;
            return this;
        }

        @Generated
        public RbelElementTreePrinterBuilder addJexlResponseLinkCssClass(boolean addJexlResponseLinkCssClass) {
            this.addJexlResponseLinkCssClass$value = addJexlResponseLinkCssClass;
            this.addJexlResponseLinkCssClass$set = true;
            return this;
        }

        @Generated
        public RbelElementTreePrinter build() {
            Class<? extends RbelFacet> onlyPrintElementsWithFacet$value = this.onlyPrintElementsWithFacet$value;
            if (!this.onlyPrintElementsWithFacet$set) {
                onlyPrintElementsWithFacet$value = RbelElementTreePrinter.$default$onlyPrintElementsWithFacet();
            }
            int maximumLevels$value = this.maximumLevels$value;
            if (!this.maximumLevels$set) {
                maximumLevels$value = RbelElementTreePrinter.$default$maximumLevels();
            }
            boolean printContent$value = this.printContent$value;
            if (!this.printContent$set) {
                printContent$value = RbelElementTreePrinter.$default$printContent();
            }
            boolean printKeys$value = this.printKeys$value;
            if (!this.printKeys$set) {
                printKeys$value = RbelElementTreePrinter.$default$printKeys();
            }
            boolean printFacets$value = this.printFacets$value;
            if (!this.printFacets$set) {
                printFacets$value = RbelElementTreePrinter.$default$printFacets();
            }
            boolean printColors$value = this.printColors$value;
            if (!this.printColors$set) {
                printColors$value = RbelElementTreePrinter.$default$printColors();
            }
            boolean printParsingTimes$value = this.printParsingTimes$value;
            if (!this.printParsingTimes$set) {
                printParsingTimes$value = RbelElementTreePrinter.$default$printParsingTimes();
            }
            boolean htmlEscaping$value = this.htmlEscaping$value;
            if (!this.htmlEscaping$set) {
                htmlEscaping$value = RbelElementTreePrinter.$default$htmlEscaping();
            }
            boolean addJexlResponseLinkCssClass$value = this.addJexlResponseLinkCssClass$value;
            if (!this.addJexlResponseLinkCssClass$set) {
                addJexlResponseLinkCssClass$value = RbelElementTreePrinter.$default$addJexlResponseLinkCssClass();
            }
            return new RbelElementTreePrinter(this.rootElement, onlyPrintElementsWithFacet$value, maximumLevels$value, printContent$value, printKeys$value, printFacets$value, printColors$value, printParsingTimes$value, htmlEscaping$value, addJexlResponseLinkCssClass$value);
        }

        @Generated
        public String toString() {
            return "RbelElementTreePrinter.RbelElementTreePrinterBuilder(rootElement=" + String.valueOf(this.rootElement) + ", onlyPrintElementsWithFacet$value=" + String.valueOf(this.onlyPrintElementsWithFacet$value) + ", maximumLevels$value=" + this.maximumLevels$value + ", printContent$value=" + this.printContent$value + ", printKeys$value=" + this.printKeys$value + ", printFacets$value=" + this.printFacets$value + ", printColors$value=" + this.printColors$value + ", printParsingTimes$value=" + this.printParsingTimes$value + ", htmlEscaping$value=" + this.htmlEscaping$value + ", addJexlResponseLinkCssClass$value=" + this.addJexlResponseLinkCssClass$value + ")";
        }
    }
}

