/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.decorator;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelHostnameFacet;
import de.gematik.rbellogger.util.GlobalServerMap;
import de.gematik.rbellogger.util.RbelSocketAddress;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;

public class ServernameFromSpyPortMapping
implements Function<RbelElement, Optional<String>> {
    @Override
    public Optional<String> apply(RbelElement element) {
        return this.findBundledServerNameForHostnameFacet(element);
    }

    private Optional<String> findBundledServerNameForHostnameFacet(RbelElement hostNameElement) {
        Integer port = this.extractPort(hostNameElement).orElseThrow(() -> new IllegalStateException("failed to extract port"));
        return GlobalServerMap.getServerNameForPort((int)port);
    }

    private Optional<Integer> extractPort(RbelElement hostNameElement) {
        return hostNameElement.getFacet(RbelHostnameFacet.class).map(RbelHostnameFacet::toRbelSocketAddress).map(RbelSocketAddress::getPort);
    }

    @Generated
    public ServernameFromSpyPortMapping() {
    }
}

