/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.decorator;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelHostnameFacet;
import de.gematik.rbellogger.data.core.RbelRequestFacet;
import de.gematik.rbellogger.data.core.RbelResponseFacet;
import de.gematik.rbellogger.data.core.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.util.RbelSocketAddress;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;

public class ServerNameFromHostname
implements Function<RbelElement, Optional<String>> {
    @Override
    public Optional<String> apply(RbelElement hostNameElement) {
        Optional<RbelHostnameFacet> hostnameFacet = hostNameElement.getFacet(RbelHostnameFacet.class);
        if (hostnameFacet.isEmpty()) {
            return Optional.empty();
        }
        RbelSocketAddress socketAddress = hostnameFacet.get().toRbelSocketAddress();
        RbelElement msgElement = hostNameElement.findRootElement();
        if (socketAddress.isLoopbackAddress() && (msgElement.hasFacet(RbelRequestFacet.class) && msgElement.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getSender).filter(el -> el == hostNameElement).isPresent() || msgElement.hasFacet(RbelResponseFacet.class) && msgElement.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getReceiver).filter(el -> el == hostNameElement).isPresent())) {
            return Optional.of("local client");
        }
        return Optional.empty();
    }

    @Generated
    public ServerNameFromHostname() {
    }
}

