/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.decorator;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelHostnameFacet;
import de.gematik.rbellogger.data.core.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.data.decorator.DoesNothingModifier;
import de.gematik.rbellogger.data.decorator.MessageMetadataModifier;
import de.gematik.test.tiger.common.config.TigerConfigurationKeys;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddBundledServerNamesModifier
implements MessageMetadataModifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AddBundledServerNamesModifier.class);
    private final Function<RbelElement, Optional<String>> bundledServernameSupplier;

    private AddBundledServerNamesModifier(Function<RbelElement, Optional<String>> bundledServernameSupplier) {
        this.bundledServernameSupplier = bundledServernameSupplier;
    }

    public static MessageMetadataModifier createModifier(Function<RbelElement, Optional<String>> bundledServernameSupplier) {
        if (Boolean.TRUE.equals(TigerConfigurationKeys.TRAFFIC_VISUALIZATION_ACTIVE.getValueOrDefault())) {
            return new AddBundledServerNamesModifier(bundledServernameSupplier);
        }
        return new DoesNothingModifier();
    }

    @Override
    public void modifyMetadata(RbelElement message) {
        this.addBundledServerNamesToMessage(message);
    }

    private void addBundledServerNamesToMessage(RbelElement message) {
        message.getFacet(RbelTcpIpMessageFacet.class).ifPresent(rbelTcpIpMessageFacet -> {
            this.addBundledServerNameHostnameFacet(rbelTcpIpMessageFacet.getSender());
            this.addBundledServerNameHostnameFacet(rbelTcpIpMessageFacet.getReceiver());
        });
    }

    private void addBundledServerNameHostnameFacet(RbelElement hostNameElement) {
        this.bundledServernameSupplier.apply(hostNameElement).ifPresent(s -> this.setBundledServerName(hostNameElement, (String)s));
    }

    private void setBundledServerName(RbelElement hostNameElement, String bundledServerName) {
        RbelElement serverNameElement = RbelElement.wrap(hostNameElement, bundledServerName);
        log.atTrace().addArgument((Object)serverNameElement).addArgument(() -> hostNameElement.getFacetOrFail(RbelHostnameFacet.class).toRbelSocketAddress()).log("Adding bundled server name '{}' to hostname facet of element: {}");
        hostNameElement.getFacet(RbelHostnameFacet.class).ifPresent(rbelHostnameFacet -> rbelHostnameFacet.setBundledServerName(Optional.of(serverNameElement)));
    }
}

