/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.core;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.data.core.RbelHostnameFacet;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelMessageRenderer;
import de.gematik.rbellogger.util.RbelSocketAddress;
import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelTcpIpMessageFacet
implements RbelFacet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelTcpIpMessageFacet.class);
    private final Long sequenceNumber;
    private final String receivedFromRemoteWithUrl;
    private final RbelElement sender;
    private final RbelElement receiver;

    public static Long getSequenceNumber(RbelElement msg) {
        while (msg.getParentNode() != null) {
            msg = msg.getParentNode();
        }
        return msg.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getSequenceNumber).orElse(-1L);
    }

    @Override
    public RbelMultiMap<RbelElement> getChildElements() {
        return new RbelMultiMap<RbelElement>().with("sender", this.sender).with("receiver", this.receiver);
    }

    public Optional<RbelSocketAddress> getSenderHostname() {
        return this.hostname(this.sender).map(RbelHostnameFacet::toRbelSocketAddress);
    }

    public Optional<RbelSocketAddress> getReceiverHostname() {
        return this.hostname(this.receiver).map(RbelHostnameFacet::toRbelSocketAddress);
    }

    private Optional<RbelHostnameFacet> hostname(RbelElement element) {
        return element.getFacet(RbelHostnameFacet.class);
    }

    public boolean isSameDirectionAs(RbelElement previousMessage) {
        return previousMessage.getFacet(RbelTcpIpMessageFacet.class).map(this::compareDirectionWith).orElse(false);
    }

    public boolean compareDirectionWith(RbelTcpIpMessageFacet other) {
        RbelHostnameFacet otherSender = other.getSender().getFacet(RbelHostnameFacet.class).orElse(null);
        RbelHostnameFacet otherReceiver = other.getReceiver().getFacet(RbelHostnameFacet.class).orElse(null);
        RbelHostnameFacet thisSender = this.getSender().getFacet(RbelHostnameFacet.class).orElse(null);
        RbelHostnameFacet thisReceiver = this.getReceiver().getFacet(RbelHostnameFacet.class).orElse(null);
        if (otherSender == null || otherReceiver == null || thisSender == null || thisReceiver == null) {
            return false;
        }
        return thisSender.domainAndPortEquals(otherSender) && thisReceiver.domainAndPortEquals(otherReceiver);
    }

    @Generated
    public static RbelTcpIpMessageFacetBuilder builder() {
        return new RbelTcpIpMessageFacetBuilder();
    }

    @Generated
    public RbelTcpIpMessageFacetBuilder toBuilder() {
        return new RbelTcpIpMessageFacetBuilder().sequenceNumber(this.sequenceNumber).receivedFromRemoteWithUrl(this.receivedFromRemoteWithUrl).sender(this.sender).receiver(this.receiver);
    }

    @Generated
    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Generated
    public String getReceivedFromRemoteWithUrl() {
        return this.receivedFromRemoteWithUrl;
    }

    @Generated
    public RbelElement getSender() {
        return this.sender;
    }

    @Generated
    public RbelElement getReceiver() {
        return this.receiver;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelTcpIpMessageFacet)) {
            return false;
        }
        RbelTcpIpMessageFacet other = (RbelTcpIpMessageFacet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$sequenceNumber = this.getSequenceNumber();
        Long other$sequenceNumber = other.getSequenceNumber();
        if (this$sequenceNumber == null ? other$sequenceNumber != null : !((Object)this$sequenceNumber).equals(other$sequenceNumber)) {
            return false;
        }
        String this$receivedFromRemoteWithUrl = this.getReceivedFromRemoteWithUrl();
        String other$receivedFromRemoteWithUrl = other.getReceivedFromRemoteWithUrl();
        if (this$receivedFromRemoteWithUrl == null ? other$receivedFromRemoteWithUrl != null : !this$receivedFromRemoteWithUrl.equals(other$receivedFromRemoteWithUrl)) {
            return false;
        }
        RbelElement this$sender = this.getSender();
        RbelElement other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
            return false;
        }
        RbelElement this$receiver = this.getReceiver();
        RbelElement other$receiver = other.getReceiver();
        return !(this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelTcpIpMessageFacet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $sequenceNumber = this.getSequenceNumber();
        result = result * 59 + ($sequenceNumber == null ? 43 : ((Object)$sequenceNumber).hashCode());
        String $receivedFromRemoteWithUrl = this.getReceivedFromRemoteWithUrl();
        result = result * 59 + ($receivedFromRemoteWithUrl == null ? 43 : $receivedFromRemoteWithUrl.hashCode());
        RbelElement $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
        RbelElement $receiver = this.getReceiver();
        result = result * 59 + ($receiver == null ? 43 : $receiver.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelTcpIpMessageFacet(sequenceNumber=" + this.getSequenceNumber() + ", receivedFromRemoteWithUrl=" + this.getReceivedFromRemoteWithUrl() + ", sender=" + String.valueOf(this.getSender()) + ", receiver=" + String.valueOf(this.getReceiver()) + ")";
    }

    @ConstructorProperties(value={"sequenceNumber", "receivedFromRemoteWithUrl", "sender", "receiver"})
    @Generated
    public RbelTcpIpMessageFacet(Long sequenceNumber, String receivedFromRemoteWithUrl, RbelElement sender, RbelElement receiver) {
        this.sequenceNumber = sequenceNumber;
        this.receivedFromRemoteWithUrl = receivedFromRemoteWithUrl;
        this.sender = sender;
        this.receiver = receiver;
    }

    static {
        RbelHtmlRenderer.registerFacetRenderer(new RbelMessageRenderer());
    }

    @Generated
    public static class RbelTcpIpMessageFacetBuilder {
        @Generated
        private Long sequenceNumber;
        @Generated
        private String receivedFromRemoteWithUrl;
        @Generated
        private RbelElement sender;
        @Generated
        private RbelElement receiver;

        @Generated
        RbelTcpIpMessageFacetBuilder() {
        }

        @Generated
        public RbelTcpIpMessageFacetBuilder sequenceNumber(Long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        @Generated
        public RbelTcpIpMessageFacetBuilder receivedFromRemoteWithUrl(String receivedFromRemoteWithUrl) {
            this.receivedFromRemoteWithUrl = receivedFromRemoteWithUrl;
            return this;
        }

        @Generated
        public RbelTcpIpMessageFacetBuilder sender(RbelElement sender) {
            this.sender = sender;
            return this;
        }

        @Generated
        public RbelTcpIpMessageFacetBuilder receiver(RbelElement receiver) {
            this.receiver = receiver;
            return this;
        }

        @Generated
        public RbelTcpIpMessageFacet build() {
            return new RbelTcpIpMessageFacet(this.sequenceNumber, this.receivedFromRemoteWithUrl, this.sender, this.receiver);
        }

        @Generated
        public String toString() {
            return "RbelTcpIpMessageFacet.RbelTcpIpMessageFacetBuilder(sequenceNumber=" + this.sequenceNumber + ", receivedFromRemoteWithUrl=" + this.receivedFromRemoteWithUrl + ", sender=" + String.valueOf(this.sender) + ", receiver=" + String.valueOf(this.receiver) + ")";
        }
    }
}

