/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.core;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelNoteFacet;
import de.gematik.rbellogger.data.core.RbelTcpIpMessageFacet;
import java.util.Comparator;
import lombok.Generated;

public class RbelMismatchNoteFacet
extends RbelNoteFacet
implements Comparable<RbelMismatchNoteFacet> {
    public static final Comparator<RbelMismatchNoteFacet> COMPARATOR = Comparator.comparing(RbelMismatchNoteFacet::getMismatchType).thenComparingLong(RbelMismatchNoteFacet::getSequenceNumber).thenComparing(RbelMismatchNoteFacet::getRbelPath).thenComparing(RbelNoteFacet::getValue);
    private final MismatchType mismatchType;
    private final long sequenceNumber;
    private final String rbelPath;

    @Override
    public int compareTo(RbelMismatchNoteFacet o) {
        return COMPARATOR.compare(this, o);
    }

    public RbelMismatchNoteFacet(MismatchType mismatchType, String value, RbelElement mismatchedNode) {
        super(value, RbelNoteFacet.NoteStyling.ERROR);
        this.mismatchType = mismatchType;
        this.sequenceNumber = RbelTcpIpMessageFacet.getSequenceNumber(mismatchedNode);
        this.rbelPath = mismatchedNode.getParentNode() != null ? "$." + mismatchedNode.findNodePath() : "$";
    }

    public void removeFrom(RbelElement element) {
        if (element.getParentNode() != null) {
            element.getFacets().remove(this);
        } else {
            element.findElement(this.rbelPath).ifPresent(n -> n.getFacets().remove(this));
        }
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelMismatchNoteFacet)) {
            return false;
        }
        RbelMismatchNoteFacet other = (RbelMismatchNoteFacet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getSequenceNumber() != other.getSequenceNumber()) {
            return false;
        }
        MismatchType this$mismatchType = this.getMismatchType();
        MismatchType other$mismatchType = other.getMismatchType();
        if (this$mismatchType == null ? other$mismatchType != null : !((Object)((Object)this$mismatchType)).equals((Object)other$mismatchType)) {
            return false;
        }
        String this$rbelPath = this.getRbelPath();
        String other$rbelPath = other.getRbelPath();
        return !(this$rbelPath == null ? other$rbelPath != null : !this$rbelPath.equals(other$rbelPath));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelMismatchNoteFacet;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $sequenceNumber = this.getSequenceNumber();
        result = result * 59 + (int)($sequenceNumber >>> 32 ^ $sequenceNumber);
        MismatchType $mismatchType = this.getMismatchType();
        result = result * 59 + ($mismatchType == null ? 43 : ((Object)((Object)$mismatchType)).hashCode());
        String $rbelPath = this.getRbelPath();
        result = result * 59 + ($rbelPath == null ? 43 : $rbelPath.hashCode());
        return result;
    }

    @Generated
    public MismatchType getMismatchType() {
        return this.mismatchType;
    }

    @Generated
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Generated
    public String getRbelPath() {
        return this.rbelPath;
    }

    public static enum MismatchType {
        VALUE_MISMATCH,
        MISSING_NODE,
        WRONG_PATH,
        FILTER_MISMATCH,
        AMBIGUOUS,
        UNKNOWN;

    }
}

