/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.core;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.core.RbelValueFacet;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import lombok.Generated;

public class RbelLazyValueFacet<T>
implements RbelValueFacet<T> {
    private final Supplier<T> valueSupplier;
    private WeakReference<AtomicReference<T>> cachedValue = new WeakReference<Object>(null);

    public RbelLazyValueFacet(Supplier<T> valueSupplier) {
        this.valueSupplier = valueSupplier;
    }

    @Override
    public synchronized T getValue() {
        AtomicReference<T> value = (AtomicReference<T>)this.cachedValue.get();
        if (value == null) {
            value = new AtomicReference<T>(this.valueSupplier.get());
            this.cachedValue = new WeakReference<AtomicReference<AtomicReference<T>>>(value);
        }
        return (T)value.get();
    }

    @Override
    public RbelMultiMap<RbelElement> getChildElements() {
        return new RbelMultiMap<RbelElement>();
    }

    @Generated
    public static <T> RbelLazyValueFacetBuilder<T> builder() {
        return new RbelLazyValueFacetBuilder();
    }

    @Generated
    public static class RbelLazyValueFacetBuilder<T> {
        @Generated
        private Supplier<T> valueSupplier;

        @Generated
        RbelLazyValueFacetBuilder() {
        }

        @Generated
        public RbelLazyValueFacetBuilder<T> valueSupplier(Supplier<T> valueSupplier) {
            this.valueSupplier = valueSupplier;
            return this;
        }

        @Generated
        public RbelLazyValueFacet<T> build() {
            return new RbelLazyValueFacet<T>(this.valueSupplier);
        }

        @Generated
        public String toString() {
            return "RbelLazyValueFacet.RbelLazyValueFacetBuilder(valueSupplier=" + String.valueOf(this.valueSupplier) + ")";
        }
    }
}

