/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.core;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.util.RbelInternetAddress;
import de.gematik.rbellogger.util.RbelInternetAddressParser;
import de.gematik.rbellogger.util.RbelSocketAddress;
import java.beans.ConstructorProperties;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelHostnameFacet
implements RbelFacet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelHostnameFacet.class);
    private final RbelElement port;
    private final RbelElement domain;
    private Optional<RbelElement> bundledServerName;

    public static RbelElement buildRbelHostnameFacet(RbelElement parentNode, RbelSocketAddress rbelSocketAddress) {
        return RbelHostnameFacet.buildRbelHostnameFacet(parentNode, rbelSocketAddress, null);
    }

    public static RbelElement buildRbelHostnameFacet(RbelElement parentNode, RbelSocketAddress rbelSocketAddress, String bundledServerName) {
        if (rbelSocketAddress == null) {
            return new RbelElement(null, parentNode);
        }
        RbelElement result = new RbelElement(rbelSocketAddress.toString().getBytes(StandardCharsets.UTF_8), parentNode);
        result.addFacet(RbelHostnameFacet.builder().port(RbelElement.wrap(result, rbelSocketAddress.getPort())).domain(RbelElement.wrap(result, rbelSocketAddress.printHostname())).bundledServerName(Optional.ofNullable(bundledServerName).map(bundledName -> RbelElement.wrap(result, bundledName))).build());
        return result;
    }

    @Override
    public RbelMultiMap<RbelElement> getChildElements() {
        return new RbelMultiMap<RbelElement>().withSkipIfNull("bundledServerName", this.bundledServerName.orElse(null)).with("port", this.port).with("domain", this.domain);
    }

    public String toString() {
        return this.toRbelSocketAddress().toString();
    }

    public RbelSocketAddress toRbelSocketAddress() {
        RbelInternetAddress localAddress = RbelInternetAddressParser.parseInetAddress((String)this.domain.getRawStringContent());
        return RbelSocketAddress.builder().address(this.bundledServerName.flatMap(el -> el.seekValue(String.class)).map(RbelInternetAddressParser::parseInetAddress).map(bsn -> RbelHostnameFacet.combineHostnameAndIpAddress(bsn, localAddress)).orElse(localAddress)).port(this.port.seekValue(Integer.class).orElse(0).intValue()).build();
    }

    private static RbelInternetAddress combineHostnameAndIpAddress(RbelInternetAddress bundledServerName, RbelInternetAddress localAddress) {
        return new RbelInternetAddress(bundledServerName.getHostname(), localAddress.getIpAddress());
    }

    public static Optional<String> tryToExtractServerName(RbelElement element) {
        Optional<RbelHostnameFacet> hostnameFacet = element.getFacet(RbelHostnameFacet.class);
        if (hostnameFacet.isEmpty()) {
            return Optional.empty();
        }
        return hostnameFacet.flatMap(RbelHostnameFacet::getBundledServerName).filter(e -> e.getRawStringContent() != null).flatMap(e -> Optional.of(e.getRawStringContent())).or(() -> hostnameFacet.map(RbelHostnameFacet::toRbelSocketAddress).map(RbelSocketAddress::getAddress).map(RbelInternetAddress::printValidHostname).filter(StringUtils::isNotEmpty)).or(() -> hostnameFacet.map(RbelHostnameFacet::getDomain).map(RbelElement::getRawStringContent).filter(StringUtils::isNotEmpty));
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.port).append((Object)this.domain).append(this.bundledServerName).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equals((RbelHostnameFacet)obj);
    }

    public boolean equals(RbelHostnameFacet other) {
        return this.domainAndPortEquals(other);
    }

    public boolean domainAndPortEquals(RbelHostnameFacet other) {
        return Objects.equals(this.getPort().seekValue(), other.getPort().seekValue()) && this.domainMatches(this.getDomain().printValue(), other.getDomain().printValue());
    }

    private boolean domainMatches(Optional<String> thisDomain, Optional<String> otherDomain) {
        return thisDomain.map(Object::toString).map(RbelHostnameFacet::canonicalize).map(thisHost -> otherDomain.map(Object::toString).map(RbelHostnameFacet::canonicalize).map(thisHost::equals).orElse(false)).orElse(false);
    }

    private static String canonicalize(String hostname) {
        try {
            return InetAddress.getByName(hostname).getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            return hostname;
        }
    }

    @Generated
    private static Optional<RbelElement> $default$bundledServerName() {
        return Optional.empty();
    }

    @Generated
    public static RbelHostnameFacetBuilder builder() {
        return new RbelHostnameFacetBuilder();
    }

    @Generated
    public RbelHostnameFacetBuilder toBuilder() {
        return new RbelHostnameFacetBuilder().port(this.port).domain(this.domain).bundledServerName(this.bundledServerName);
    }

    @Generated
    public RbelElement getPort() {
        return this.port;
    }

    @Generated
    public RbelElement getDomain() {
        return this.domain;
    }

    @Generated
    public Optional<RbelElement> getBundledServerName() {
        return this.bundledServerName;
    }

    @Generated
    public void setBundledServerName(Optional<RbelElement> bundledServerName) {
        this.bundledServerName = bundledServerName;
    }

    @ConstructorProperties(value={"port", "domain", "bundledServerName"})
    @Generated
    private RbelHostnameFacet(RbelElement port, RbelElement domain, Optional<RbelElement> bundledServerName) {
        this.port = port;
        this.domain = domain;
        this.bundledServerName = bundledServerName;
    }

    @Generated
    public static class RbelHostnameFacetBuilder {
        @Generated
        private RbelElement port;
        @Generated
        private RbelElement domain;
        @Generated
        private boolean bundledServerName$set;
        @Generated
        private Optional<RbelElement> bundledServerName$value;

        @Generated
        RbelHostnameFacetBuilder() {
        }

        @Generated
        public RbelHostnameFacetBuilder port(RbelElement port) {
            this.port = port;
            return this;
        }

        @Generated
        public RbelHostnameFacetBuilder domain(RbelElement domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public RbelHostnameFacetBuilder bundledServerName(Optional<RbelElement> bundledServerName) {
            this.bundledServerName$value = bundledServerName;
            this.bundledServerName$set = true;
            return this;
        }

        @Generated
        public RbelHostnameFacet build() {
            Optional<RbelElement> bundledServerName$value = this.bundledServerName$value;
            if (!this.bundledServerName$set) {
                bundledServerName$value = RbelHostnameFacet.$default$bundledServerName();
            }
            return new RbelHostnameFacet(this.port, this.domain, bundledServerName$value);
        }

        @Generated
        public String toString() {
            return "RbelHostnameFacet.RbelHostnameFacetBuilder(port=" + String.valueOf(this.port) + ", domain=" + String.valueOf(this.domain) + ", bundledServerName$value=" + String.valueOf(this.bundledServerName$value) + ")";
        }
    }
}

