/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.util.RbelSocketAddress;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelMessageMetadata
implements RbelFacet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelMessageMetadata.class);
    public static final RbelMetadataValue<RbelSocketAddress> MESSAGE_SENDER = new RbelMetadataValue<RbelSocketAddress>("senderHostname", RbelSocketAddress.class);
    public static final RbelMetadataValue<RbelSocketAddress> MESSAGE_RECEIVER = new RbelMetadataValue<RbelSocketAddress>("receiverHostname", RbelSocketAddress.class);
    public static final RbelMetadataValue<ZonedDateTime> MESSAGE_TRANSMISSION_TIME = new RbelMetadataValue<ZonedDateTime>("timestamp", ZonedDateTime.class);
    public static final RbelMetadataValue<String> PREVIOUS_MESSAGE_UUID = new RbelMetadataValue<String>("previousMessageUuid", String.class);
    public static final RbelMetadataValue<String> PAIRED_MESSAGE_UUID = new RbelMetadataValue<String>("pairedMessageUuid", String.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule());
    private final Map<String, Object> metadata = new HashMap<String, Object>();

    public void addMetadata(String key, Object value) {
        if (value != null) {
            this.metadata.put(key, value);
        } else {
            this.metadata.remove(key);
        }
    }

    public Object getMetadata(String key) {
        return this.metadata.get(key);
    }

    public RbelMessageMetadata withSender(RbelSocketAddress sender) {
        this.addMetadata(MESSAGE_SENDER.getKey(), sender);
        return this;
    }

    public Optional<RbelSocketAddress> getSender() {
        return MESSAGE_SENDER.getValue(this);
    }

    public RbelMessageMetadata withReceiver(RbelSocketAddress receiver) {
        this.addMetadata(MESSAGE_RECEIVER.getKey(), receiver);
        return this;
    }

    public Optional<RbelSocketAddress> getReceiver() {
        return MESSAGE_RECEIVER.getValue(this);
    }

    public RbelMessageMetadata withTransmissionTime(ZonedDateTime timestamp) {
        this.addMetadata(MESSAGE_TRANSMISSION_TIME.getKey(), timestamp);
        return this;
    }

    public Optional<ZonedDateTime> getTransmissionTime() {
        return MESSAGE_TRANSMISSION_TIME.getValue(this);
    }

    public void forEach(BiConsumer<String, Object> consumer) {
        this.metadata.forEach(consumer);
    }

    public RbelMessageMetadata withPreviousMessage(String uuid) {
        this.addMetadata(PREVIOUS_MESSAGE_UUID.getKey(), uuid);
        return this;
    }

    public RbelMessageMetadata withPairedMessage(String uuid) {
        this.addMetadata(PAIRED_MESSAGE_UUID.getKey(), uuid);
        return this;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.metadata.entrySet()) {
            if (entry.getValue() == null) continue;
            result.put(entry.getKey(), entry.getValue().toString());
        }
        return result;
    }

    public static class RbelMetadataValue<T> {
        private final String key;
        private final Class<T> type;

        public Optional<T> getValue(RbelMessageMetadata metadata) {
            Object result = metadata.getMetadata(this.key);
            if (result == null) {
                return Optional.empty();
            }
            if (result.getClass().isAssignableFrom(this.type)) {
                return Optional.of(result);
            }
            try {
                return Optional.ofNullable(MAPPER.convertValue(result, this.type));
            }
            catch (Exception e) {
                try {
                    return Optional.ofNullable(MAPPER.readValue(result.toString(), this.type));
                }
                catch (Exception e1) {
                    throw new RuntimeException("Metadata Value for key " + this.key + " with value '" + String.valueOf(result) + "' can not be converted to " + this.type.getName() + ", it is of type " + result.getClass().getName(), e1);
                }
            }
        }

        public void putValue(RbelMessageMetadata metadata, T value) {
            metadata.addMetadata(this.key, value);
        }

        @ConstructorProperties(value={"key", "type"})
        @Generated
        public RbelMetadataValue(String key, Class<T> type) {
            this.key = key;
            this.type = type;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public Class<T> getType() {
            return this.type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RbelMetadataValue)) {
                return false;
            }
            RbelMetadataValue other = (RbelMetadataValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Class<T> this$type = this.getType();
            Class<T> other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RbelMetadataValue;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            Class<T> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RbelMessageMetadata.RbelMetadataValue(key=" + this.getKey() + ", type=" + String.valueOf(this.getType()) + ")";
        }
    }
}

