/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data;

import de.gematik.rbellogger.RbelConversionPhase;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.data.core.RbelNestedFacet;
import de.gematik.rbellogger.data.core.RbelNoteFacet;
import de.gematik.rbellogger.data.core.RbelRootFacet;
import de.gematik.rbellogger.data.core.RbelValueFacet;
import de.gematik.rbellogger.data.util.RbelElementTreePrinter;
import de.gematik.rbellogger.facets.http.RbelHttpMessageFacet;
import de.gematik.rbellogger.facets.http.RbelHttpRequestFacet;
import de.gematik.rbellogger.facets.http.RbelHttpResponseFacet;
import de.gematik.rbellogger.facets.jackson.RbelCborFacet;
import de.gematik.rbellogger.facets.jackson.RbelJsonFacet;
import de.gematik.rbellogger.util.RbelContent;
import de.gematik.rbellogger.util.RbelException;
import de.gematik.rbellogger.util.RbelJexlExecutor;
import de.gematik.rbellogger.util.RbelPathAble;
import de.gematik.rbellogger.util.RbelPathExecutor;
import de.gematik.test.tiger.exceptions.GenericTigerException;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelElement
extends RbelPathAble {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelElement.class);
    private final String uuid;
    private final RbelContent content;
    private WeakReference<Pair<String, Charset>> rawStringContent = new WeakReference<Object>(null);
    private final RbelElement parentNode;
    private final Queue<RbelFacet> facets = new ConcurrentLinkedQueue<RbelFacet>();
    private Optional<Charset> charset;
    private RbelConversionPhase conversionPhase = RbelConversionPhase.UNPARSED;
    private long size;
    private long conversionTimeInNanos = 0L;

    public byte[] getRawContent() {
        return this.content.isNull() ? null : this.content.toByteArray();
    }

    public RbelElement() {
        this(null, null);
    }

    public RbelElement(RbelElement parentNode) {
        this(null, parentNode);
    }

    public RbelElement(byte[] rawContent, RbelElement parentNode) {
        this(null, rawContent, parentNode, Optional.empty());
    }

    public RbelElement(RbelContent rawContent) {
        this(null, rawContent, null, Optional.empty());
    }

    public RbelElement(byte[] rawContent, RbelElement parentNode, Optional<Charset> charset) {
        this(null, rawContent, parentNode, charset);
    }

    public RbelElement(String uuid, byte[] rawContent, RbelElement parentNode, Optional<Charset> charset) {
        this(uuid, RbelContent.of(rawContent), parentNode, charset);
    }

    public RbelElement(@Nullable String uuid, RbelContent content, RbelElement parentNode, Optional<Charset> charset) {
        this.uuid = StringUtils.isNotEmpty((CharSequence)uuid) ? uuid : UUID.randomUUID().toString();
        this.content = content;
        this.parentNode = parentNode;
        this.charset = Objects.requireNonNullElseGet(charset, Optional::empty);
        this.size = content.size();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().uuid(this.uuid).content(this.content).parentNode(this.parentNode).charset((Charset)this.charset.orElse(null));
    }

    public void setUsedBytes(int usedBytes) {
        this.content.truncate(usedBytes);
        this.size = usedBytes;
    }

    public int getDepth() {
        int depth = 1;
        RbelElement current = this;
        while ((current = current.getParentNode()) != null) {
            ++depth;
        }
        return depth;
    }

    public static RbelElement wrap(byte[] rawValue, @NonNull RbelElement parentNode, Object value) {
        if (parentNode == null) {
            throw new NullPointerException("parentNode is marked non-null but is null");
        }
        return new RbelElement(rawValue, parentNode).addFacet(RbelValueFacet.of(value));
    }

    public static RbelElement wrap(@NonNull RbelElement parentNode, Object value) {
        if (parentNode == null) {
            throw new NullPointerException("parentNode is marked non-null but is null");
        }
        return new RbelElement(value.toString().getBytes(parentNode.getElementCharset()), parentNode).addFacet(RbelValueFacet.of(value));
    }

    public <T> Optional<T> getFacet(@NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        for (RbelFacet facet : this.facets) {
            if (!clazz.isAssignableFrom(facet.getClass())) continue;
            return Optional.of(clazz.cast(facet));
        }
        return Optional.empty();
    }

    public boolean hasFacet(Class<? extends RbelFacet> clazz) {
        for (RbelFacet entry : this.facets) {
            if (entry == null || !clazz.isAssignableFrom(entry.getClass())) continue;
            return true;
        }
        return false;
    }

    public RbelElement addFacet(RbelFacet facet) {
        this.facets.add(facet);
        return this;
    }

    public List<RbelElement> getChildNodes() {
        LinkedList<RbelElement> result = new LinkedList<RbelElement>();
        for (RbelFacet facet : this.facets) {
            Iterator<Map.Entry<String, RbelElement>> childElementIterator = facet.getChildElements().iterator();
            while (childElementIterator.hasNext()) {
                RbelElement child = childElementIterator.next().getValue();
                if (child == null) continue;
                result.add(child);
            }
        }
        return result;
    }

    public RbelMultiMap<RbelElement> getChildNodesWithKey() {
        RbelMultiMap<RbelElement> result = new RbelMultiMap<RbelElement>();
        for (RbelFacet facet : this.facets) {
            Iterator<Map.Entry<String, RbelElement>> childElementIterator = facet.getChildElements().iterator();
            while (childElementIterator.hasNext()) {
                Map.Entry<String, RbelElement> childElement = childElementIterator.next();
                if (childElement.getValue() == null) continue;
                result.put(childElement);
            }
        }
        return result;
    }

    public List<RbelElement> traverseAndReturnNestedMembers() {
        ArrayList<RbelElement> result = new ArrayList<RbelElement>();
        this.traverseAndReturnNestedMembers(result);
        return result;
    }

    public void traverseAndReturnNestedMembers(List<RbelElement> result) {
        for (RbelElement element : this.getChildNodes()) {
            if (element == null) continue;
            element.traverseAndReturnNestedMembersInternal(result);
        }
    }

    private void traverseAndReturnNestedMembersInternal(List<RbelElement> result) {
        log.atTrace().addArgument(this::findNodePath).addArgument(() -> this.facets.stream().map(Object::getClass).map(Class::getSimpleName).toList()).log("Traversing into {}: facets are {}");
        if (this.hasFacet(RbelRootFacet.class)) {
            result.add(this);
        } else {
            this.traverseAndReturnNestedMembers(result);
        }
    }

    public Optional<RbelElement> getFirst(String key) {
        return this.getChildNodesWithKey().stream().filter(entry -> ((String)entry.getKey()).equals(key)).map(Map.Entry::getValue).findFirst();
    }

    public List<RbelElement> getAll(String key) {
        return this.getChildNodesWithKey().stream().filter(entry -> ((String)entry.getKey()).equals(key)).map(Map.Entry::getValue).toList();
    }

    public List<RbelElement> findRbelPathMembers(String rbelPath) {
        return new RbelPathExecutor<RbelElement>(this, rbelPath).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getRawStringContent() {
        if (this.content.isNull()) {
            return null;
        }
        RbelContent rbelContent = this.content;
        synchronized (rbelContent) {
            Pair cachedValue = (Pair)this.rawStringContent.get();
            Charset elementCharset = this.getElementCharset();
            if (cachedValue == null || !elementCharset.equals(cachedValue.getRight())) {
                cachedValue = Pair.of((Object)new String(this.getRawContent(), elementCharset), (Object)elementCharset);
                this.rawStringContent = new WeakReference<Pair>(cachedValue);
            }
            return (String)cachedValue.getLeft();
        }
    }

    public Charset getElementCharset() {
        return this.charset.or(() -> Optional.ofNullable(this.parentNode).map(RbelElement::getElementCharset)).orElse(StandardCharsets.UTF_8);
    }

    public <T extends RbelFacet> T getFacetOrFail(Class<T> facetClass) {
        return (T)((RbelFacet)this.getFacet(facetClass).orElseThrow(() -> new RbelException("Facet not found: " + facetClass.getSimpleName())));
    }

    public String toString() {
        return "[RbelElement (" + this.uuid + ") with " + Optional.ofNullable(this.content).map(RbelContent::size).map(FileUtils::byteCountToDisplaySize).orElse("null") + " bytes at $." + this.findNodePath() + " with facets " + this.facets.stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(",")) + "]";
    }

    public Optional<Object> seekValue() {
        return this.getFacet(RbelValueFacet.class).map(RbelValueFacet::getValue);
    }

    public Optional<String> printValue() {
        return this.getFacet(RbelValueFacet.class).map(RbelValueFacet::getValue).map(value -> {
            String string;
            if (value instanceof byte[]) {
                byte[] ar = (byte[])value;
                string = Hex.toHexString((byte[])ar);
            } else {
                string = value.toString();
            }
            return string;
        });
    }

    public <T> Optional<T> seekValue(Class<T> clazz) {
        return this.getFacet(RbelValueFacet.class).map(RbelValueFacet::getValue).filter(clazz::isInstance).map(clazz::cast);
    }

    @Override
    public Optional<String> getKey() {
        if (this.parentNode == null) {
            return Optional.empty();
        }
        return this.findKeyInParentElement().map(Optional::of).orElseThrow(() -> new RbelException("Unable to find key for element " + String.valueOf(this)));
    }

    public void addOrReplaceFacet(RbelFacet facet) {
        this.getFacet(facet.getClass()).ifPresent(this.facets::remove);
        this.facets.add(facet);
    }

    public void removeFacetsOfType(Class<? extends RbelFacet> facetClass) {
        List<RbelFacet> facetsToBeRemoved = this.facets.stream().filter(facetClass::isInstance).toList();
        facetsToBeRemoved.forEach(this.facets::remove);
        facetsToBeRemoved.forEach(facet -> facet.facetRemovedCallback(this));
    }

    public Optional<RbelElement> findElement(String rbelPath) {
        List<RbelElement> resultList = this.findRbelPathMembers(rbelPath);
        if (resultList.isEmpty()) {
            return Optional.empty();
        }
        if (resultList.size() == 1) {
            return Optional.of(resultList.get(0));
        }
        throw new RbelPathNotUniqueException("RbelPath '" + rbelPath + "' is not unique! Found " + resultList.size() + " elements, expected only one!");
    }

    public String printTreeStructureWithoutColors() {
        return RbelElementTreePrinter.builder().rootElement(this).printColors(false).build().execute();
    }

    public String printTreeStructure() {
        return RbelElementTreePrinter.builder().rootElement(this).build().execute();
    }

    public String printTreeStructure(int maximumLevels, boolean printKeys) {
        return RbelElementTreePrinter.builder().rootElement(this).printKeys(printKeys).maximumLevels(maximumLevels).build().execute();
    }

    public List<RbelNoteFacet> getNotes() {
        return this.facets.stream().flatMap(facet -> {
            if (facet instanceof RbelNestedFacet) {
                RbelNestedFacet asRbelNestedFacet = (RbelNestedFacet)facet;
                if (asRbelNestedFacet.getNestedElement().hasFacet(RbelRootFacet.class)) {
                    return Stream.empty();
                }
                return asRbelNestedFacet.getNestedElement().getFacets().stream();
            }
            return Stream.of(facet);
        }).filter(RbelNoteFacet.class::isInstance).map(RbelNoteFacet.class::cast).toList();
    }

    public RbelElement findMessage() {
        RbelElement position = this;
        while (position.getParentNode() != null) {
            position = position.getParentNode();
        }
        return position;
    }

    @Override
    public List<RbelPathAble> descendToContentNodeIfAdvised() {
        if ((this.hasFacet(RbelJsonFacet.class) || this.hasFacet(RbelCborFacet.class)) && this.hasFacet(RbelNestedFacet.class)) {
            return List.of((RbelPathAble)this.getFacet(RbelNestedFacet.class).map(RbelNestedFacet::getNestedElement).orElseThrow(), this);
        }
        return List.of(this);
    }

    @Override
    public boolean shouldElementBeKeptInFinalResult() {
        return !this.hasFacet(RbelJsonFacet.class) && !this.hasFacet(RbelCborFacet.class) || !this.hasFacet(RbelNestedFacet.class);
    }

    public String printHttpDescription() {
        return this.getFacet(RbelHttpRequestFacet.class).map(req -> "HTTP " + req.getMethod().getRawStringContent() + " " + req.getPathAsString()).orElse("") + this.getFacet(RbelHttpResponseFacet.class).map(req -> "HTTP " + req.getResponseCode().getRawStringContent()).orElse("") + this.getFacet(RbelHttpMessageFacet.class).map(msg -> " with body '" + StringUtils.abbreviate((String)msg.getBody().getRawStringContent(), (int)30) + "'").orElse("");
    }

    public RbelElement findRootElement() {
        RbelElement result = this;
        RbelElement newResult = result.getParentNode();
        while (newResult != null) {
            result = newResult;
            newResult = result.getParentNode();
        }
        return result;
    }

    public <F extends RbelFacet> List<F> findAllNestedFacets(Class<F> rbelFacetClass) {
        return this.getChildNodes().stream().map(child -> RbelElement.findAllNestedElementsWithFacet(child, rbelFacetClass)).flatMap(Collection::stream).map(RbelElement::getFacets).flatMap(Collection::stream).filter(rbelFacetClass::isInstance).map(rbelFacetClass::cast).toList();
    }

    private static List<RbelElement> findAllNestedElementsWithFacet(RbelElement target, Class<? extends RbelFacet> rbelFacetClass) {
        ArrayList<RbelElement> result = new ArrayList<RbelElement>();
        if (target.hasFacet(rbelFacetClass)) {
            result.add(target);
        }
        target.getChildNodes().forEach(child -> result.addAll(RbelElement.findAllNestedElementsWithFacet(child, rbelFacetClass)));
        return result;
    }

    public RbelConversionPhase getConversionPhase() {
        if (this.parentNode == null) {
            return this.conversionPhase;
        }
        return this.parentNode.getConversionPhase();
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public RbelContent getContent() {
        return this.content;
    }

    @Override
    @Generated
    public RbelElement getParentNode() {
        return this.parentNode;
    }

    @Generated
    public Queue<RbelFacet> getFacets() {
        return this.facets;
    }

    @Generated
    public Optional<Charset> getCharset() {
        return this.charset;
    }

    @Generated
    public long getSize() {
        return this.size;
    }

    @Generated
    public long getConversionTimeInNanos() {
        return this.conversionTimeInNanos;
    }

    @Generated
    public void setCharset(Optional<Charset> charset) {
        this.charset = charset;
    }

    @Generated
    public void setConversionPhase(RbelConversionPhase conversionPhase) {
        this.conversionPhase = conversionPhase;
    }

    @Generated
    public void setConversionTimeInNanos(long conversionTimeInNanos) {
        this.conversionTimeInNanos = conversionTimeInNanos;
    }

    static {
        RbelJexlExecutor.initialize();
    }

    public static class Builder {
        String uuid;
        RbelContent content = RbelContent.builder().build();
        RbelElement parentNode;
        Optional<Charset> charset;

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder rawContent(byte[] rawContent) {
            this.content = rawContent != null ? RbelContent.of(rawContent) : RbelContent.builder().build();
            return this;
        }

        public Builder content(RbelContent content) {
            this.content = content != null ? content : RbelContent.builder().build();
            return this;
        }

        public Builder parentNode(RbelElement parentNode) {
            this.parentNode = parentNode;
            return this;
        }

        public Builder charset(Charset charset) {
            this.charset = Optional.ofNullable(charset);
            return this;
        }

        public Builder charset(Optional<Charset> charset) {
            this.charset = charset;
            return this;
        }

        public RbelElement build() {
            return new RbelElement(this.uuid, this.content, this.parentNode, this.charset);
        }
    }

    private static class RbelPathNotUniqueException
    extends GenericTigerException {
        public RbelPathNotUniqueException(String s) {
            super(s);
        }
    }
}

