/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.configuration;

import de.gematik.rbellogger.RbelConverter;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.captures.RbelCapturer;
import de.gematik.rbellogger.key.RbelKey;
import java.beans.ConstructorProperties;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;

public class RbelConfiguration {
    private List<RbelConverterPlugin> postConversionListener;
    private List<String> activateRbelParsingFor;
    private List<Consumer<RbelConverter>> initializers;
    private Map<String, RbelKey> keys;
    private RbelCapturer capturer;
    private int rbelBufferSizeInMb;
    private int skipParsingWhenMessageLargerThanKb;
    private boolean manageBuffer;
    private Boolean lenientHttpParsing;

    public RbelConfiguration addPostConversionListener(RbelConverterPlugin listener) {
        this.postConversionListener.add(listener);
        return this;
    }

    public RbelConfiguration addInitializer(Consumer<RbelConverter> initializer) {
        this.initializers.add(initializer);
        return this;
    }

    public RbelConfiguration addKey(String keyId, Key key, int precedence) {
        this.keys.put(keyId, RbelKey.builder().key(key).keyName(keyId).precedence(precedence).build());
        return this;
    }

    public RbelConfiguration addCapturer(RbelCapturer capturer) {
        this.capturer = capturer;
        return this;
    }

    public RbelConfiguration activateConversionFor(String key) {
        this.activateRbelParsingFor.add(key);
        return this;
    }

    public RbelLogger constructRbelLogger() {
        return RbelLogger.build(this);
    }

    @Generated
    private static List<RbelConverterPlugin> $default$postConversionListener() {
        return new ArrayList<RbelConverterPlugin>();
    }

    @Generated
    private static List<String> $default$activateRbelParsingFor() {
        return new ArrayList<String>();
    }

    @Generated
    private static List<Consumer<RbelConverter>> $default$initializers() {
        return new ArrayList<Consumer<RbelConverter>>();
    }

    @Generated
    private static Map<String, RbelKey> $default$keys() {
        return new HashMap<String, RbelKey>();
    }

    @Generated
    private static int $default$rbelBufferSizeInMb() {
        return 1024;
    }

    @Generated
    private static int $default$skipParsingWhenMessageLargerThanKb() {
        return 16000;
    }

    @Generated
    private static boolean $default$manageBuffer() {
        return false;
    }

    @Generated
    public static RbelConfigurationBuilder builder() {
        return new RbelConfigurationBuilder();
    }

    @Generated
    public List<RbelConverterPlugin> getPostConversionListener() {
        return this.postConversionListener;
    }

    @Generated
    public List<String> getActivateRbelParsingFor() {
        return this.activateRbelParsingFor;
    }

    @Generated
    public List<Consumer<RbelConverter>> getInitializers() {
        return this.initializers;
    }

    @Generated
    public Map<String, RbelKey> getKeys() {
        return this.keys;
    }

    @Generated
    public RbelCapturer getCapturer() {
        return this.capturer;
    }

    @Generated
    public int getRbelBufferSizeInMb() {
        return this.rbelBufferSizeInMb;
    }

    @Generated
    public int getSkipParsingWhenMessageLargerThanKb() {
        return this.skipParsingWhenMessageLargerThanKb;
    }

    @Generated
    public boolean isManageBuffer() {
        return this.manageBuffer;
    }

    @Generated
    public Boolean getLenientHttpParsing() {
        return this.lenientHttpParsing;
    }

    @Generated
    public RbelConfiguration setPostConversionListener(List<RbelConverterPlugin> postConversionListener) {
        this.postConversionListener = postConversionListener;
        return this;
    }

    @Generated
    public RbelConfiguration setActivateRbelParsingFor(List<String> activateRbelParsingFor) {
        this.activateRbelParsingFor = activateRbelParsingFor;
        return this;
    }

    @Generated
    public RbelConfiguration setInitializers(List<Consumer<RbelConverter>> initializers) {
        this.initializers = initializers;
        return this;
    }

    @Generated
    public RbelConfiguration setKeys(Map<String, RbelKey> keys) {
        this.keys = keys;
        return this;
    }

    @Generated
    public RbelConfiguration setCapturer(RbelCapturer capturer) {
        this.capturer = capturer;
        return this;
    }

    @Generated
    public RbelConfiguration setRbelBufferSizeInMb(int rbelBufferSizeInMb) {
        this.rbelBufferSizeInMb = rbelBufferSizeInMb;
        return this;
    }

    @Generated
    public RbelConfiguration setSkipParsingWhenMessageLargerThanKb(int skipParsingWhenMessageLargerThanKb) {
        this.skipParsingWhenMessageLargerThanKb = skipParsingWhenMessageLargerThanKb;
        return this;
    }

    @Generated
    public RbelConfiguration setManageBuffer(boolean manageBuffer) {
        this.manageBuffer = manageBuffer;
        return this;
    }

    @Generated
    public RbelConfiguration setLenientHttpParsing(Boolean lenientHttpParsing) {
        this.lenientHttpParsing = lenientHttpParsing;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelConfiguration)) {
            return false;
        }
        RbelConfiguration other = (RbelConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRbelBufferSizeInMb() != other.getRbelBufferSizeInMb()) {
            return false;
        }
        if (this.getSkipParsingWhenMessageLargerThanKb() != other.getSkipParsingWhenMessageLargerThanKb()) {
            return false;
        }
        if (this.isManageBuffer() != other.isManageBuffer()) {
            return false;
        }
        Boolean this$lenientHttpParsing = this.getLenientHttpParsing();
        Boolean other$lenientHttpParsing = other.getLenientHttpParsing();
        if (this$lenientHttpParsing == null ? other$lenientHttpParsing != null : !((Object)this$lenientHttpParsing).equals(other$lenientHttpParsing)) {
            return false;
        }
        List<RbelConverterPlugin> this$postConversionListener = this.getPostConversionListener();
        List<RbelConverterPlugin> other$postConversionListener = other.getPostConversionListener();
        if (this$postConversionListener == null ? other$postConversionListener != null : !((Object)this$postConversionListener).equals(other$postConversionListener)) {
            return false;
        }
        List<String> this$activateRbelParsingFor = this.getActivateRbelParsingFor();
        List<String> other$activateRbelParsingFor = other.getActivateRbelParsingFor();
        if (this$activateRbelParsingFor == null ? other$activateRbelParsingFor != null : !((Object)this$activateRbelParsingFor).equals(other$activateRbelParsingFor)) {
            return false;
        }
        List<Consumer<RbelConverter>> this$initializers = this.getInitializers();
        List<Consumer<RbelConverter>> other$initializers = other.getInitializers();
        if (this$initializers == null ? other$initializers != null : !((Object)this$initializers).equals(other$initializers)) {
            return false;
        }
        Map<String, RbelKey> this$keys = this.getKeys();
        Map<String, RbelKey> other$keys = other.getKeys();
        if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
            return false;
        }
        RbelCapturer this$capturer = this.getCapturer();
        RbelCapturer other$capturer = other.getCapturer();
        return !(this$capturer == null ? other$capturer != null : !((Object)this$capturer).equals(other$capturer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRbelBufferSizeInMb();
        result = result * 59 + this.getSkipParsingWhenMessageLargerThanKb();
        result = result * 59 + (this.isManageBuffer() ? 79 : 97);
        Boolean $lenientHttpParsing = this.getLenientHttpParsing();
        result = result * 59 + ($lenientHttpParsing == null ? 43 : ((Object)$lenientHttpParsing).hashCode());
        List<RbelConverterPlugin> $postConversionListener = this.getPostConversionListener();
        result = result * 59 + ($postConversionListener == null ? 43 : ((Object)$postConversionListener).hashCode());
        List<String> $activateRbelParsingFor = this.getActivateRbelParsingFor();
        result = result * 59 + ($activateRbelParsingFor == null ? 43 : ((Object)$activateRbelParsingFor).hashCode());
        List<Consumer<RbelConverter>> $initializers = this.getInitializers();
        result = result * 59 + ($initializers == null ? 43 : ((Object)$initializers).hashCode());
        Map<String, RbelKey> $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        RbelCapturer $capturer = this.getCapturer();
        result = result * 59 + ($capturer == null ? 43 : ((Object)$capturer).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelConfiguration(postConversionListener=" + String.valueOf(this.getPostConversionListener()) + ", activateRbelParsingFor=" + String.valueOf(this.getActivateRbelParsingFor()) + ", initializers=" + String.valueOf(this.getInitializers()) + ", keys=" + String.valueOf(this.getKeys()) + ", capturer=" + String.valueOf(this.getCapturer()) + ", rbelBufferSizeInMb=" + this.getRbelBufferSizeInMb() + ", skipParsingWhenMessageLargerThanKb=" + this.getSkipParsingWhenMessageLargerThanKb() + ", manageBuffer=" + this.isManageBuffer() + ", lenientHttpParsing=" + this.getLenientHttpParsing() + ")";
    }

    @ConstructorProperties(value={"postConversionListener", "activateRbelParsingFor", "initializers", "keys", "capturer", "rbelBufferSizeInMb", "skipParsingWhenMessageLargerThanKb", "manageBuffer", "lenientHttpParsing"})
    @Generated
    public RbelConfiguration(List<RbelConverterPlugin> postConversionListener, List<String> activateRbelParsingFor, List<Consumer<RbelConverter>> initializers, Map<String, RbelKey> keys, RbelCapturer capturer, int rbelBufferSizeInMb, int skipParsingWhenMessageLargerThanKb, boolean manageBuffer, Boolean lenientHttpParsing) {
        this.postConversionListener = postConversionListener;
        this.activateRbelParsingFor = activateRbelParsingFor;
        this.initializers = initializers;
        this.keys = keys;
        this.capturer = capturer;
        this.rbelBufferSizeInMb = rbelBufferSizeInMb;
        this.skipParsingWhenMessageLargerThanKb = skipParsingWhenMessageLargerThanKb;
        this.manageBuffer = manageBuffer;
        this.lenientHttpParsing = lenientHttpParsing;
    }

    @Generated
    public RbelConfiguration() {
        this.postConversionListener = RbelConfiguration.$default$postConversionListener();
        this.activateRbelParsingFor = RbelConfiguration.$default$activateRbelParsingFor();
        this.initializers = RbelConfiguration.$default$initializers();
        this.keys = RbelConfiguration.$default$keys();
        this.rbelBufferSizeInMb = RbelConfiguration.$default$rbelBufferSizeInMb();
        this.skipParsingWhenMessageLargerThanKb = RbelConfiguration.$default$skipParsingWhenMessageLargerThanKb();
        this.manageBuffer = RbelConfiguration.$default$manageBuffer();
    }

    @Generated
    public static class RbelConfigurationBuilder {
        @Generated
        private boolean postConversionListener$set;
        @Generated
        private List<RbelConverterPlugin> postConversionListener$value;
        @Generated
        private boolean activateRbelParsingFor$set;
        @Generated
        private List<String> activateRbelParsingFor$value;
        @Generated
        private boolean initializers$set;
        @Generated
        private List<Consumer<RbelConverter>> initializers$value;
        @Generated
        private boolean keys$set;
        @Generated
        private Map<String, RbelKey> keys$value;
        @Generated
        private RbelCapturer capturer;
        @Generated
        private boolean rbelBufferSizeInMb$set;
        @Generated
        private int rbelBufferSizeInMb$value;
        @Generated
        private boolean skipParsingWhenMessageLargerThanKb$set;
        @Generated
        private int skipParsingWhenMessageLargerThanKb$value;
        @Generated
        private boolean manageBuffer$set;
        @Generated
        private boolean manageBuffer$value;
        @Generated
        private Boolean lenientHttpParsing;

        @Generated
        RbelConfigurationBuilder() {
        }

        @Generated
        public RbelConfigurationBuilder postConversionListener(List<RbelConverterPlugin> postConversionListener) {
            this.postConversionListener$value = postConversionListener;
            this.postConversionListener$set = true;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder activateRbelParsingFor(List<String> activateRbelParsingFor) {
            this.activateRbelParsingFor$value = activateRbelParsingFor;
            this.activateRbelParsingFor$set = true;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder initializers(List<Consumer<RbelConverter>> initializers) {
            this.initializers$value = initializers;
            this.initializers$set = true;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder keys(Map<String, RbelKey> keys) {
            this.keys$value = keys;
            this.keys$set = true;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder capturer(RbelCapturer capturer) {
            this.capturer = capturer;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder rbelBufferSizeInMb(int rbelBufferSizeInMb) {
            this.rbelBufferSizeInMb$value = rbelBufferSizeInMb;
            this.rbelBufferSizeInMb$set = true;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder skipParsingWhenMessageLargerThanKb(int skipParsingWhenMessageLargerThanKb) {
            this.skipParsingWhenMessageLargerThanKb$value = skipParsingWhenMessageLargerThanKb;
            this.skipParsingWhenMessageLargerThanKb$set = true;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder manageBuffer(boolean manageBuffer) {
            this.manageBuffer$value = manageBuffer;
            this.manageBuffer$set = true;
            return this;
        }

        @Generated
        public RbelConfigurationBuilder lenientHttpParsing(Boolean lenientHttpParsing) {
            this.lenientHttpParsing = lenientHttpParsing;
            return this;
        }

        @Generated
        public RbelConfiguration build() {
            List<RbelConverterPlugin> postConversionListener$value = this.postConversionListener$value;
            if (!this.postConversionListener$set) {
                postConversionListener$value = RbelConfiguration.$default$postConversionListener();
            }
            List<String> activateRbelParsingFor$value = this.activateRbelParsingFor$value;
            if (!this.activateRbelParsingFor$set) {
                activateRbelParsingFor$value = RbelConfiguration.$default$activateRbelParsingFor();
            }
            List<Consumer<RbelConverter>> initializers$value = this.initializers$value;
            if (!this.initializers$set) {
                initializers$value = RbelConfiguration.$default$initializers();
            }
            Map<String, RbelKey> keys$value = this.keys$value;
            if (!this.keys$set) {
                keys$value = RbelConfiguration.$default$keys();
            }
            int rbelBufferSizeInMb$value = this.rbelBufferSizeInMb$value;
            if (!this.rbelBufferSizeInMb$set) {
                rbelBufferSizeInMb$value = RbelConfiguration.$default$rbelBufferSizeInMb();
            }
            int skipParsingWhenMessageLargerThanKb$value = this.skipParsingWhenMessageLargerThanKb$value;
            if (!this.skipParsingWhenMessageLargerThanKb$set) {
                skipParsingWhenMessageLargerThanKb$value = RbelConfiguration.$default$skipParsingWhenMessageLargerThanKb();
            }
            boolean manageBuffer$value = this.manageBuffer$value;
            if (!this.manageBuffer$set) {
                manageBuffer$value = RbelConfiguration.$default$manageBuffer();
            }
            return new RbelConfiguration(postConversionListener$value, activateRbelParsingFor$value, initializers$value, keys$value, this.capturer, rbelBufferSizeInMb$value, skipParsingWhenMessageLargerThanKb$value, manageBuffer$value, this.lenientHttpParsing);
        }

        @Generated
        public String toString() {
            return "RbelConfiguration.RbelConfigurationBuilder(postConversionListener$value=" + String.valueOf(this.postConversionListener$value) + ", activateRbelParsingFor$value=" + String.valueOf(this.activateRbelParsingFor$value) + ", initializers$value=" + String.valueOf(this.initializers$value) + ", keys$value=" + String.valueOf(this.keys$value) + ", capturer=" + String.valueOf(this.capturer) + ", rbelBufferSizeInMb$value=" + this.rbelBufferSizeInMb$value + ", skipParsingWhenMessageLargerThanKb$value=" + this.skipParsingWhenMessageLargerThanKb$value + ", manageBuffer$value=" + this.manageBuffer$value + ", lenientHttpParsing=" + this.lenientHttpParsing + ")";
        }
    }
}

