/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.captures;

import de.gematik.rbellogger.RbelConverter;
import de.gematik.rbellogger.captures.RbelCapturer;
import de.gematik.rbellogger.file.RbelFileWriter;
import de.gematik.test.tiger.exceptions.GenericTigerException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import lombok.Generated;

public class RbelFileReaderCapturer
extends RbelCapturer {
    private final String rbelFile;

    public RbelFileReaderCapturer(RbelConverter rbelConverter, String rbelFile) {
        super(rbelConverter);
        this.rbelFile = rbelFile;
    }

    @Override
    public RbelCapturer initialize() {
        try {
            new RbelFileWriter(this.getRbelConverter()).convertFromRbelFile(Files.readString(Paths.get(this.rbelFile, new String[0]), StandardCharsets.UTF_8), Optional.empty());
            return this;
        }
        catch (IOException | UncheckedIOException e) {
            throw new RbelFileIoException("Error while reading from rbel-file with path '" + this.rbelFile + "'", e);
        }
    }

    @Override
    public void close() throws Exception {
    }

    @Generated
    public static RbelFileReaderCapturerBuilder builder() {
        return new RbelFileReaderCapturerBuilder();
    }

    private static class RbelFileIoException
    extends GenericTigerException {
        public RbelFileIoException(String s, Exception e) {
            super(s, (Throwable)e);
        }
    }

    @Generated
    public static class RbelFileReaderCapturerBuilder {
        @Generated
        private RbelConverter rbelConverter;
        @Generated
        private String rbelFile;

        @Generated
        RbelFileReaderCapturerBuilder() {
        }

        @Generated
        public RbelFileReaderCapturerBuilder rbelConverter(RbelConverter rbelConverter) {
            this.rbelConverter = rbelConverter;
            return this;
        }

        @Generated
        public RbelFileReaderCapturerBuilder rbelFile(String rbelFile) {
            this.rbelFile = rbelFile;
            return this;
        }

        @Generated
        public RbelFileReaderCapturer build() {
            return new RbelFileReaderCapturer(this.rbelConverter, this.rbelFile);
        }

        @Generated
        public String toString() {
            return "RbelFileReaderCapturer.RbelFileReaderCapturerBuilder(rbelConverter=" + String.valueOf(this.rbelConverter) + ", rbelFile=" + this.rbelFile + ")";
        }
    }
}

