/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger;

import de.gematik.rbellogger.RbelConverter;
import de.gematik.rbellogger.captures.RbelCapturer;
import de.gematik.rbellogger.configuration.RbelConfiguration;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.key.RbelKeyManager;
import de.gematik.rbellogger.modifier.RbelModifier;
import de.gematik.rbellogger.util.RbelValueShader;
import java.beans.ConstructorProperties;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;

public class RbelLogger {
    private final RbelConverter rbelConverter;
    private final RbelCapturer rbelCapturer;
    private final RbelValueShader valueShader;
    private final RbelKeyManager rbelKeyManager;
    private final RbelModifier rbelModifier;

    public static RbelLogger build() {
        return RbelLogger.build(new RbelConfiguration());
    }

    public static RbelLogger build(RbelConfiguration configuration) {
        Objects.requireNonNull(configuration);
        RbelConverter rbelConverter = RbelConverter.builder().rbelKeyManager(new RbelKeyManager()).manageBuffer(configuration.isManageBuffer()).rbelBufferSizeInMb(configuration.getRbelBufferSizeInMb()).skipParsingWhenMessageLargerThanKb(configuration.getSkipParsingWhenMessageLargerThanKb()).activateRbelParsingFor(configuration.getActivateRbelParsingFor()).build();
        rbelConverter.initializeConverters(configuration);
        configuration.getPostConversionListener().forEach(rbelConverter::addConverter);
        rbelConverter.addConverter(rbelConverter.getRbelValueShader().getPostConversionListener());
        for (Consumer<RbelConverter> initializer : configuration.getInitializers()) {
            initializer.accept(rbelConverter);
        }
        rbelConverter.getRbelKeyManager().addAll(configuration.getKeys());
        if (configuration.getCapturer() != null) {
            configuration.getCapturer().setRbelConverter(rbelConverter);
        }
        return RbelLogger.builder().rbelConverter(rbelConverter).rbelCapturer(configuration.getCapturer()).rbelKeyManager(rbelConverter.getRbelKeyManager()).rbelModifier(new RbelModifier(rbelConverter.getRbelKeyManager(), rbelConverter)).valueShader(rbelConverter.getRbelValueShader()).build();
    }

    public List<RbelElement> getMessageList() {
        return this.getRbelConverter().getMessageList();
    }

    public Deque<RbelElement> getMessageHistory() {
        return this.rbelConverter.getMessageHistoryAsync();
    }

    public void clearAllMessages() {
        this.rbelConverter.clearAllMessages();
    }

    @Generated
    private static RbelLoggerBuilder builder() {
        return new RbelLoggerBuilder();
    }

    @Generated
    public RbelConverter getRbelConverter() {
        return this.rbelConverter;
    }

    @Generated
    public RbelCapturer getRbelCapturer() {
        return this.rbelCapturer;
    }

    @Generated
    public RbelValueShader getValueShader() {
        return this.valueShader;
    }

    @Generated
    public RbelKeyManager getRbelKeyManager() {
        return this.rbelKeyManager;
    }

    @Generated
    public RbelModifier getRbelModifier() {
        return this.rbelModifier;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelLogger)) {
            return false;
        }
        RbelLogger other = (RbelLogger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RbelConverter this$rbelConverter = this.getRbelConverter();
        RbelConverter other$rbelConverter = other.getRbelConverter();
        if (this$rbelConverter == null ? other$rbelConverter != null : !this$rbelConverter.equals(other$rbelConverter)) {
            return false;
        }
        RbelCapturer this$rbelCapturer = this.getRbelCapturer();
        RbelCapturer other$rbelCapturer = other.getRbelCapturer();
        if (this$rbelCapturer == null ? other$rbelCapturer != null : !((Object)this$rbelCapturer).equals(other$rbelCapturer)) {
            return false;
        }
        RbelValueShader this$valueShader = this.getValueShader();
        RbelValueShader other$valueShader = other.getValueShader();
        if (this$valueShader == null ? other$valueShader != null : !((Object)this$valueShader).equals(other$valueShader)) {
            return false;
        }
        RbelKeyManager this$rbelKeyManager = this.getRbelKeyManager();
        RbelKeyManager other$rbelKeyManager = other.getRbelKeyManager();
        if (this$rbelKeyManager == null ? other$rbelKeyManager != null : !this$rbelKeyManager.equals(other$rbelKeyManager)) {
            return false;
        }
        RbelModifier this$rbelModifier = this.getRbelModifier();
        RbelModifier other$rbelModifier = other.getRbelModifier();
        return !(this$rbelModifier == null ? other$rbelModifier != null : !this$rbelModifier.equals(other$rbelModifier));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelLogger;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelConverter $rbelConverter = this.getRbelConverter();
        result = result * 59 + ($rbelConverter == null ? 43 : $rbelConverter.hashCode());
        RbelCapturer $rbelCapturer = this.getRbelCapturer();
        result = result * 59 + ($rbelCapturer == null ? 43 : ((Object)$rbelCapturer).hashCode());
        RbelValueShader $valueShader = this.getValueShader();
        result = result * 59 + ($valueShader == null ? 43 : ((Object)$valueShader).hashCode());
        RbelKeyManager $rbelKeyManager = this.getRbelKeyManager();
        result = result * 59 + ($rbelKeyManager == null ? 43 : $rbelKeyManager.hashCode());
        RbelModifier $rbelModifier = this.getRbelModifier();
        result = result * 59 + ($rbelModifier == null ? 43 : $rbelModifier.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelLogger(rbelConverter=" + String.valueOf(this.getRbelConverter()) + ", rbelCapturer=" + String.valueOf(this.getRbelCapturer()) + ", valueShader=" + String.valueOf(this.getValueShader()) + ", rbelKeyManager=" + String.valueOf(this.getRbelKeyManager()) + ", rbelModifier=" + String.valueOf(this.getRbelModifier()) + ")";
    }

    @ConstructorProperties(value={"rbelConverter", "rbelCapturer", "valueShader", "rbelKeyManager", "rbelModifier"})
    @Generated
    private RbelLogger(RbelConverter rbelConverter, RbelCapturer rbelCapturer, RbelValueShader valueShader, RbelKeyManager rbelKeyManager, RbelModifier rbelModifier) {
        this.rbelConverter = rbelConverter;
        this.rbelCapturer = rbelCapturer;
        this.valueShader = valueShader;
        this.rbelKeyManager = rbelKeyManager;
        this.rbelModifier = rbelModifier;
    }

    @Generated
    private static class RbelLoggerBuilder {
        @Generated
        private RbelConverter rbelConverter;
        @Generated
        private RbelCapturer rbelCapturer;
        @Generated
        private RbelValueShader valueShader;
        @Generated
        private RbelKeyManager rbelKeyManager;
        @Generated
        private RbelModifier rbelModifier;

        @Generated
        RbelLoggerBuilder() {
        }

        @Generated
        private RbelLoggerBuilder rbelConverter(RbelConverter rbelConverter) {
            this.rbelConverter = rbelConverter;
            return this;
        }

        @Generated
        private RbelLoggerBuilder rbelCapturer(RbelCapturer rbelCapturer) {
            this.rbelCapturer = rbelCapturer;
            return this;
        }

        @Generated
        private RbelLoggerBuilder valueShader(RbelValueShader valueShader) {
            this.valueShader = valueShader;
            return this;
        }

        @Generated
        private RbelLoggerBuilder rbelKeyManager(RbelKeyManager rbelKeyManager) {
            this.rbelKeyManager = rbelKeyManager;
            return this;
        }

        @Generated
        private RbelLoggerBuilder rbelModifier(RbelModifier rbelModifier) {
            this.rbelModifier = rbelModifier;
            return this;
        }

        @Generated
        private RbelLogger build() {
            return new RbelLogger(this.rbelConverter, this.rbelCapturer, this.valueShader, this.rbelKeyManager, this.rbelModifier);
        }

        @Generated
        public String toString() {
            return "RbelLogger.RbelLoggerBuilder(rbelConverter=" + String.valueOf(this.rbelConverter) + ", rbelCapturer=" + String.valueOf(this.rbelCapturer) + ", valueShader=" + String.valueOf(this.valueShader) + ", rbelKeyManager=" + String.valueOf(this.rbelKeyManager) + ", rbelModifier=" + String.valueOf(this.rbelModifier) + ")";
        }
    }
}

