/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConversionPhase;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelRequestFacet;
import de.gematik.rbellogger.data.core.RbelResponseFacet;
import de.gematik.rbellogger.data.core.RbelRootFacet;
import de.gematik.rbellogger.data.core.TracingMessagePairFacet;
import de.gematik.rbellogger.data.core.UnparsedChunkFacet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;

public abstract class RbelConverterPlugin {
    private final AtomicReference<Object> parserIdentifiers = new AtomicReference();
    private boolean isActive = true;

    public int getPriority() {
        return 0;
    }

    public RbelConversionPhase getPhase() {
        return RbelConversionPhase.CONTENT_PARSING;
    }

    public abstract void consumeElement(RbelElement var1, RbelConversionExecutor var2);

    public boolean isOptional() {
        return Optional.ofNullable(this.getClass().getAnnotation(ConverterInfo.class)).map(ConverterInfo::onlyActivateFor).filter(ArrayUtils::isNotEmpty).isPresent();
    }

    public boolean skipParsingOversizedContent() {
        return false;
    }

    public boolean isParserFor(List<String> pluginIds) {
        return pluginIds.stream().anyMatch(this.getParserIdentifiers()::contains);
    }

    private Set<String> initializeParserIdentifiers() {
        HashSet<String> parserIds = new HashSet<String>();
        if (this.getClass().isAnnotationPresent(ConverterInfo.class)) {
            ConverterInfo converterInfo = this.getClass().getAnnotation(ConverterInfo.class);
            parserIds.addAll(List.of(ArrayUtils.nullToEmpty((String[])converterInfo.onlyActivateFor())));
        }
        return parserIds;
    }

    public void activate() {
        this.isActive = true;
    }

    public void deactivate() {
        this.isActive = false;
    }

    public void doConversionIfActive(RbelElement convertedInput, RbelConversionExecutor rbelConversionExecutor) {
        if (this.isActive) {
            this.consumeElement(convertedInput, rbelConversionExecutor);
        }
    }

    public static RbelConverterPlugin createPlugin(final BiConsumer<RbelElement, RbelConversionExecutor> consumer) {
        return new RbelConverterPlugin(){

            @Override
            public void consumeElement(RbelElement rbelElement, RbelConversionExecutor converter) {
                consumer.accept(rbelElement, converter);
            }
        };
    }

    public static boolean messageIsCompleteOrParsingDeactivated(RbelElement message) {
        return message.getFacets().stream().anyMatch(f -> f instanceof RbelRootFacet || f instanceof RbelResponseFacet || f instanceof RbelRequestFacet || f instanceof TracingMessagePairFacet || f instanceof UnparsedChunkFacet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Set<String> getParserIdentifiers() {
        Object $value = this.parserIdentifiers.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.parserIdentifiers;
            synchronized (atomicReference) {
                $value = this.parserIdentifiers.get();
                if ($value == null) {
                    Set<String> actualValue = this.initializeParserIdentifiers();
                    $value = actualValue == null ? this.parserIdentifiers : actualValue;
                    this.parserIdentifiers.set($value);
                }
            }
        }
        return (Set)($value == this.parserIdentifiers ? null : $value);
    }
}

