/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger;

import de.gematik.rbellogger.RbelConverter;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.configuration.RbelConfiguration;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.exceptions.RbelInitializationException;
import de.gematik.rbellogger.facets.asn1.RbelAsn1Converter;
import de.gematik.rbellogger.facets.cetp.RbelCetpConverter;
import de.gematik.rbellogger.facets.http.RbelBearerTokenConverter;
import de.gematik.rbellogger.facets.http.RbelHttpRequestConverter;
import de.gematik.rbellogger.facets.http.RbelHttpResponseConverter;
import de.gematik.rbellogger.facets.http.formdata.RbelHttpFormDataConverter;
import de.gematik.rbellogger.facets.jackson.RbelCborConverter;
import de.gematik.rbellogger.facets.jackson.RbelJsonConverter;
import de.gematik.rbellogger.facets.jose.RbelJweConverter;
import de.gematik.rbellogger.facets.jose.RbelJwtConverter;
import de.gematik.rbellogger.facets.pki.RbelX500Converter;
import de.gematik.rbellogger.facets.pki.RbelX509Converter;
import de.gematik.rbellogger.facets.sicct.RbelSicctCommandConverter;
import de.gematik.rbellogger.facets.sicct.RbelSicctEnvelopeConverter;
import de.gematik.rbellogger.facets.uri.RbelUriConverter;
import de.gematik.rbellogger.facets.vau.vau.RbelVauEpaKeyDeriver;
import de.gematik.rbellogger.facets.xml.RbelMtomConverter;
import de.gematik.rbellogger.facets.xml.RbelXmlConverter;
import java.beans.ConstructorProperties;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelConverterInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelConverterInitializer.class);
    private final RbelConverter rbelConverter;
    private final RbelConfiguration rbelConfiguration;
    private final List<String> activateRbelParsingFor;
    private final Set<Class<? extends RbelConverterPlugin>> leftovers = new HashSet<Class<? extends RbelConverterPlugin>>();
    private final List<Class<? extends RbelConverterPlugin>> converters = new ArrayList<Class<? extends RbelConverterPlugin>>();

    public void addConverters() {
        List<Class<? extends RbelConverterPlugin>> subclasses = RbelConverterInitializer.findAllAvailableConverters();
        for (Class<? extends RbelConverterPlugin> converterClass : subclasses) {
            if (Modifier.isAbstract(converterClass.getModifiers())) continue;
            if (converterClass.isAnnotationPresent(ConverterInfo.class)) {
                ConverterInfo converterInfo = converterClass.getAnnotation(ConverterInfo.class);
                if (!converterInfo.addAutomatically() || this.isOptionalAndNotActivated(converterClass)) continue;
                if (this.isAnyDependencyMissingForThisConverter(converterInfo)) {
                    log.atTrace().addArgument(converterClass::getSimpleName).log("Adding {} to leftovers");
                    this.leftovers.add(converterClass);
                    continue;
                }
                log.atTrace().addArgument(converterClass::getSimpleName).log("NOT adding {} to leftovers");
            }
            this.converters.add(converterClass);
        }
        this.checkAndAddLeftoverConverters(this.leftovers);
        log.atTrace().addArgument(() -> this.converters.stream().map(Class::getSimpleName).collect(Collectors.joining("\n"))).log("Final converter list is {}");
        for (Class<? extends RbelConverterPlugin> converterClass : this.converters) {
            this.buildConverterInstance(converterClass).ifPresent(this.rbelConverter::addConverter);
        }
    }

    private Optional<RbelConverterPlugin> buildConverterInstance(Class<? extends RbelConverterPlugin> converterClass) {
        try {
            return Optional.of(converterClass.getDeclaredConstructor(RbelConfiguration.class).newInstance(this.rbelConfiguration));
        }
        catch (NoSuchMethodException e) {
            try {
                return Optional.of(converterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception innerException) {
                if (converterClass.isAnonymousClass()) {
                    return Optional.empty();
                }
                throw new RbelInitializationException("Could not initialize the converters. Error for '" + converterClass.getName() + "'", innerException);
            }
        }
        catch (Exception e) {
            throw new RbelInitializationException("Could not initialize the converters. Error for '" + converterClass.getName() + "'", e);
        }
    }

    private boolean isOptionalAndNotActivated(Class<? extends RbelConverterPlugin> converterClass) {
        ConverterInfo converterInfo = converterClass.getAnnotation(ConverterInfo.class);
        if (converterInfo.onlyActivateFor() != null && converterInfo.onlyActivateFor().length > 0) {
            if (Arrays.stream(converterInfo.onlyActivateFor()).noneMatch(item -> this.activateRbelParsingFor.stream().anyMatch(activated -> activated.equalsIgnoreCase((String)item)))) {
                log.atTrace().addArgument(converterClass::getSimpleName).log("SKIPPING optional converter {}");
                return true;
            }
            log.atTrace().addArgument(converterClass::getSimpleName).log("ADDING optional converter {}");
        }
        return false;
    }

    private static List<Class<? extends RbelConverterPlugin>> findAllAvailableConverters() {
        ArrayList<Class<? extends RbelConverterPlugin>> initialList = new ArrayList<Class<? extends RbelConverterPlugin>>(List.of(RbelUriConverter.class, RbelHttpResponseConverter.class, RbelHttpRequestConverter.class, RbelJwtConverter.class, RbelHttpFormDataConverter.class, RbelJweConverter.class, RbelBearerTokenConverter.class, RbelXmlConverter.class, RbelJsonConverter.class, RbelVauEpaKeyDeriver.class, RbelMtomConverter.class, RbelX509Converter.class, RbelX500Converter.class, RbelSicctEnvelopeConverter.class, RbelSicctCommandConverter.class, RbelCetpConverter.class, RbelCborConverter.class, RbelAsn1Converter.class));
        Reflections reflections = new Reflections("de.gematik", new Scanner[0]);
        reflections.getSubTypesOf(RbelConverterPlugin.class).stream().filter(c -> !initialList.contains(c)).filter(c -> !c.isAnonymousClass()).forEach(initialList::add);
        return initialList;
    }

    private void checkAndAddLeftoverConverters(Set<Class<? extends RbelConverterPlugin>> leftovers) {
        boolean wasAnyConverterAdded;
        int iterationsLeft = 1000;
        do {
            wasAnyConverterAdded = false;
            log.trace("Checking leftovers {}...", leftovers);
            for (Class<? extends RbelConverterPlugin> converterClass : new HashSet<Class<? extends RbelConverterPlugin>>(leftovers)) {
                ConverterInfo converterInfo = converterClass.getAnnotation(ConverterInfo.class);
                if (this.isAnyDependencyMissingForThisConverter(converterInfo)) continue;
                this.converters.add(converterClass);
                leftovers.remove(converterClass);
                wasAnyConverterAdded = true;
                if (iterationsLeft-- > 0) continue;
                throw new RbelInitializationException("Could not instantiate '" + converterClass.getName() + "' due to dependencies.");
            }
        } while (wasAnyConverterAdded);
    }

    private boolean isAnyDependencyMissingForThisConverter(ConverterInfo converterInfo) {
        return converterInfo.dependsOn() != null && converterInfo.dependsOn().length > 0 && !new HashSet<Class<? extends RbelConverterPlugin>>(this.converters).containsAll(Arrays.asList(converterInfo.dependsOn()));
    }

    @ConstructorProperties(value={"rbelConverter", "rbelConfiguration", "activateRbelParsingFor"})
    @Generated
    public RbelConverterInitializer(RbelConverter rbelConverter, RbelConfiguration rbelConfiguration, List<String> activateRbelParsingFor) {
        this.rbelConverter = rbelConverter;
        this.rbelConfiguration = rbelConfiguration;
        this.activateRbelParsingFor = activateRbelParsingFor;
    }
}

