/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.unboundid.util.NotNull;
import de.gematik.rbellogger.KnownUuidsContainer;
import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConversionPhase;
import de.gematik.rbellogger.RbelConverterInitializer;
import de.gematik.rbellogger.RbelConverterInterface;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.configuration.RbelConfiguration;
import de.gematik.rbellogger.converter.brainpool.BrainpoolCurves;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMessageMetadata;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.core.RbelHostnameFacet;
import de.gematik.rbellogger.data.core.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.data.facet.RbelNonTransmissionMarkerFacet;
import de.gematik.rbellogger.exceptions.RbelConversionException;
import de.gematik.rbellogger.key.RbelKeyManager;
import de.gematik.rbellogger.util.ConverterPluginMap;
import de.gematik.rbellogger.util.RbelMessagesDequeFacade;
import de.gematik.rbellogger.util.RbelValueShader;
import de.gematik.test.tiger.common.config.TigerTypedConfigurationKey;
import de.gematik.test.tiger.common.util.TigerSecurityProviderInitialiser;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelConverter
implements RbelConverterInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelConverter.class);
    private static final String RECEIVER_METADATA_KEY = "receiver";
    private static final String SENDER_METADATA_KEY = "sender";
    private final Deque<RbelElement> messageHistory = new ConcurrentLinkedDeque<RbelElement>();
    private final KnownUuidsContainer knownMessageUuids = new KnownUuidsContainer(this.messageHistory);
    private final Set<String> messageUuidsWaitingForNextMessage = ConcurrentHashMap.newKeySet();
    private final RbelMultiMap<CompletableFuture<RbelElement>> messagesWaitingForCompletion = new RbelMultiMap();
    private final RbelKeyManager rbelKeyManager;
    private final RbelValueShader rbelValueShader = new RbelValueShader();
    private final List<Runnable> historyClearCallbacks = new LinkedList<Runnable>();
    private final List<Consumer<RbelElement>> messageRemovedFromHistoryCallbacks = new LinkedList<Consumer<RbelElement>>();
    private final ConverterPluginMap converterPlugins = new ConverterPluginMap();
    private final ExecutorService executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("rbel-converter-thread-%d").build());
    int rbelBufferSizeInMb;
    boolean manageBuffer;
    private long currentBufferSize;
    long messageSequenceNumber;
    int skipParsingWhenMessageLargerThanKb;
    List<String> activateRbelParsingFor;
    private volatile boolean shallInitializeConverters;
    boolean isActivateRbelParsing;
    String name;
    private List<RbelConversionPhase> conversionPhases;
    public static final TigerTypedConfigurationKey<Integer> RAW_STRING_MAX_TRACE_LENGTH;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeConverters(RbelConfiguration rbelConfiguration) {
        if (this.shallInitializeConverters) {
            ConverterPluginMap converterPluginMap = this.converterPlugins;
            synchronized (converterPluginMap) {
                if (this.shallInitializeConverters) {
                    new RbelConverterInitializer(this, rbelConfiguration, this.activateRbelParsingFor).addConverters();
                    this.shallInitializeConverters = false;
                }
            }
        }
    }

    public void addClearHistoryCallback(Runnable runnable) {
        this.historyClearCallbacks.add(runnable);
    }

    public void addMessageRemovedFromHistoryCallback(Consumer<RbelElement> consumer) {
        this.messageRemovedFromHistoryCallbacks.add(consumer);
    }

    @Override
    public RbelElement convertElement(RbelElement rbelElement) {
        return this.convertElement(rbelElement, this.conversionPhases);
    }

    public RbelElement convertElement(RbelElement rbelElement, List<RbelConversionPhase> conversionPhases) {
        return new RbelConversionExecutor(this, rbelElement, this.skipParsingWhenMessageLargerThanKb, this.rbelKeyManager, conversionPhases).execute();
    }

    public RbelElement convertElement(byte[] input, RbelElement parentNode) {
        return this.convertElement(RbelElement.builder().parentNode(parentNode).rawContent(input).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RbelConverterPlugin> getPlugins(Predicate<RbelConverterPlugin> filter) {
        ConverterPluginMap converterPluginMap = this.converterPlugins;
        synchronized (converterPluginMap) {
            return this.converterPlugins.stream().filter(filter).toList();
        }
    }

    public RbelElement convertElement(String input, RbelElement parentNode) {
        return this.convertElement(RbelElement.builder().parentNode(parentNode).rawContent(input.getBytes(Optional.ofNullable(parentNode).map(RbelElement::getElementCharset).orElse(StandardCharsets.UTF_8))).build());
    }

    public void addConverter(RbelConverterPlugin converter) {
        this.converterPlugins.put(converter);
    }

    public RbelElement parseMessage(byte[] content, RbelMessageMetadata conversionMetadata) {
        RbelElement messageElement = RbelElement.builder().rawContent(content).build();
        return this.parseMessage(messageElement, conversionMetadata);
    }

    public RbelElement parseMessage(@NonNull RbelElement message, @NonNull RbelMessageMetadata conversionMetadata) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (conversionMetadata == null) {
            throw new NullPointerException("conversionMetadata is marked non-null but is null");
        }
        try {
            return (RbelElement)((CompletableFuture)this.parseMessageAsync(message, conversionMetadata).exceptionally(t -> {
                log.error("Error while parsing message", t);
                return null;
            })).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RbelConversionException(e);
        }
        catch (ExecutionException e) {
            throw new RbelConversionException(e);
        }
    }

    public CompletableFuture<RbelElement> parseMessageAsync(@NonNull RbelElement messageElement, @NonNull RbelMessageMetadata conversionMetadata) {
        if (messageElement == null) {
            throw new NullPointerException("messageElement is marked non-null but is null");
        }
        if (conversionMetadata == null) {
            throw new NullPointerException("conversionMetadata is marked non-null but is null");
        }
        if (messageElement.getContent().isNull()) {
            throw new RbelConversionException("content is empty");
        }
        if (this.knownMessageUuids.isAlreadyConverted(messageElement.getUuid())) {
            log.atTrace().addArgument(this::getName).addArgument(messageElement::getUuid).log("{} skipping parsing of message with UUID {}: UUID already known");
            return CompletableFuture.failedFuture((Throwable)((Object)new RbelConversionException("UUID is already known")));
        }
        long seqNumber = this.addMessageToHistoryWithNextSequenceNumber(messageElement);
        if (!messageElement.hasFacet(RbelTcpIpMessageFacet.class)) {
            messageElement.addFacet(RbelTcpIpMessageFacet.builder().receiver(RbelMessageMetadata.MESSAGE_RECEIVER.getValue(conversionMetadata).map(h -> RbelHostnameFacet.buildRbelHostnameFacet(messageElement, h)).orElse(RbelHostnameFacet.buildRbelHostnameFacet(messageElement, null))).sender(RbelMessageMetadata.MESSAGE_SENDER.getValue(conversionMetadata).map(h -> RbelHostnameFacet.buildRbelHostnameFacet(messageElement, h)).orElse(RbelHostnameFacet.buildRbelHostnameFacet(messageElement, null))).sequenceNumber(seqNumber).build());
        }
        messageElement.addFacet(conversionMetadata);
        return CompletableFuture.supplyAsync(() -> this.convertElement(messageElement), this.executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addMessageToHistoryWithNextSequenceNumber(RbelElement rbelElement) {
        long seqNumber;
        Deque<RbelElement> deque = this.messageHistory;
        synchronized (deque) {
            this.currentBufferSize += rbelElement.getSize();
            this.knownMessageUuids.markAsConverted(rbelElement.getUuid());
            this.messageHistory.add(rbelElement);
            seqNumber = this.messageSequenceNumber++;
        }
        this.manageRbelBufferSize();
        return seqNumber;
    }

    public void deactivateRbelParsing() {
        this.isActivateRbelParsing = false;
        this.conversionPhases = List.of(RbelConversionPhase.PREPARATION, RbelConversionPhase.CONTENT_ENRICHMENT, RbelConversionPhase.TRANSMISSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manageRbelBufferSize() {
        if (this.manageBuffer) {
            Deque<RbelElement> deque = this.messageHistory;
            synchronized (deque) {
                if (this.rbelBufferSizeInMb <= 0 && !this.messageHistory.isEmpty()) {
                    this.currentBufferSize = 0L;
                    this.messageHistory.forEach(e -> this.messageRemovedFromHistoryCallbacks.forEach(h -> h.accept(e)));
                    this.messageHistory.clear();
                    this.knownMessageUuids.clear();
                }
                if (this.rbelBufferSizeInMb > 0) {
                    long exceedingLimit = this.getExceedingLimit(this.currentBufferSize);
                    if (exceedingLimit > 0L) {
                        log.atTrace().addArgument(() -> (double)this.currentBufferSize / 1048576.0).addArgument((Object)this.rbelBufferSizeInMb).log("Buffer is currently at {} Mb which exceeds the limit of {} Mb");
                    }
                    while (exceedingLimit > 0L && !this.messageHistory.isEmpty()) {
                        log.trace("Exceeded buffer size, dropping oldest message in history");
                        RbelElement messageToDrop = this.messageHistory.removeFirst();
                        this.messageRemovedFromHistoryCallbacks.forEach(h -> h.accept(messageToDrop));
                        exceedingLimit -= messageToDrop.getSize();
                        this.currentBufferSize -= messageToDrop.getSize();
                        this.knownMessageUuids.remove(messageToDrop.getUuid());
                    }
                }
            }
        }
    }

    private long getExceedingLimit(long messageHistorySize) {
        return messageHistorySize - (long)this.rbelBufferSizeInMb * 0x100000L;
    }

    public Stream<RbelElement> messagesStreamLatestFirst() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.messageHistory.descendingIterator(), 16), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RbelElement> getMessageList() {
        Deque<RbelElement> deque = this.messageHistory;
        synchronized (deque) {
            return this.messageHistory.stream().filter(e -> !e.hasFacet(RbelNonTransmissionMarkerFacet.class)).takeWhile(msg -> msg.getConversionPhase().isFinished()).toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<RbelElement> findMessageByUuid(String uuid) {
        Deque<RbelElement> deque = this.messageHistory;
        synchronized (deque) {
            return this.messageHistory.stream().filter(msg -> msg.getUuid().equals(uuid)).findAny();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RbelMessagesDequeFacade getMessageHistoryAsync() {
        Deque<RbelElement> deque = this.messageHistory;
        synchronized (deque) {
            return new RbelMessagesDequeFacade(this.messageHistory, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllMessages() {
        Deque<RbelElement> deque = this.messageHistory;
        synchronized (deque) {
            this.currentBufferSize = 0L;
            this.messageHistory.clear();
            this.knownMessageUuids.clear();
            this.historyClearCallbacks.forEach(Runnable::run);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessage(RbelElement rbelMessage) {
        Deque<RbelElement> deque = this.messageHistory;
        synchronized (deque) {
            log.trace("Removing message {}", (Object)rbelMessage.getUuid());
            Iterator<RbelElement> iterator = this.messageHistory.descendingIterator();
            while (iterator.hasNext()) {
                if (!iterator.next().equals(rbelMessage)) continue;
                iterator.remove();
                this.messageRemovedFromHistoryCallbacks.forEach(r -> r.accept(rbelMessage));
                this.currentBufferSize -= rbelMessage.getSize();
                this.knownMessageUuids.remove(rbelMessage.getUuid());
            }
        }
    }

    public void waitForGivenElementToBeParsed(RbelElement result) {
        this.waitForGivenMessagesToBeParsed(List.of(result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllElementsBeforeGivenToBeParsed(RbelElement element) {
        ArrayList<RbelElement> unfinishedMessages = new ArrayList<RbelElement>();
        Deque<RbelElement> deque = this.messageHistory;
        synchronized (deque) {
            for (RbelElement msg : this.messageHistory) {
                if (msg == element || msg.getUuid().equals(element.getUuid())) break;
                if (msg.getConversionPhase().isFinished()) continue;
                unfinishedMessages.add(msg);
            }
        }
        this.waitForGivenMessagesToBeParsed(unfinishedMessages);
    }

    public void waitForAllCurrentMessagesToBeParsed() {
        this.waitForGivenMessagesToBeParsed(new ArrayList<RbelElement>(this.messageHistory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForGivenMessagesToBeParsed(List<RbelElement> unfinishedMessages) {
        List<Pair> callbacks;
        RbelMultiMap<CompletableFuture<RbelElement>> rbelMultiMap = this.messagesWaitingForCompletion;
        synchronized (rbelMultiMap) {
            callbacks = unfinishedMessages.stream().filter(msg -> msg.getConversionPhase() != RbelConversionPhase.COMPLETED).map(msg -> {
                CompletableFuture future = new CompletableFuture();
                this.messagesWaitingForCompletion.put(msg.getUuid(), future);
                return Pair.of(future, (Object)msg);
            }).toList();
        }
        for (Pair future : callbacks) {
            try {
                ((CompletableFuture)future.getKey()).get(100L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RbelConversionException(e, (RbelElement)future.getValue());
            }
            catch (ExecutionException e) {
                throw new RbelConversionException(e, (RbelElement)future.getValue());
            }
            catch (TimeoutException e) {
                throw new RbelConversionException("Tripped the timeout of 100 seconds while waiting for message " + ((RbelElement)future.getValue()).getUuid() + " to finish parsing", e, (RbelElement)future.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalMessageParsingIsComplete(RbelElement element) {
        List<CompletableFuture<RbelElement>> completableFutures;
        RbelMultiMap<CompletableFuture<RbelElement>> rbelMultiMap = this.messagesWaitingForCompletion;
        synchronized (rbelMultiMap) {
            completableFutures = this.messagesWaitingForCompletion.removeAll(element.getUuid());
        }
        completableFutures.forEach(future -> future.complete(element));
    }

    public void transmitElement(RbelElement rbelElement) {
        this.convertElement(rbelElement, List.of(RbelConversionPhase.PREPARATION, RbelConversionPhase.TRANSMISSION));
    }

    @NotNull
    private static List<String> getTrimmedListElements(String commaSeparatedList) {
        return Arrays.stream(commaSeparatedList.split(",")).map(String::trim).filter(s -> !s.isEmpty()).toList();
    }

    public void deactivateParsingFor(String parsersToDeactivate) {
        List<String> idsToDeactivate = RbelConverter.getTrimmedListElements(parsersToDeactivate);
        this.getConverterPlugins().stream().filter(plugin -> plugin.isParserFor(idsToDeactivate)).forEach(RbelConverterPlugin::deactivate);
    }

    public void activateParsingForAll() {
        this.getConverterPlugins().forEach(RbelConverterPlugin::activate);
    }

    @Deprecated(since="4.0.0")
    public void reactivateParsingForAll() {
        this.activateParsingForAll();
    }

    public void deactivateOptionalParsing() {
        this.getConverterPlugins().stream().filter(RbelConverterPlugin::isOptional).forEach(RbelConverterPlugin::deactivate);
    }

    public void activateParsingFor(String parsersToActivate) {
        List<String> idsToActivate = RbelConverter.getTrimmedListElements(parsersToActivate);
        this.getConverterPlugins().stream().filter(plugin -> plugin.isParserFor(idsToActivate)).forEach(RbelConverterPlugin::activate);
    }

    @Generated
    private static int $default$rbelBufferSizeInMb() {
        return 1024;
    }

    @Generated
    private static boolean $default$manageBuffer() {
        return false;
    }

    @Generated
    private static long $default$currentBufferSize() {
        return 0L;
    }

    @Generated
    private static long $default$messageSequenceNumber() {
        return 0L;
    }

    @Generated
    private static int $default$skipParsingWhenMessageLargerThanKb() {
        return -1;
    }

    @Generated
    private static List<String> $default$activateRbelParsingFor() {
        return List.of();
    }

    @Generated
    private static boolean $default$shallInitializeConverters() {
        return true;
    }

    @Generated
    private static boolean $default$isActivateRbelParsing() {
        return true;
    }

    @Generated
    private static String $default$name() {
        return "<>";
    }

    @Generated
    private static List<RbelConversionPhase> $default$conversionPhases() {
        return List.of(RbelConversionPhase.PREPARATION, RbelConversionPhase.PROTOCOL_PARSING, RbelConversionPhase.CONTENT_PARSING, RbelConversionPhase.CONTENT_ENRICHMENT, RbelConversionPhase.TRANSMISSION);
    }

    @Generated
    public static RbelConverterBuilder builder() {
        return new RbelConverterBuilder();
    }

    @Generated
    public RbelConverterBuilder toBuilder() {
        return new RbelConverterBuilder().rbelKeyManager(this.rbelKeyManager).rbelBufferSizeInMb(this.rbelBufferSizeInMb).manageBuffer(this.manageBuffer).currentBufferSize(this.currentBufferSize).messageSequenceNumber(this.messageSequenceNumber).skipParsingWhenMessageLargerThanKb(this.skipParsingWhenMessageLargerThanKb).activateRbelParsingFor(this.activateRbelParsingFor).shallInitializeConverters(this.shallInitializeConverters).isActivateRbelParsing(this.isActivateRbelParsing).name(this.name).conversionPhases(this.conversionPhases);
    }

    @ConstructorProperties(value={"rbelKeyManager", "rbelBufferSizeInMb", "manageBuffer", "currentBufferSize", "messageSequenceNumber", "skipParsingWhenMessageLargerThanKb", "activateRbelParsingFor", "shallInitializeConverters", "isActivateRbelParsing", "name", "conversionPhases"})
    @Generated
    private RbelConverter(RbelKeyManager rbelKeyManager, int rbelBufferSizeInMb, boolean manageBuffer, long currentBufferSize, long messageSequenceNumber, int skipParsingWhenMessageLargerThanKb, List<String> activateRbelParsingFor, boolean shallInitializeConverters, boolean isActivateRbelParsing, String name, List<RbelConversionPhase> conversionPhases) {
        this.rbelKeyManager = rbelKeyManager;
        this.rbelBufferSizeInMb = rbelBufferSizeInMb;
        this.manageBuffer = manageBuffer;
        this.currentBufferSize = currentBufferSize;
        this.messageSequenceNumber = messageSequenceNumber;
        this.skipParsingWhenMessageLargerThanKb = skipParsingWhenMessageLargerThanKb;
        this.activateRbelParsingFor = activateRbelParsingFor;
        this.shallInitializeConverters = shallInitializeConverters;
        this.isActivateRbelParsing = isActivateRbelParsing;
        this.name = name;
        this.conversionPhases = conversionPhases;
    }

    @Generated
    public Deque<RbelElement> getMessageHistory() {
        return this.messageHistory;
    }

    @Generated
    public KnownUuidsContainer getKnownMessageUuids() {
        return this.knownMessageUuids;
    }

    @Generated
    public RbelKeyManager getRbelKeyManager() {
        return this.rbelKeyManager;
    }

    @Generated
    public RbelValueShader getRbelValueShader() {
        return this.rbelValueShader;
    }

    @Generated
    public ConverterPluginMap getConverterPlugins() {
        return this.converterPlugins;
    }

    @Generated
    public long getCurrentBufferSize() {
        return this.currentBufferSize;
    }

    @Generated
    public boolean isActivateRbelParsing() {
        return this.isActivateRbelParsing;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    static {
        BrainpoolCurves.init();
        TigerSecurityProviderInitialiser.initialize();
        RAW_STRING_MAX_TRACE_LENGTH = new TigerTypedConfigurationKey("tiger.rbel.rawstring.max.trace.length", Integer.class, (Object)1000);
    }

    @Generated
    public static class RbelConverterBuilder {
        @Generated
        private RbelKeyManager rbelKeyManager;
        @Generated
        private boolean rbelBufferSizeInMb$set;
        @Generated
        private int rbelBufferSizeInMb$value;
        @Generated
        private boolean manageBuffer$set;
        @Generated
        private boolean manageBuffer$value;
        @Generated
        private boolean currentBufferSize$set;
        @Generated
        private long currentBufferSize$value;
        @Generated
        private boolean messageSequenceNumber$set;
        @Generated
        private long messageSequenceNumber$value;
        @Generated
        private boolean skipParsingWhenMessageLargerThanKb$set;
        @Generated
        private int skipParsingWhenMessageLargerThanKb$value;
        @Generated
        private boolean activateRbelParsingFor$set;
        @Generated
        private List<String> activateRbelParsingFor$value;
        @Generated
        private boolean shallInitializeConverters$set;
        @Generated
        private boolean shallInitializeConverters$value;
        @Generated
        private boolean isActivateRbelParsing$set;
        @Generated
        private boolean isActivateRbelParsing$value;
        @Generated
        private boolean name$set;
        @Generated
        private String name$value;
        @Generated
        private boolean conversionPhases$set;
        @Generated
        private List<RbelConversionPhase> conversionPhases$value;

        @Generated
        RbelConverterBuilder() {
        }

        @Generated
        public RbelConverterBuilder rbelKeyManager(RbelKeyManager rbelKeyManager) {
            this.rbelKeyManager = rbelKeyManager;
            return this;
        }

        @Generated
        public RbelConverterBuilder rbelBufferSizeInMb(int rbelBufferSizeInMb) {
            this.rbelBufferSizeInMb$value = rbelBufferSizeInMb;
            this.rbelBufferSizeInMb$set = true;
            return this;
        }

        @Generated
        public RbelConverterBuilder manageBuffer(boolean manageBuffer) {
            this.manageBuffer$value = manageBuffer;
            this.manageBuffer$set = true;
            return this;
        }

        @Generated
        public RbelConverterBuilder currentBufferSize(long currentBufferSize) {
            this.currentBufferSize$value = currentBufferSize;
            this.currentBufferSize$set = true;
            return this;
        }

        @Generated
        public RbelConverterBuilder messageSequenceNumber(long messageSequenceNumber) {
            this.messageSequenceNumber$value = messageSequenceNumber;
            this.messageSequenceNumber$set = true;
            return this;
        }

        @Generated
        public RbelConverterBuilder skipParsingWhenMessageLargerThanKb(int skipParsingWhenMessageLargerThanKb) {
            this.skipParsingWhenMessageLargerThanKb$value = skipParsingWhenMessageLargerThanKb;
            this.skipParsingWhenMessageLargerThanKb$set = true;
            return this;
        }

        @Generated
        public RbelConverterBuilder activateRbelParsingFor(List<String> activateRbelParsingFor) {
            this.activateRbelParsingFor$value = activateRbelParsingFor;
            this.activateRbelParsingFor$set = true;
            return this;
        }

        @Generated
        public RbelConverterBuilder shallInitializeConverters(boolean shallInitializeConverters) {
            this.shallInitializeConverters$value = shallInitializeConverters;
            this.shallInitializeConverters$set = true;
            return this;
        }

        @Generated
        public RbelConverterBuilder isActivateRbelParsing(boolean isActivateRbelParsing) {
            this.isActivateRbelParsing$value = isActivateRbelParsing;
            this.isActivateRbelParsing$set = true;
            return this;
        }

        @Generated
        public RbelConverterBuilder name(String name) {
            this.name$value = name;
            this.name$set = true;
            return this;
        }

        @Generated
        public RbelConverterBuilder conversionPhases(List<RbelConversionPhase> conversionPhases) {
            this.conversionPhases$value = conversionPhases;
            this.conversionPhases$set = true;
            return this;
        }

        @Generated
        public RbelConverter build() {
            int rbelBufferSizeInMb$value = this.rbelBufferSizeInMb$value;
            if (!this.rbelBufferSizeInMb$set) {
                rbelBufferSizeInMb$value = RbelConverter.$default$rbelBufferSizeInMb();
            }
            boolean manageBuffer$value = this.manageBuffer$value;
            if (!this.manageBuffer$set) {
                manageBuffer$value = RbelConverter.$default$manageBuffer();
            }
            long currentBufferSize$value = this.currentBufferSize$value;
            if (!this.currentBufferSize$set) {
                currentBufferSize$value = RbelConverter.$default$currentBufferSize();
            }
            long messageSequenceNumber$value = this.messageSequenceNumber$value;
            if (!this.messageSequenceNumber$set) {
                messageSequenceNumber$value = RbelConverter.$default$messageSequenceNumber();
            }
            int skipParsingWhenMessageLargerThanKb$value = this.skipParsingWhenMessageLargerThanKb$value;
            if (!this.skipParsingWhenMessageLargerThanKb$set) {
                skipParsingWhenMessageLargerThanKb$value = RbelConverter.$default$skipParsingWhenMessageLargerThanKb();
            }
            List<String> activateRbelParsingFor$value = this.activateRbelParsingFor$value;
            if (!this.activateRbelParsingFor$set) {
                activateRbelParsingFor$value = RbelConverter.$default$activateRbelParsingFor();
            }
            boolean shallInitializeConverters$value = this.shallInitializeConverters$value;
            if (!this.shallInitializeConverters$set) {
                shallInitializeConverters$value = RbelConverter.$default$shallInitializeConverters();
            }
            boolean isActivateRbelParsing$value = this.isActivateRbelParsing$value;
            if (!this.isActivateRbelParsing$set) {
                isActivateRbelParsing$value = RbelConverter.$default$isActivateRbelParsing();
            }
            String name$value = this.name$value;
            if (!this.name$set) {
                name$value = RbelConverter.$default$name();
            }
            List<RbelConversionPhase> conversionPhases$value = this.conversionPhases$value;
            if (!this.conversionPhases$set) {
                conversionPhases$value = RbelConverter.$default$conversionPhases();
            }
            return new RbelConverter(this.rbelKeyManager, rbelBufferSizeInMb$value, manageBuffer$value, currentBufferSize$value, messageSequenceNumber$value, skipParsingWhenMessageLargerThanKb$value, activateRbelParsingFor$value, shallInitializeConverters$value, isActivateRbelParsing$value, name$value, conversionPhases$value);
        }

        @Generated
        public String toString() {
            return "RbelConverter.RbelConverterBuilder(rbelKeyManager=" + String.valueOf(this.rbelKeyManager) + ", rbelBufferSizeInMb$value=" + this.rbelBufferSizeInMb$value + ", manageBuffer$value=" + this.manageBuffer$value + ", currentBufferSize$value=" + this.currentBufferSize$value + ", messageSequenceNumber$value=" + this.messageSequenceNumber$value + ", skipParsingWhenMessageLargerThanKb$value=" + this.skipParsingWhenMessageLargerThanKb$value + ", activateRbelParsingFor$value=" + String.valueOf(this.activateRbelParsingFor$value) + ", shallInitializeConverters$value=" + this.shallInitializeConverters$value + ", isActivateRbelParsing$value=" + this.isActivateRbelParsing$value + ", name$value=" + this.name$value + ", conversionPhases$value=" + String.valueOf(this.conversionPhases$value) + ")";
        }
    }
}

