/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger;

import de.gematik.rbellogger.RbelConversionPhase;
import de.gematik.rbellogger.RbelConverter;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.data.core.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.data.core.TracingMessagePairFacet;
import de.gematik.rbellogger.exceptions.RbelConversionException;
import de.gematik.rbellogger.key.RbelKeyManager;
import de.gematik.rbellogger.util.RbelContent;
import de.gematik.rbellogger.util.RbelMessagesDequeFacade;
import de.gematik.rbellogger.util.RbelSocketAddress;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelConversionExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelConversionExecutor.class);
    private final RbelConverter converter;
    private final RbelElement rootElement;
    private final int skipParsingWhenMessageLargerThanKb;
    private final RbelKeyManager rbelKeyManager;
    private RbelConversionPhase conversionPhase;
    private final List<RbelConversionPhase> toBeConsideredPhases;
    private boolean messageWasDeleted = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RbelElement execute() {
        long timeBeforeConversion = System.nanoTime();
        try {
            for (RbelConversionPhase phase : this.toBeConsideredPhases) {
                if (this.rootElement.getParentNode() == null) {
                    this.rootElement.setConversionPhase(phase);
                }
                this.conversionPhase = phase;
                this.executeConversionPhase(phase);
                if (!this.messageWasDeleted) continue;
                this.rootElement.setConversionPhase(RbelConversionPhase.DELETION);
                this.executeConversionPhase(RbelConversionPhase.DELETION);
                this.rootElement.setConversionPhase(RbelConversionPhase.DELETED);
                this.converter.signalMessageParsingIsComplete(this.rootElement);
                RbelElement rbelElement = this.rootElement;
                return rbelElement;
            }
            this.rootElement.setConversionPhase(RbelConversionPhase.COMPLETED);
            this.converter.signalMessageParsingIsComplete(this.rootElement);
            RbelElement rbelElement = this.rootElement;
            return rbelElement;
        }
        finally {
            log.atTrace().addArgument(this.rootElement::getUuid).addArgument(this.converter::getName).addArgument(this.rootElement::getConversionPhase).log("Finalizing conversion of message {} in proxy {}, final phase is {}");
            if (!this.messageWasDeleted) {
                long timeAfterConversion = System.nanoTime();
                this.rootElement.setConversionTimeInNanos(timeAfterConversion - timeBeforeConversion);
            }
        }
    }

    public RbelElement convertElement(RbelElement convertedInput) {
        return this.converter.convertElement(convertedInput);
    }

    private void executeConversionPhase(RbelConversionPhase conversionPhase) {
        boolean elementIsOversized = this.skipParsingWhenMessageLargerThanKb > -1 && this.rootElement.getSize() > (long)this.skipParsingWhenMessageLargerThanKb * 1024L;
        for (RbelConverterPlugin plugin : this.converter.getConverterPlugins().get(conversionPhase)) {
            if (conversionPhase == RbelConversionPhase.CONTENT_PARSING && elementIsOversized && plugin.skipParsingOversizedContent()) continue;
            try {
                plugin.doConversionIfActive(this.rootElement, this);
            }
            catch (RuntimeException e) {
                RbelConversionException conversionException = RbelConversionException.wrapIfNotAConversionException(e, plugin, this.rootElement);
                conversionException.printDetailsToLog(log);
                conversionException.addErrorNoteFacetToElement();
            }
            if (!this.messageWasDeleted || conversionPhase == RbelConversionPhase.DELETION) continue;
            return;
        }
    }

    public RbelElement convertElement(byte[] input, RbelElement parentNode) {
        return this.convertElement(RbelElement.builder().parentNode(parentNode).rawContent(input).build());
    }

    public RbelElement convertElement(RbelContent input, RbelElement parentNode) {
        return this.convertElement(RbelElement.builder().parentNode(parentNode).content(input).build());
    }

    public RbelElement convertElement(String input, RbelElement parentNode) {
        return this.convertElement(RbelElement.builder().parentNode(parentNode).rawContent(input.getBytes(Optional.ofNullable(parentNode).map(RbelElement::getElementCharset).orElse(StandardCharsets.UTF_8))).build());
    }

    public void waitForAllElementsBeforeGivenToBeParsed(RbelElement rootElement) {
        this.converter.waitForAllElementsBeforeGivenToBeParsed(rootElement);
    }

    public Stream<RbelElement> messagesStreamLatestFirst() {
        return this.converter.messagesStreamLatestFirst();
    }

    public Optional<RbelElement> findMessageByUuid(String uuid) {
        return this.converter.findMessageByUuid(uuid);
    }

    public void removeMessage(RbelElement message) {
        if (message == this.rootElement) {
            this.messageWasDeleted = true;
        }
        this.converter.removeMessage(message);
    }

    public boolean isActivateRbelParsing() {
        return this.converter.isActivateRbelParsing();
    }

    private boolean haveSameConnection(RbelElement element1, RbelElement element2) {
        Optional<RbelTcpIpMessageFacet> tcpIpFacet1 = element1.getFacet(RbelTcpIpMessageFacet.class);
        Optional<RbelTcpIpMessageFacet> tcpIpFacet2 = element2.getFacet(RbelTcpIpMessageFacet.class);
        if (tcpIpFacet1.isEmpty() || tcpIpFacet2.isEmpty()) {
            return false;
        }
        RbelSocketAddress sender1 = tcpIpFacet1.get().getSenderHostname().orElse(null);
        RbelSocketAddress sender2 = tcpIpFacet2.get().getSenderHostname().orElse(null);
        RbelSocketAddress receiver1 = tcpIpFacet1.get().getReceiverHostname().orElse(null);
        RbelSocketAddress receiver2 = tcpIpFacet2.get().getReceiverHostname().orElse(null);
        return Objects.equals(sender1, sender2) && Objects.equals(receiver1, receiver2) || Objects.equals(sender1, receiver2) && Objects.equals(receiver1, sender2);
    }

    public Optional<RbelElement> findPreviousMessageInSameConnectionAs(RbelElement targetElement, Predicate<RbelElement> additionalFilter) {
        Stream<RbelElement> stream = this.getPreviousMessagesInSameConnectionAs(targetElement);
        return stream.filter(additionalFilter).findFirst();
    }

    public Stream<RbelElement> getPreviousMessagesInSameConnectionAs(RbelElement targetElement) {
        RbelMessagesDequeFacade messageHistoryAsync = this.converter.getMessageHistoryAsync();
        messageHistoryAsync.setAllowUnparsedMessagesToAppearInFacade(true);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(messageHistoryAsync.descendingIterator(), 16), false).filter(msg -> msg != targetElement).filter(msg -> this.haveSameConnection((RbelElement)msg, targetElement));
    }

    public Optional<RbelElement> findAndPairMatchingRequest(RbelElement response, Class<? extends RbelFacet> requestFacetClass) {
        if (response.hasFacet(TracingMessagePairFacet.class)) {
            return Optional.of(response.getFacetOrFail(TracingMessagePairFacet.class).getRequest());
        }
        List<RbelElement> lastMessages = this.getPreviousMessagesInSameConnectionAs(response).filter(msg -> msg.hasFacet(requestFacetClass)).takeWhile(msg -> !msg.hasFacet(TracingMessagePairFacet.class)).toList();
        if (lastMessages.isEmpty()) {
            return Optional.empty();
        }
        RbelElement request = lastMessages.get(lastMessages.size() - 1);
        TracingMessagePairFacet pair = TracingMessagePairFacet.builder().request(request).response(response).build();
        response.addFacet(pair);
        request.addFacet(pair);
        return Optional.of(request);
    }

    public String converterName() {
        return this.converter.getName();
    }

    @ConstructorProperties(value={"converter", "rootElement", "skipParsingWhenMessageLargerThanKb", "rbelKeyManager", "toBeConsideredPhases"})
    @Generated
    public RbelConversionExecutor(RbelConverter converter, RbelElement rootElement, int skipParsingWhenMessageLargerThanKb, RbelKeyManager rbelKeyManager, List<RbelConversionPhase> toBeConsideredPhases) {
        this.converter = converter;
        this.rootElement = rootElement;
        this.skipParsingWhenMessageLargerThanKb = skipParsingWhenMessageLargerThanKb;
        this.rbelKeyManager = rbelKeyManager;
        this.toBeConsideredPhases = toBeConsideredPhases;
    }

    @Generated
    public RbelConverter getConverter() {
        return this.converter;
    }

    @Generated
    public RbelKeyManager getRbelKeyManager() {
        return this.rbelKeyManager;
    }

    @Generated
    public RbelConversionPhase getConversionPhase() {
        return this.conversionPhase;
    }
}

