/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnownUuidsContainer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KnownUuidsContainer.class);
    private final Object monitor;
    private final Map<String, MessageUuidState> knownMessageUuids = new HashMap<String, MessageUuidState>();
    private final List<Consumer<List<String>>> removedMessageUuidsHandlers = new LinkedList<Consumer<List<String>>>();

    public KnownUuidsContainer(Object monitor) {
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlreadyConverted(String msgUuid) {
        Object object = this.monitor;
        synchronized (object) {
            return this.knownMessageUuids.get(msgUuid) == MessageUuidState.CONVERTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String messageUuid) {
        if (StringUtils.isBlank((CharSequence)messageUuid)) {
            return true;
        }
        Object object = this.monitor;
        synchronized (object) {
            if (this.knownMessageUuids.containsKey(messageUuid)) {
                return false;
            }
            this.knownMessageUuids.put(messageUuid, MessageUuidState.TO_BE_CONVERTED);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsConverted(String uuid) {
        Object object = this.monitor;
        synchronized (object) {
            this.knownMessageUuids.put(uuid, MessageUuidState.CONVERTED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<String> removedUuids;
        Object object = this.monitor;
        synchronized (object) {
            removedUuids = !this.removedMessageUuidsHandlers.isEmpty() ? List.copyOf(this.knownMessageUuids.keySet()) : null;
            this.knownMessageUuids.clear();
        }
        if (removedUuids != null && !removedUuids.isEmpty()) {
            log.trace("Clearing known message UUIDs: {}", removedUuids);
            this.removedMessageUuidsHandlers.forEach(handler -> handler.accept(removedUuids));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String uuid) {
        Object object = this.monitor;
        synchronized (object) {
            this.knownMessageUuids.remove(uuid);
        }
        this.removedMessageUuidsHandlers.forEach(handler -> handler.accept(List.of(uuid)));
    }

    public String toString() {
        return this.knownMessageUuids.toString();
    }

    public void addRemovedMessageUuidsHandler(Consumer<List<String>> handleRemovedMessageUuids) {
        this.removedMessageUuidsHandlers.add(handleRemovedMessageUuids);
    }

    public void clearRemovedMessageUuidsHandlers() {
        this.removedMessageUuidsHandlers.clear();
    }

    private static enum MessageUuidState {
        TO_BE_CONVERTED,
        CONVERTED;

    }
}

