/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.writer.tree;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.facet.RbelXmlAttributeFacet;
import de.gematik.rbellogger.data.facet.RbelXmlFacet;
import de.gematik.rbellogger.data.facet.RbelXmlNamespaceFacet;
import de.gematik.rbellogger.writer.RbelContentTreeConverter;
import de.gematik.rbellogger.writer.RbelContentType;
import de.gematik.rbellogger.writer.tree.RbelContentTreeNode;
import de.gematik.rbellogger.writer.tree.RbelElementToContentTreeNodeConverter;
import de.gematik.rbellogger.writer.tree.RbelStrictOrderContentTreeNode;
import de.gematik.test.tiger.common.config.TigerConfigurationLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelXmlElementToNodeConverter
implements RbelElementToContentTreeNodeConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelXmlElementToNodeConverter.class);
    public static final String IS_XML_ATTRIBUTE = "isXmlAttribute";
    public static final String IS_XML_NAMESPACE_PREFIX = "isXmlNamespacePrefix";
    public static final String XML_NAMESPACE_PREFIX = "namespacePrefix";
    public static final String XML_NAMESPACE_URI = "namespaceUri";

    @Override
    public boolean shouldConvert(RbelElement target) {
        return target.hasFacet(RbelXmlFacet.class);
    }

    @Override
    public RbelContentTreeNode convert(RbelElement el, TigerConfigurationLoader context, RbelContentTreeConverter converter) {
        RbelMultiMap map = el.getChildNodesWithKey().stream().flatMap(entry -> this.convertNode(context, converter, (Map.Entry<String, RbelElement>)entry).stream().map(childNode -> Pair.of((Object)((String)entry.getKey()), (Object)childNode))).collect(RbelMultiMap.COLLECTOR);
        RbelStrictOrderContentTreeNode result = new RbelStrictOrderContentTreeNode(map, el.getRawContent());
        result.setType(context.readStringOptional(RbelContentTreeConverter.ENCODE_AS).map(RbelContentType::seekValueFor).orElse(RbelContentType.XML));
        return result;
    }

    private List<RbelContentTreeNode> convertNode(TigerConfigurationLoader context, RbelContentTreeConverter converter, Map.Entry<String, RbelElement> entry) {
        ArrayList<RbelContentTreeNode> nodes = new ArrayList<RbelContentTreeNode>();
        for (RbelContentTreeNode node : converter.convertNode(entry.getValue(), entry.getKey(), context)) {
            if (entry.getValue().hasFacet(RbelXmlNamespaceFacet.class)) continue;
            if (entry.getValue().hasFacet(RbelXmlAttributeFacet.class)) {
                node.attributes().put(IS_XML_ATTRIBUTE, "true");
            }
            if (entry.getValue().hasFacet(RbelXmlFacet.class)) {
                ArrayList<RbelContentTreeNode> childNodes = new ArrayList<RbelContentTreeNode>();
                for (RbelContentTreeNode childNode : node.getChildNodes()) {
                    RbelXmlElementToNodeConverter.addChildNode(node, childNode, childNodes);
                }
                node.setupChildNodes(childNodes);
                entry.getValue().getFacet(RbelXmlFacet.class).ifPresent(rbelXmlFacet -> {
                    if (rbelXmlFacet.getNamespacePrefix() != null) {
                        node.attributes().put(XML_NAMESPACE_PREFIX, rbelXmlFacet.getNamespacePrefix());
                    }
                    if (rbelXmlFacet.getNamespaceUri() != null) {
                        node.attributes().put(XML_NAMESPACE_URI, rbelXmlFacet.getNamespaceUri());
                    }
                });
            }
            nodes.add(node);
        }
        return nodes;
    }

    private static void addChildNode(RbelContentTreeNode node, RbelContentTreeNode childNode, List<RbelContentTreeNode> childNodes) {
        if (childNode.getType() == null && childNode.getKey().orElseThrow().equals("text") && node.getType() != RbelContentType.XML) {
            node.setContent(childNode.getContent());
            node.setupChildNodes(List.of());
            log.trace("pulling up node '{}'", (Object)node.getRawStringContent());
        } else if (!childNode.hasTypeOptional(RbelContentType.XML).orElse(true).booleanValue() && !childNode.getKey().orElseThrow().equals("text")) {
            RbelStrictOrderContentTreeNode wrapperNode = new RbelStrictOrderContentTreeNode(new RbelMultiMap<RbelContentTreeNode>().with(childNode.getKey().orElseThrow(), childNode), null);
            wrapperNode.setType(childNode.getType());
            wrapperNode.setKey("text");
            wrapperNode.setCharset(node.getElementCharset());
            childNodes.add(wrapperNode);
            log.trace("wrapping node {}", (Object)node.getContent());
        } else {
            childNodes.add(childNode);
        }
    }
}

