/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.writer;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.key.RbelKeyManager;
import de.gematik.rbellogger.writer.RbelBearerTokenSerializer;
import de.gematik.rbellogger.writer.RbelContentTreeConverter;
import de.gematik.rbellogger.writer.RbelContentType;
import de.gematik.rbellogger.writer.RbelJsonSerializer;
import de.gematik.rbellogger.writer.RbelJweSerializer;
import de.gematik.rbellogger.writer.RbelJwtSerializer;
import de.gematik.rbellogger.writer.RbelSerializationException;
import de.gematik.rbellogger.writer.RbelSerializationResult;
import de.gematik.rbellogger.writer.RbelSerializer;
import de.gematik.rbellogger.writer.RbelUrlSerializer;
import de.gematik.rbellogger.writer.RbelXmlSerializer;
import de.gematik.rbellogger.writer.tree.RbelContentTreeNode;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelWriter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelWriter.class);
    private final RbelKeyManager rbelKeyManager;
    private final Map<RbelContentType, RbelSerializer> serializerMap = Map.of(RbelContentType.XML, new RbelXmlSerializer(), RbelContentType.JSON, new RbelJsonSerializer(), RbelContentType.JWT, new RbelJwtSerializer(), RbelContentType.JWE, new RbelJweSerializer(), RbelContentType.URL, new RbelUrlSerializer(), RbelContentType.BEARER_TOKEN, new RbelBearerTokenSerializer());

    public RbelWriter(RbelConverter rbelConverter) {
        this.rbelKeyManager = rbelConverter.getRbelKeyManager();
    }

    public RbelSerializationResult serializeWithEnforcedContentType(RbelElement input, RbelContentType enforcedContentType, TigerJexlContext jexlContext) {
        return new RbelWriterInstance(Optional.ofNullable(enforcedContentType), this.rbelKeyManager, jexlContext).serialize(input);
    }

    public RbelSerializationResult serialize(RbelElement input, TigerJexlContext jexlContext) {
        return new RbelWriterInstance(Optional.empty(), this.rbelKeyManager, jexlContext).serialize(input);
    }

    public RbelSerializationResult serialize(RbelContentTreeNode input, TigerJexlContext jexlContext) {
        return new RbelWriterInstance(Optional.empty(), this.rbelKeyManager, jexlContext).renderTree(input);
    }

    public RbelSerializationResult renderNode(RbelContentTreeNode input, TigerJexlContext jexlContext) {
        return new RbelWriterInstance(Optional.empty(), this.rbelKeyManager, jexlContext).renderNode(input);
    }

    @Generated
    public RbelKeyManager getRbelKeyManager() {
        return this.rbelKeyManager;
    }

    public class RbelWriterInstance {
        private final Optional<RbelContentType> fixedContentType;
        private final RbelKeyManager rbelKeyManager;
        private final TigerJexlContext jexlContext;

        public RbelSerializationResult serialize(RbelElement input) {
            RbelContentTreeNode treeRootNode = new RbelContentTreeConverter(input, this.jexlContext).convertToContentTree();
            return this.renderTree(treeRootNode);
        }

        public RbelSerializationResult renderTree(RbelContentTreeNode treeRootNode) {
            if (treeRootNode.getType() == null) {
                return RbelSerializationResult.of(treeRootNode);
            }
            RbelSerializer rbelSerializer = this.prepareSerializer(treeRootNode);
            return RbelSerializationResult.of(rbelSerializer.render(treeRootNode, this), treeRootNode.getType(), treeRootNode.getElementCharset());
        }

        public RbelSerializationResult renderNode(RbelContentTreeNode treeRootNode) {
            if (treeRootNode.getType() == null) {
                return RbelSerializationResult.of(treeRootNode);
            }
            RbelSerializer rbelSerializer = this.prepareSerializer(treeRootNode);
            return RbelSerializationResult.of(rbelSerializer.renderNode(treeRootNode, this), treeRootNode.getType(), treeRootNode.getElementCharset());
        }

        private RbelSerializer prepareSerializer(RbelContentTreeNode treeRootNode) {
            RbelContentType determinedType = this.determineContentType(treeRootNode);
            treeRootNode.setType(determinedType);
            RbelSerializer rbelSerializer = RbelWriter.this.serializerMap.get((Object)determinedType);
            if (rbelSerializer == null) {
                throw new RbelSerializationException("Could not find serializer for content-type '" + treeRootNode.getType() + "'");
            }
            return rbelSerializer;
        }

        private RbelContentType determineContentType(RbelContentTreeNode treeRootNode) {
            return this.fixedContentType.orElseGet(treeRootNode::getType);
        }

        @ConstructorProperties(value={"fixedContentType", "rbelKeyManager", "jexlContext"})
        @Generated
        public RbelWriterInstance(Optional<RbelContentType> fixedContentType, RbelKeyManager rbelKeyManager, TigerJexlContext jexlContext) {
            this.fixedContentType = fixedContentType;
            this.rbelKeyManager = rbelKeyManager;
            this.jexlContext = jexlContext;
        }

        @Generated
        public RbelKeyManager getRbelKeyManager() {
            return this.rbelKeyManager;
        }

        @Generated
        public TigerJexlContext getJexlContext() {
            return this.jexlContext;
        }
    }
}

