/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.writer;

import de.gematik.rbellogger.writer.RbelSerializer;
import de.gematik.rbellogger.writer.RbelWriter;
import de.gematik.rbellogger.writer.tree.RbelContentTreeNode;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;

public class RbelUrlSerializer
implements RbelSerializer {
    @Override
    public byte[] render(RbelContentTreeNode node, RbelWriter.RbelWriterInstance rbelWriter) {
        return this.renderToString(node, rbelWriter).getBytes();
    }

    @Override
    public byte[] renderNode(RbelContentTreeNode node, RbelWriter.RbelWriterInstance rbelWriter) {
        return this.render(node, rbelWriter);
    }

    public String renderToString(RbelContentTreeNode node, RbelWriter.RbelWriterInstance rbelWriter) {
        String basicPath = node.childNode("basicPath").map(RbelContentTreeNode::getRawStringContent).orElse("");
        Optional<String> queryString = this.getQueryString(node.childNode("parameters"), rbelWriter);
        return basicPath + queryString.map(params -> "?" + params).orElse("");
    }

    private Optional<String> getQueryString(Optional<RbelContentTreeNode> headers, RbelWriter.RbelWriterInstance rbelWriter) {
        return Optional.of(headers.map(RbelContentTreeNode::getChildNodes).stream().flatMap(Collection::stream).map(header -> header.getKey().orElseThrow() + "=" + new String(rbelWriter.renderTree((RbelContentTreeNode)header).getContent(), header.getElementCharset())).collect(Collectors.joining("&"))).filter(s -> !s.isBlank());
    }
}

