/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.writer;

import com.google.common.net.MediaType;
import de.gematik.rbellogger.writer.RbelContentType;
import de.gematik.rbellogger.writer.tree.RbelContentTreeNode;
import java.beans.ConstructorProperties;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;

public class RbelSerializationResult {
    private byte[] content;
    @Nullable
    private RbelContentType contentType;
    private Charset charset;

    public static RbelSerializationResult withUnknownType(byte[] content) {
        return RbelSerializationResult.builder().content(content).contentType(null).build();
    }

    public static RbelSerializationResult of(byte[] content, RbelContentType type, Charset charset) {
        return RbelSerializationResult.builder().content(content).contentType(type).charset(charset).build();
    }

    public static RbelSerializationResult of(RbelContentTreeNode treeRootNode) {
        return RbelSerializationResult.builder().content(treeRootNode.getContent()).contentType(treeRootNode.getType()).charset(treeRootNode.getElementCharset()).build();
    }

    public Optional<RbelContentType> getContentType() {
        return Optional.ofNullable(this.contentType);
    }

    public Optional<MediaType> getMediaType() {
        return this.getContentType().map(RbelContentType::getContentTypeString).map(MediaType::parse).map(mt -> {
            if (this.charset != null) {
                return mt.withCharset(this.charset);
            }
            return mt;
        });
    }

    public String getContentAsString() {
        if (this.getContent() == null) {
            return null;
        }
        if (this.getCharset() != null) {
            return new String(this.getContent(), this.getCharset());
        }
        return new String(this.getContent(), StandardCharsets.UTF_8);
    }

    @ConstructorProperties(value={"content", "contentType", "charset"})
    @Generated
    RbelSerializationResult(byte[] content, @Nullable RbelContentType contentType, Charset charset) {
        this.content = content;
        this.contentType = contentType;
        this.charset = charset;
    }

    @Generated
    public static RbelSerializationResultBuilder builder() {
        return new RbelSerializationResultBuilder();
    }

    @Generated
    public byte[] getContent() {
        return this.content;
    }

    @Generated
    public Charset getCharset() {
        return this.charset;
    }

    @Generated
    public void setContent(byte[] content) {
        this.content = content;
    }

    @Generated
    public void setContentType(@Nullable RbelContentType contentType) {
        this.contentType = contentType;
    }

    @Generated
    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelSerializationResult)) {
            return false;
        }
        RbelSerializationResult other = (RbelSerializationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getContent(), other.getContent())) {
            return false;
        }
        Optional<RbelContentType> this$contentType = this.getContentType();
        Optional<RbelContentType> other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !((Object)this$contentType).equals(other$contentType)) {
            return false;
        }
        Charset this$charset = this.getCharset();
        Charset other$charset = other.getCharset();
        return !(this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelSerializationResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getContent());
        Optional<RbelContentType> $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : ((Object)$contentType).hashCode());
        Charset $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelSerializationResult(content=" + Arrays.toString(this.getContent()) + ", contentType=" + this.getContentType() + ", charset=" + this.getCharset() + ")";
    }

    @Generated
    public static class RbelSerializationResultBuilder {
        @Generated
        private byte[] content;
        @Generated
        private RbelContentType contentType;
        @Generated
        private Charset charset;

        @Generated
        RbelSerializationResultBuilder() {
        }

        @Generated
        public RbelSerializationResultBuilder content(byte[] content) {
            this.content = content;
            return this;
        }

        @Generated
        public RbelSerializationResultBuilder contentType(@Nullable RbelContentType contentType) {
            this.contentType = contentType;
            return this;
        }

        @Generated
        public RbelSerializationResultBuilder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        @Generated
        public RbelSerializationResult build() {
            return new RbelSerializationResult(this.content, this.contentType, this.charset);
        }

        @Generated
        public String toString() {
            return "RbelSerializationResult.RbelSerializationResultBuilder(content=" + Arrays.toString(this.content) + ", contentType=" + this.contentType + ", charset=" + this.charset + ")";
        }
    }
}

