/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.writer;

import de.gematik.rbellogger.key.RbelKey;
import de.gematik.rbellogger.writer.RbelJsonSerializer;
import de.gematik.rbellogger.writer.RbelSerializationException;
import de.gematik.rbellogger.writer.RbelSerializer;
import de.gematik.rbellogger.writer.RbelWriter;
import de.gematik.rbellogger.writer.tree.RbelContentTreeNode;
import java.security.Key;
import java.util.Collection;
import java.util.Optional;
import org.jose4j.jca.ProviderContext;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;

public class RbelJwtSerializer
implements RbelSerializer {
    @Override
    public byte[] render(RbelContentTreeNode node, RbelWriter.RbelWriterInstance rbelWriter) {
        return this.renderToString(node, rbelWriter).getBytes();
    }

    @Override
    public byte[] renderNode(RbelContentTreeNode node, RbelWriter.RbelWriterInstance rbelWriter) {
        return this.render(node, rbelWriter);
    }

    public String renderToString(RbelContentTreeNode node, RbelWriter.RbelWriterInstance rbelWriter) {
        JsonWebSignature jws = new JsonWebSignature();
        ProviderContext context = new ProviderContext();
        context.getSuppliedKeyProviderContext().setGeneralProvider("BC");
        jws.setProviderContext(context);
        this.writeHeaderInJws(node.childNode("header"), jws, rbelWriter);
        jws.setPayloadBytes(rbelWriter.renderTree(node.childNode("body").orElseThrow(() -> new RbelSerializationException("Could not find body-node needed for JWT serialization in node '" + node.getKey() + "'!"))).getContent());
        jws.setKey(this.findSignerKey(node.childNode("signature"), rbelWriter));
        try {
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new RbelSerializationException("Error writing into Jwt", (Exception)((Object)e));
        }
    }

    private Key findSignerKey(Optional<RbelContentTreeNode> signature, RbelWriter.RbelWriterInstance rbelWriter) {
        if (signature.isEmpty()) {
            throw new RbelSerializationException("Could not find signature-node needed for JWT serialization!");
        }
        RbelContentTreeNode verifiedUsing = signature.get().childNode("verifiedUsing").orElseThrow(() -> new RbelSerializationException("Could not find verifiedUsing-node needed for JWT serialization!"));
        String keyName = verifiedUsing.getRawStringContent();
        RbelKey rbelKey = rbelWriter.getRbelKeyManager().findKeyByName(keyName).filter(RbelKey::isPrivateKey).or(() -> rbelWriter.getRbelKeyManager().findKeyByName("prk_" + keyName)).filter(RbelKey::isPrivateKey).or(() -> rbelWriter.getRbelKeyManager().findKeyByName(keyName.replace("puk_", "prk_"))).filter(RbelKey::isPrivateKey).orElseThrow(() -> new RbelSerializationException("Could not find key named '" + keyName + "'!"));
        return rbelKey.getKey();
    }

    private void writeHeaderInJws(Optional<RbelContentTreeNode> headers, JsonWebSignature jws, RbelWriter.RbelWriterInstance rbelWriter) {
        headers.map(RbelContentTreeNode::getChildNodes).stream().flatMap(Collection::stream).forEach(header -> {
            if (RbelJsonSerializer.isJsonArray(header)) {
                jws.setHeader(header.getKey().orElseThrow(), header.getChildNodes().stream().map(childNode -> new String(rbelWriter.renderTree((RbelContentTreeNode)childNode).getContent(), childNode.getElementCharset())).toList());
            } else {
                jws.setHeader(header.getKey().orElseThrow(), new String(rbelWriter.renderTree((RbelContentTreeNode)header).getContent(), header.getElementCharset()));
            }
        });
    }
}

