/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.writer;

import de.gematik.rbellogger.writer.RbelContentType;
import de.gematik.rbellogger.writer.RbelSerializationException;
import de.gematik.rbellogger.writer.RbelSerializer;
import de.gematik.rbellogger.writer.RbelWriter;
import de.gematik.rbellogger.writer.tree.RbelContentTreeNode;
import java.util.StringJoiner;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelJsonSerializer
implements RbelSerializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelJsonSerializer.class);

    @Override
    public byte[] render(RbelContentTreeNode node, RbelWriter.RbelWriterInstance rbelWriter) {
        return this.renderToString(node, rbelWriter).getBytes();
    }

    @Override
    public byte[] renderNode(RbelContentTreeNode node, RbelWriter.RbelWriterInstance rbelWriter) {
        return this.render(node, rbelWriter);
    }

    public String renderToString(RbelContentTreeNode node, RbelWriter.RbelWriterInstance rbelWriter) {
        if (RbelJsonSerializer.isJsonArray(node)) {
            StringJoiner joiner = new StringJoiner(",");
            for (RbelContentTreeNode childNode : node.getChildNodes()) {
                joiner.add(this.renderToString(childNode, rbelWriter));
            }
            return "[" + joiner + "]";
        }
        if (this.isPrimitive(node) || !node.hasTypeOptional(RbelContentType.JSON).orElse(true).booleanValue()) {
            if (this.isStringPrimitive(node)) {
                return "\"" + RbelJsonSerializer.getStringContentForNode(node, rbelWriter) + "\"";
            }
            return RbelJsonSerializer.getStringContentForNode(node, rbelWriter);
        }
        if (this.isJsonObject(node)) {
            StringJoiner joiner = new StringJoiner(",");
            for (RbelContentTreeNode childNode : node.getChildNodes()) {
                joiner.add("\"" + childNode.getKey().orElseThrow() + "\": " + this.renderToString(childNode, rbelWriter));
            }
            return "{" + joiner + "}";
        }
        throw new RbelSerializationException("Failed to serialize the node: " + node);
    }

    private static String getStringContentForNode(RbelContentTreeNode node, RbelWriter.RbelWriterInstance rbelWriter) {
        if (node.getChildNodes().isEmpty()) {
            if (node.getContent() == null) {
                return "{}";
            }
            return new String(node.getContent(), node.getElementCharset());
        }
        return new String(rbelWriter.renderTree(node).getContent(), node.getElementCharset());
    }

    public static boolean isJsonArray(RbelContentTreeNode node) {
        return node.attributes().containsKey("jsonArray");
    }

    private boolean isJsonObject(RbelContentTreeNode node) {
        return !node.attributes().containsKey("jsonArray");
    }

    private boolean isStringPrimitive(RbelContentTreeNode node) {
        return !node.attributes().containsKey("jsonNonStringPrimitive");
    }

    private boolean isPrimitive(RbelContentTreeNode node) {
        return node.attributes().containsKey("jsonPrimitive") || node.getChildNodes().isEmpty();
    }
}

