/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.writer;

import java.beans.ConstructorProperties;
import java.util.stream.Stream;
import lombok.Generated;

public enum RbelContentType {
    XML("application/xml"),
    JSON("application/json"),
    JWT("application/jwt"),
    JWE("application/octet-stream"),
    URL("text/plain"),
    BEARER_TOKEN("text/plain");

    final String contentTypeString;

    public static RbelContentType seekValueFor(String rawValue) {
        String compareValue = rawValue.trim().toUpperCase();
        return Stream.of(RbelContentType.values()).filter(candidate -> candidate.name().equals(compareValue)).findFirst().orElseThrow(() -> new RuntimeException("Could not match content type '" + rawValue + "'!"));
    }

    @ConstructorProperties(value={"contentTypeString"})
    @Generated
    private RbelContentType(String contentTypeString) {
        this.contentTypeString = contentTypeString;
    }

    @Generated
    public String getContentTypeString() {
        return this.contentTypeString;
    }
}

