/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.writer;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelJsonFacet;
import de.gematik.rbellogger.data.facet.RbelNestedFacet;
import de.gematik.rbellogger.data.facet.RbelXmlFacet;
import de.gematik.rbellogger.exceptions.RbelContentTreeConversionException;
import de.gematik.rbellogger.writer.RbelContentType;
import de.gematik.rbellogger.writer.tree.RbelBearerTokenElementToNodeConverter;
import de.gematik.rbellogger.writer.tree.RbelContentTreeNode;
import de.gematik.rbellogger.writer.tree.RbelElementToContentTreeNodeConverter;
import de.gematik.rbellogger.writer.tree.RbelElementWrapperContentTreeNode;
import de.gematik.rbellogger.writer.tree.RbelJsonElementToNodeConverter;
import de.gematik.rbellogger.writer.tree.RbelJwtElementToNodeConverter;
import de.gematik.rbellogger.writer.tree.RbelXmlElementToNodeConverter;
import de.gematik.test.tiger.common.config.AbstractTigerConfigurationSource;
import de.gematik.test.tiger.common.config.BasicTigerConfigurationSource;
import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import de.gematik.test.tiger.common.config.TigerConfigurationLoader;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.jexl3.JexlContext;

public class RbelContentTreeConverter {
    public static final TigerConfigurationKey ENCODE_AS = new TigerConfigurationKey(new String[]{"rbel", "conversion", "encodeAs"});
    private static final String TGR_ENCODE_AS = "tgrEncodeAs";
    private static final String TGR_FOR = "tgrFor";
    private static final String TGR_IF = "tgrIf";
    private List<RbelElementToContentTreeNodeConverter> converters = List.of(new RbelXmlElementToNodeConverter(), new RbelJsonElementToNodeConverter(), new RbelJwtElementToNodeConverter(), new RbelBearerTokenElementToNodeConverter());
    private final RbelElement input;
    private final TigerJexlContext jexlContext;
    private Set<String> transitiveTypes = Set.of("xml", "json");

    public RbelContentTreeConverter(RbelElement input, TigerJexlContext jexlContext) {
        this.input = input;
        this.jexlContext = jexlContext;
    }

    public RbelContentTreeNode convertToContentTree() {
        return this.convertNode(this.input, null, RbelContentTreeConverter.initializeConversionContext()).get(0);
    }

    private static TigerConfigurationLoader initializeConversionContext() {
        TigerConfigurationLoader conversionContext = new TigerConfigurationLoader();
        TigerGlobalConfiguration.listSources().stream().map(AbstractTigerConfigurationSource::copy).forEach(arg_0 -> ((TigerConfigurationLoader)conversionContext).addConfigurationSource(arg_0));
        return conversionContext;
    }

    public List<RbelContentTreeNode> convertNode(RbelElement input, String key, TigerConfigurationLoader conversionContext) {
        Optional<Object> encodingConfigurationSource = Optional.empty();
        if (this.isReservedKey(key)) {
            return List.of();
        }
        if (!this.evaluateTgrIfCondition(input)) {
            return List.of();
        }
        Optional encodeAsOptional = input.getFirst(TGR_ENCODE_AS).flatMap(el -> this.extractEncodingType(conversionContext, (RbelElement)el));
        encodingConfigurationSource = encodeAsOptional.filter(this::isTransitiveType).map(s -> {
            BasicTigerConfigurationSource source = new BasicTigerConfigurationSource(SourceType.RUNTIME_EXPORT, Map.of(ENCODE_AS, s));
            conversionContext.addConfigurationSource((AbstractTigerConfigurationSource)source);
            return source;
        });
        List<RbelContentTreeNode> result = input.getFirst(TGR_FOR).isPresent() ? this.executeTgrForLoop(input, key, conversionContext) : this.convertRbelElement(input, key, conversionContext);
        encodingConfigurationSource.ifPresent(arg_0 -> ((TigerConfigurationLoader)conversionContext).removeConfigurationSource(arg_0));
        encodeAsOptional.ifPresent(s -> result.forEach(node -> node.setType(RbelContentType.seekValueFor(s))));
        return result;
    }

    private boolean isTransitiveType(String encodingType) {
        return this.transitiveTypes.contains(encodingType);
    }

    private Optional<String> extractEncodingType(TigerConfigurationLoader conversionContext, RbelElement encodeAsOptional) {
        return Optional.ofNullable(encodeAsOptional).map(el -> this.convertRbelElement((RbelElement)el, TGR_ENCODE_AS, conversionContext)).stream().flatMap(Collection::stream).map(el -> el.getChildNodes().stream().findFirst().orElse(el)).map(el -> new String(el.getContent(), el.getElementCharset())).findFirst();
    }

    private static List<RbelContentTreeNode> evaluateTgrEncodeAsIfPresent(RbelElement element, List<RbelContentTreeNode> input) {
        Optional<RbelElement> encodeAs = element.getFirst(TGR_ENCODE_AS);
        if (encodeAs.isPresent()) {
            for (RbelContentTreeNode node : input) {
                node.setType(RbelContentType.valueOf(encodeAs.get().getRawStringContent()));
            }
        }
        return input;
    }

    private List<RbelContentTreeNode> executeTgrForLoop(RbelElement input, String key, TigerConfigurationLoader conversionContext) {
        String loopStatement = this.findLoopStatement(input);
        TigerJexlContext context = this.buildNewExpressionEvaluationContext();
        TigerJexlExecutor rbelJexlExecutor = TigerJexlExecutor.createNewExecutor();
        TigerJexlContext jexlMapContext = TigerJexlExecutor.buildJexlMapContext((Object)context.getRootElement(), Optional.ofNullable(key));
        context.putAll((Map)jexlMapContext);
        String resolvedLoopStatement = TigerGlobalConfiguration.resolvePlaceholdersWithContext((String)loopStatement, (TigerJexlContext)context);
        rbelJexlExecutor.buildScript("t = " + resolvedLoopStatement.split(":")[1]).execute((JexlContext)context);
        ArrayList<RbelContentTreeNode> resultList = new ArrayList<RbelContentTreeNode>();
        for (Object iterate : (Collection)context.get("t")) {
            BasicTigerConfigurationSource localSource = new BasicTigerConfigurationSource(SourceType.RUNTIME_EXPORT, TigerConfigurationLoader.addYamlToMap(iterate, (TigerConfigurationKey)new TigerConfigurationKey(new String[]{loopStatement.split(":")[0].trim()}), new HashMap()));
            conversionContext.addConfigurationSource((AbstractTigerConfigurationSource)localSource);
            resultList.addAll(this.convertRbelElement(input, key, conversionContext));
            conversionContext.removeConfigurationSource((AbstractTigerConfigurationSource)localSource);
        }
        return RbelContentTreeConverter.evaluateTgrEncodeAsIfPresent(input, resultList);
    }

    private TigerJexlContext buildNewExpressionEvaluationContext() {
        TigerJexlContext context = new TigerJexlContext();
        context.putAll((Map)this.jexlContext);
        context.putAll((Map)TigerGlobalConfiguration.instantiateConfigurationBean(Map.class, (String[])new String[0]).orElseThrow());
        return context;
    }

    private String findLoopStatement(RbelElement input) {
        Optional<RbelElement> tgrFor = input.getFirst(TGR_FOR);
        if (tgrFor.isEmpty()) {
            throw new RbelContentTreeConversionException("tgrFor not present even though call stack should guarantee so!");
        }
        if (tgrFor.get().getChildNodes().size() == 1) {
            return tgrFor.get().getChildNodes().get(0).getRawStringContent();
        }
        return tgrFor.get().getRawStringContent();
    }

    private boolean isReservedKey(String key) {
        if (key == null) {
            return false;
        }
        return List.of(TGR_IF, TGR_FOR, TGR_ENCODE_AS).contains(key);
    }

    private boolean evaluateTgrIfCondition(RbelElement input) {
        return input.getFirst(TGR_IF).flatMap(this::retrieveTextContent).map(text -> TigerJexlExecutor.matchesAsJexlExpression((String)text, (TigerJexlContext)this.buildNewExpressionEvaluationContext())).orElse(true);
    }

    private Optional<String> retrieveTextContent(RbelElement rbelElement) {
        if (rbelElement.hasFacet(RbelXmlFacet.class)) {
            return rbelElement.getFacet(RbelXmlFacet.class).map(RbelXmlFacet::getChildElements).map(childs -> (RbelElement)childs.get("text")).map(RbelElement::getRawStringContent);
        }
        if (rbelElement.hasFacet(RbelJsonFacet.class)) {
            return rbelElement.getFacet(RbelNestedFacet.class).map(RbelNestedFacet::getNestedElement).map(RbelElement::getRawStringContent);
        }
        return Optional.ofNullable(rbelElement.getRawStringContent());
    }

    private List<RbelContentTreeNode> convertRbelElement(RbelElement input, String key, TigerConfigurationLoader conversionContext) {
        RbelContentTreeNode result = this.converters.stream().filter(entry -> entry.shouldConvert(input)).findFirst().map(converter -> converter.convert(input, conversionContext, this)).orElseGet(() -> RbelElementWrapperContentTreeNode.constructFromRbelElement(input, conversionContext, this.jexlContext));
        result.setCharset(input.getElementCharset());
        result.setKey(key);
        return List.of(result);
    }

    @ConstructorProperties(value={"converters", "input", "jexlContext", "transitiveTypes"})
    @Generated
    public RbelContentTreeConverter(List<RbelElementToContentTreeNodeConverter> converters, RbelElement input, TigerJexlContext jexlContext, Set<String> transitiveTypes) {
        this.converters = converters;
        this.input = input;
        this.jexlContext = jexlContext;
        this.transitiveTypes = transitiveTypes;
    }

    @Generated
    public TigerJexlContext getJexlContext() {
        return this.jexlContext;
    }
}

