/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.util.RbelPathAble;
import de.gematik.rbellogger.util.RbelPathExecutor;
import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import de.gematik.test.tiger.common.config.TigerConfigurationLoader;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

class TigerConfigurationRbelObject
extends RbelPathAble {
    private final StaticTigerConfiguration configuration;
    private final TigerConfigurationKey key;

    public TigerConfigurationRbelObject(TigerConfigurationLoader configuration) {
        this(new StaticTigerConfiguration(configuration), new TigerConfigurationKey(new String[]{""}));
    }

    public String toString() {
        return "[" + this.key.downsampleKey() + "]";
    }

    public Optional<RbelPathAble> getFirst(String key) {
        return this.getAll(key).stream().map(RbelPathAble.class::cast).findFirst();
    }

    @Override
    public TigerConfigurationRbelObject getParentNode() {
        return new TigerConfigurationRbelObject(this.configuration, new TigerConfigurationKey(this.key).getParentNodeOrIdentity());
    }

    public List<TigerConfigurationRbelObject> getAll(String subkey) {
        TigerConfigurationKey targetKey = this.key.createWithNewSubkey(subkey);
        return this.configuration.keySet().stream().filter(e -> e.isBelow(targetKey) || e.equals((Object)targetKey)).map(e -> {
            if (e.isDirectlyBelow(this.key)) {
                return new TigerConfigurationRbelObject(this.configuration, (TigerConfigurationKey)e);
            }
            return new TigerConfigurationRbelObject(this.configuration, new TigerConfigurationKey(e.subList(0, this.key.size() + 1)));
        }).distinct().toList();
    }

    public List<TigerConfigurationRbelObject> getChildNodes() {
        ArrayList<TigerConfigurationRbelObject> result = new ArrayList<TigerConfigurationRbelObject>();
        for (Map.Entry e : this.configuration.entrySet()) {
            TigerConfigurationRbelObject configurationRbelObject;
            if (!((TigerConfigurationKey)e.getKey()).isBelow(this.key) || result.contains(configurationRbelObject = ((TigerConfigurationKey)e.getKey()).isDirectlyBelow(this.key) ? new TigerConfigurationRbelObject(this.configuration, (TigerConfigurationKey)e.getKey()) : new TigerConfigurationRbelObject(this.configuration, new TigerConfigurationKey(((TigerConfigurationKey)e.getKey()).subList(0, this.key.size() + 1))))) continue;
            result.add(configurationRbelObject);
        }
        return result;
    }

    public RbelMultiMap<TigerConfigurationRbelObject> getChildNodesWithKey() {
        return this.configuration.entrySet().stream().filter(e -> ((TigerConfigurationKey)e.getKey()).isBelow(this.key)).map(e -> {
            if (((TigerConfigurationKey)e.getKey()).isDirectlyBelow(this.key)) {
                return new TigerConfigurationRbelObject(this.configuration, (TigerConfigurationKey)e.getKey());
            }
            return new TigerConfigurationRbelObject(this.configuration, new TigerConfigurationKey(((TigerConfigurationKey)e.getKey()).subList(0, this.key.size() + 1)));
        }).distinct().map(e -> Pair.of((Object)e.getKey().get(), (Object)e)).collect(RbelMultiMap.COLLECTOR);
    }

    @Override
    public Optional<String> getKey() {
        return Optional.of(this.key.downsampleKey());
    }

    @Override
    public String getRawStringContent() {
        return (String)this.configuration.get(this.key);
    }

    public List<TigerConfigurationRbelObject> findRbelPathMembers(String rbelPath) {
        return new RbelPathExecutor<TigerConfigurationRbelObject>(this, rbelPath).execute();
    }

    @ConstructorProperties(value={"configuration", "key"})
    @Generated
    private TigerConfigurationRbelObject(StaticTigerConfiguration configuration, TigerConfigurationKey key) {
        this.configuration = configuration;
        this.key = key;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerConfigurationRbelObject)) {
            return false;
        }
        TigerConfigurationRbelObject other = (TigerConfigurationRbelObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StaticTigerConfiguration this$configuration = this.configuration;
        StaticTigerConfiguration other$configuration = other.configuration;
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        Optional<String> this$key = this.getKey();
        Optional<String> other$key = other.getKey();
        return !(this$key == null ? other$key != null : !((Object)this$key).equals(other$key));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerConfigurationRbelObject;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StaticTigerConfiguration $configuration = this.configuration;
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        Optional<String> $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        return result;
    }

    private static class StaticTigerConfiguration
    extends HashMap<TigerConfigurationKey, String> {
        public StaticTigerConfiguration(TigerConfigurationLoader configuration) {
            super(configuration.retrieveMapUnresolved());
        }
    }
}

