/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import com.google.common.annotations.VisibleForTesting;
import de.gematik.rbellogger.RbelOptions;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.exceptions.RbelPathException;
import de.gematik.rbellogger.util.RbelPathAble;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import java.beans.ConstructorProperties;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelPathExecutor<T extends RbelPathAble> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelPathExecutor.class);
    private final T targetObject;
    private final String rbelPath;

    private static List<RbelPathAble> findAllChildrenRecursive(RbelPathAble content) {
        List<? extends RbelPathAble> childNodes = content.getChildNodes();
        ArrayList<RbelPathAble> result = new ArrayList<RbelPathAble>(childNodes);
        childNodes.stream().map(RbelPathExecutor::findAllChildrenRecursive).flatMap(Collection::stream).forEach(result::add);
        return result;
    }

    @VisibleForTesting
    public static List<String> splitRbelPathIntoKeys(String rbelPath) {
        String[] split = rbelPath.substring(1).trim().split("\\.(?!(\\.|[^\\[]*]))");
        ArrayList<String> keys = new ArrayList<String>();
        for (String part : split) {
            if (StringUtils.isBlank((CharSequence)part)) continue;
            if (part.length() > 1 && part.endsWith(".")) {
                keys.add(part.substring(0, part.length() - 1));
                keys.add(".");
                continue;
            }
            keys.add(part);
        }
        if (RbelOptions.isActivateRbelPathDebugging()) {
            log.debug("Split rbelPath {} into the following keys: {}", (Object)rbelPath, keys);
        }
        return keys;
    }

    private static List<? extends RbelPathAble> executeNamedSelection(String functionExpression, RbelPathAble content, BiPredicate<String, String> keyPredicate) {
        return Stream.of(functionExpression.split("\\|")).map(s -> {
            if (!s.startsWith("'") || !s.endsWith("'")) {
                throw new RbelPathException("Requiring all name selector to be surrounded by '. Violated by " + s);
            }
            return s.substring(1, s.length() - 1);
        }).map(s1 -> URLDecoder.decode(s1, StandardCharsets.UTF_8)).map(key -> content.getChildNodesWithKey().stream().filter(entry -> keyPredicate.test((String)key, (String)entry.getKey())).map(Map.Entry::getValue).toList()).flatMap(Collection::stream).toList();
    }

    public List<T> execute() {
        this.enforceCorrectRbelPathForm();
        List<String> keys = RbelPathExecutor.splitRbelPathIntoKeys(this.rbelPath);
        List<Object> candidates = List.of(this.targetObject);
        this.performPreExecutionLogging(keys);
        this.checkFurtherPreconditions(keys);
        for (String key : keys) {
            if (RbelOptions.isActivateRbelPathDebugging()) {
                log.info("Resolving key '{}' with candidates {}", (Object)key, candidates.stream().flatMap(el -> el.getChildNodesWithKey().stream()).map(Map.Entry::getKey).toList());
            }
            List<T> lastIterationCandidates = candidates;
            if (!(candidates = candidates.stream().map(element -> this.resolveRbelPathElement(key, (RbelPathAble)element)).flatMap(Collection::stream).map(RbelPathAble::descendToContentNodeIfAdvised).flatMap(Collection::stream).map(o -> o).distinct().toList()).isEmpty() || !RbelOptions.isActivateRbelPathDebugging()) continue;
            log.warn("No more candidate-nodes in RbelPath execution! Last batch of candidates had {} elements: \n {}", (Object)lastIterationCandidates.size(), RbelPathExecutor.getPathList(lastIterationCandidates));
        }
        List<RbelPathAble> resultList = candidates.stream().filter(RbelPathAble::shouldElementBeKeptInFinalResult).toList();
        if (RbelOptions.isActivateRbelPathDebugging()) {
            log.info("Returning {} result elements for RbelPath {} (Results are {})", new Object[]{resultList.size(), this.rbelPath, RbelPathExecutor.getPathList(resultList)});
        }
        return resultList;
    }

    private void performPreExecutionLogging(List<String> keys) {
        T t;
        if (RbelOptions.isActivateRbelPathDebugging() && (t = this.targetObject) instanceof RbelElement) {
            RbelElement asRbelElement = (RbelElement)t;
            log.info("Executing RBelPath {} into element '{}' (limited view to {} levels):\n{}", new Object[]{this.rbelPath, ((RbelPathAble)this.targetObject).findNodePath(), Math.max(RbelOptions.getRbelPathTreeViewMinimumDepth(), keys.size()), asRbelElement.printTreeStructure(Math.max(RbelOptions.getRbelPathTreeViewMinimumDepth(), keys.size()), false)});
        }
    }

    private void checkFurtherPreconditions(List<String> keys) {
        if (keys.stream().anyMatch(s -> s.startsWith(" ") || s.endsWith(" "))) {
            throw new RbelPathException("Found key with unescaped spaces in rbel-path '" + this.rbelPath + "'! (If intended, please escape using \"[' b b ']\")");
        }
    }

    private void enforceCorrectRbelPathForm() {
        if (!this.rbelPath.startsWith("$")) {
            throw new RbelPathException("RbelPath expressions always start with $. (got '" + this.rbelPath + "')");
        }
    }

    private List<? extends RbelPathAble> resolveRbelPathElement(String key, RbelPathAble content) {
        if (key.equals(".")) {
            List<RbelPathAble> wildcardResult = RbelPathExecutor.findAllChildrenRecursive(content);
            wildcardResult.add(content);
            return wildcardResult;
        }
        String[] parts = key.split("\\[", 2);
        String selectorPart = parts[0];
        List<RbelPathAble> keySelectionResult = this.executeNonFunctionalExpression(selectorPart, content);
        if (parts.length == 1 || keySelectionResult.isEmpty()) {
            return keySelectionResult;
        }
        return this.filterResultsThroughFunctionalSelector(keySelectionResult, parts[1].substring(0, parts[1].length() - 1), selectorPart.isEmpty());
    }

    private List<? extends RbelPathAble> filterResultsThroughFunctionalSelector(List<? extends RbelPathAble> keySelectionResult, String functionalPart, boolean selectorPartIsEmpty) {
        if (RbelOptions.isActivateRbelPathDebugging()) {
            log.info("Filtering resulting nodes '{}' through functional expression '{}'", RbelPathExecutor.getPathList(keySelectionResult), (Object)functionalPart);
        }
        if (NumberUtils.isParsable((String)functionalPart)) {
            int selectionIndex = Integer.parseInt(functionalPart);
            if (keySelectionResult.size() <= selectionIndex) {
                return Collections.emptyList();
            }
            return List.of(keySelectionResult.get(selectionIndex));
        }
        return keySelectionResult.stream().map(candidate -> this.executeFunctionalExpression(functionalPart, (RbelPathAble)candidate, selectorPartIsEmpty)).flatMap(Collection::stream).toList();
    }

    private List<? extends RbelPathAble> executeNonFunctionalExpression(String key, RbelPathAble content) {
        if (key.equals("*")) {
            return content.getChildNodes();
        }
        if (key.isEmpty()) {
            return List.of(content);
        }
        return content.getAll(key);
    }

    private List<? extends RbelPathAble> executeFunctionalExpression(String functionExpression, RbelPathAble content, boolean selectorPartIsEmpty) {
        if (functionExpression.startsWith("'") && functionExpression.endsWith("'")) {
            return RbelPathExecutor.executeNamedSelection(functionExpression, content, String::equals);
        }
        if (functionExpression.equals("*")) {
            return content.getChildNodes();
        }
        if (functionExpression.startsWith("?")) {
            if (functionExpression.startsWith("?(") && functionExpression.endsWith(")")) {
                return this.findChildNodesByJexlExpression(content, functionExpression.substring(2, functionExpression.length() - 1), selectorPartIsEmpty);
            }
            throw new RbelPathException("Invalid JEXL-Expression encountered (Does not start with '?(' and end with ')'): " + functionExpression);
        }
        if (functionExpression.startsWith("~")) {
            if (functionExpression.startsWith("~'") && functionExpression.endsWith("'")) {
                return RbelPathExecutor.executeNamedSelection(functionExpression.substring(1), content, String::equalsIgnoreCase);
            }
            throw new RbelPathException("Invalid JEXL-Expression encountered (Does not start with \"~'\"' and end with \")\"): " + functionExpression);
        }
        throw new RbelPathException("Unknown function expression encountered: " + functionExpression);
    }

    private List<? extends RbelPathAble> findChildNodesByJexlExpression(RbelPathAble position, String jexl, boolean selectorPartIsEmpty) {
        ArrayList<? extends RbelPathAble> candidates = new ArrayList<RbelPathAble>();
        if (selectorPartIsEmpty) {
            candidates.addAll(position.getChildNodes());
        } else {
            candidates.add(position);
        }
        return ((Stream)candidates.stream().parallel()).filter(candidate -> TigerJexlExecutor.matchesAsJexlExpression((String)jexl, (TigerJexlContext)new TigerJexlContext().withKey((String)candidate.getKey().orElse(null)).withCurrentElement(candidate).withRootElement(this.targetObject))).toList();
    }

    private static <T extends RbelPathAble> List<String> getPathList(List<T> resultList) {
        return resultList.stream().map(RbelPathAble::findNodePath).map(path -> "$." + path).toList();
    }

    @ConstructorProperties(value={"targetObject", "rbelPath"})
    @Generated
    public RbelPathExecutor(T targetObject, String rbelPath) {
        this.targetObject = targetObject;
        this.rbelPath = rbelPath;
    }
}

