/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import de.gematik.rbellogger.data.RbelMultiMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public abstract class RbelPathAble {
    public abstract Optional<? extends RbelPathAble> getFirst(String var1);

    public abstract RbelPathAble getParentNode();

    public abstract List<? extends RbelPathAble> getAll(String var1);

    public abstract List<? extends RbelPathAble> getChildNodes();

    public abstract RbelMultiMap<? extends RbelPathAble> getChildNodesWithKey();

    public abstract Optional<String> getKey();

    public abstract String getRawStringContent();

    public abstract List<? extends RbelPathAble> findRbelPathMembers(String var1);

    public List<RbelPathAble> descendToContentNodeIfAdvised() {
        return List.of(this);
    }

    public boolean shouldElementBeKeptInFinalResult() {
        return true;
    }

    public String findNodePath() {
        LinkedList<Optional<String>> keyList = new LinkedList<Optional<String>>();
        AtomicReference<RbelPathAble> ptr = new AtomicReference<RbelPathAble>(this);
        while (ptr.get().getParentNode() != null) {
            keyList.addFirst(ptr.get().getParentNode().getChildNodesWithKey().stream().filter(entry -> entry.getValue() == ptr.get()).map(Map.Entry::getKey).findFirst());
            ptr.set(ptr.get().getParentNode());
        }
        return keyList.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining("."));
    }
}

