/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import com.google.common.base.CharMatcher;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.util.RbelContextDecorator;
import de.gematik.rbellogger.util.RbelPathAble;
import de.gematik.rbellogger.util.RbelPathExecutor;
import de.gematik.rbellogger.util.TigerConfigurationRbelObject;
import de.gematik.test.tiger.common.TokenSubstituteHelper;
import de.gematik.test.tiger.common.config.TigerConfigurationLoader;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntPredicate;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelJexlExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelJexlExecutor.class);
    private static final String RBEL_PATH_CHARS = "(\\$\\.|\\w|\\.|\\*|-)+.*";
    private static boolean isInitialized = false;

    public static synchronized void initialize() {
        if (isInitialized) {
            return;
        }
        TokenSubstituteHelper.getReplacerOrder().addFirst(Pair.of((Object)Character.valueOf('?'), (str, source, ctx) -> ctx.map(TigerJexlContext::getCurrentElement).filter(RbelElement.class::isInstance).map(RbelElement.class::cast).flatMap(el -> el.findElement(str)).map(el -> el.printValue().orElseGet(el::getRawStringContent))));
        TigerJexlExecutor.setExpressionPreMapper(RbelJexlExecutor::evaluateRbelPathExpressions);
        TigerJexlExecutor.addContextDecorator(RbelContextDecorator::buildJexlMapContext);
        TokenSubstituteHelper.setResolve(RbelJexlExecutor::resolveConfigurationValue);
        isInitialized = true;
    }

    private static Optional<String> resolveConfigurationValue(String key, TigerConfigurationLoader configuration) {
        return configuration.readStringOptional(key).or(() -> new RbelPathExecutor<TigerConfigurationRbelObject>(new TigerConfigurationRbelObject(configuration), "$." + key).execute().stream().findFirst().map(TigerConfigurationRbelObject::getRawStringContent));
    }

    public static boolean matchAsTextExpression(Object element, String textExpression) {
        try {
            boolean textMatchResult = Objects.requireNonNull(((RbelElement)element).getRawStringContent()).contains(textExpression);
            boolean regexMatchResult = Pattern.compile(textExpression).matcher(((RbelElement)element).getRawStringContent()).find();
            return textMatchResult || regexMatchResult;
        }
        catch (Exception e) {
            if (TigerJexlExecutor.isActivateJexlDebugging()) {
                log.info("Error during Text search.", (Throwable)e);
            }
            return false;
        }
    }

    private static List<String> evaluateRbelPathExpressions(String jexlExpression, TigerJexlContext mapContext) {
        if (mapContext.getRootElement() == null) {
            return List.of(jexlExpression);
        }
        List<String> resultingPaths = List.of(jexlExpression);
        for (String potentialPath : RbelJexlExecutor.extractPotentialRbelPaths(jexlExpression)) {
            if (!potentialPath.startsWith("$.") && !potentialPath.startsWith("@.")) continue;
            ArrayList<String> previousIterationPaths = new ArrayList<String>(resultingPaths);
            ArrayList<String> newPaths = new ArrayList<String>();
            for (String expression : previousIterationPaths) {
                RbelJexlExecutor.evaluatePathsAndCollectAllResults(mapContext, potentialPath, expression, newPaths);
            }
            if (newPaths.isEmpty()) continue;
            resultingPaths = newPaths;
        }
        return resultingPaths;
    }

    private static void evaluatePathsAndCollectAllResults(TigerJexlContext mapContext, String potentialPath, String expression, List<String> newPaths) {
        ArrayList<String> pathResults = new ArrayList<String>(RbelJexlExecutor.extractPathAndConvertToString(potentialPath.startsWith("@.") ? mapContext.getCurrentElement() : mapContext.getRootElement(), potentialPath.startsWith("@.") ? potentialPath.replaceFirst("@\\.", "\\$.") : potentialPath));
        if (pathResults.isEmpty() || pathResults.stream().anyMatch(s -> !CharMatcher.ascii().matchesAllOf((CharSequence)s))) {
            if (mapContext.shouldIgnoreEmptyRbelPaths()) {
                pathResults.add(null);
            } else {
                pathResults.add(null);
            }
        }
        for (String pathResult : pathResults) {
            String id = "replacedPath_" + RandomStringUtils.randomAlphabetic((int)20).toLowerCase();
            mapContext.put(id, (Object)pathResult);
            newPaths.add(expression.replace(potentialPath, id));
        }
    }

    public static List<String> extractPotentialRbelPaths(String jexlExpression) {
        int pos;
        ArrayList<String> rbelPaths = new ArrayList<String>();
        boolean insideRbelPath = false;
        boolean insideNestedJexlExpression = false;
        boolean insideVerbatimBracket = false;
        int jexlExpressionStart = -1;
        IntPredicate openingJexlBracketIsNext = p -> jexlExpression.startsWith("[?(", p);
        IntPredicate closingJexlBracketIsNext = p -> jexlExpression.startsWith(")]", p);
        IntPredicate openingVerbatimBracketIsNext = p -> jexlExpression.startsWith("['", p) || jexlExpression.startsWith("[~'", p);
        IntPredicate closingVerbatimBracketIsNext = p -> jexlExpression.startsWith("']", p);
        IntPredicate nextCharIsNotStillRbelPath = p -> !jexlExpression.substring(p).matches(RBEL_PATH_CHARS);
        IntPredicate startingRbelPathIsNext = p -> jexlExpression.startsWith("$.", p) || jexlExpression.startsWith("@.", p);
        for (pos = 0; pos < jexlExpression.length(); ++pos) {
            if (insideNestedJexlExpression) {
                if (!closingJexlBracketIsNext.test(pos)) continue;
                insideNestedJexlExpression = false;
                ++pos;
                continue;
            }
            if (insideVerbatimBracket) {
                if (!closingVerbatimBracketIsNext.test(pos)) continue;
                insideVerbatimBracket = false;
                ++pos;
                continue;
            }
            if (insideRbelPath) {
                if (openingJexlBracketIsNext.test(pos)) {
                    insideNestedJexlExpression = true;
                    pos += 2;
                    continue;
                }
                if (openingVerbatimBracketIsNext.test(pos)) {
                    insideVerbatimBracket = true;
                    continue;
                }
                if (!nextCharIsNotStillRbelPath.test(pos)) continue;
                rbelPaths.add(jexlExpression.substring(jexlExpressionStart, pos));
                insideRbelPath = false;
                continue;
            }
            if (!startingRbelPathIsNext.test(pos)) continue;
            insideRbelPath = true;
            jexlExpressionStart = pos++;
        }
        if (insideRbelPath) {
            rbelPaths.add(jexlExpression.substring(jexlExpressionStart, pos));
        }
        return rbelPaths;
    }

    private static List<String> extractPathAndConvertToString(Object source, String rbelPath) {
        return Optional.ofNullable(source).filter(RbelPathAble.class::isInstance).map(RbelPathAble.class::cast).map(s -> s.findRbelPathMembers(rbelPath)).orElse(List.of()).stream().map(RbelContextDecorator::forceStringConvert).toList();
    }

    @Generated
    private RbelJexlExecutor() {
    }
}

