/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.renderer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelBinaryFacet;
import de.gematik.rbellogger.data.facet.RbelListFacet;
import de.gematik.rbellogger.data.facet.RbelMessageTimingFacet;
import de.gematik.rbellogger.data.facet.RbelNoteFacet;
import de.gematik.rbellogger.data.facet.RbelRequestFacet;
import de.gematik.rbellogger.data.facet.RbelResponseFacet;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.exceptions.RbelRenderingException;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelMessageRenderer;
import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import de.gematik.test.tiger.common.config.TigerTypedConfigurationKey;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.EmptyTag;
import j2html.tags.Tag;
import j2html.tags.UnescapedText;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.ArticleTag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.H2Tag;
import j2html.tags.specialized.HtmlTag;
import j2html.tags.specialized.ImgTag;
import j2html.tags.specialized.LinkTag;
import j2html.tags.specialized.MetaTag;
import j2html.tags.specialized.PreTag;
import j2html.tags.specialized.ScriptTag;
import j2html.tags.specialized.SectionTag;
import j2html.tags.specialized.SpanTag;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.StringEscapeUtils;
import org.bouncycastle.util.encoders.Hex;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelHtmlRenderingToolkit {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelHtmlRenderingToolkit.class);
    public static final String CLS_HEADER = "is-primary";
    public static final String CLS_BODY = "is-info";
    public static final String CLS_PKIOK = "is-success";
    public static final String CLS_PKINOK = "is-primary";
    private static final String HEX_STYLE = "display: inline-flex;padding-bottom: 0.2rem;padding-top: 0.2rem;white-space: revert;";
    public static final String JSON_NOTE = "json-note";
    private final ObjectMapper objectMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    private final Map<UUID, JsonNoteEntry> noteTags = new HashMap<UUID, JsonNoteEntry>();
    private final RbelHtmlRenderer rbelHtmlRenderer;
    private static final TigerTypedConfigurationKey<String> logoFilePath = new TigerTypedConfigurationKey(new TigerConfigurationKey(new String[]{"tiger", "lib", "rbelLogoFilePath"}), String.class);

    public static ContainerTag icon(String iconName) {
        return ((SpanTag)TagCreator.span().withClass("icon")).with((DomContent)TagCreator.i().withClass("fas " + iconName));
    }

    public static String prettyPrintXml(String content) {
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            Document document = DocumentHelper.parseText((String)content);
            StringWriter sw = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)sw, format);
            writer.write(document);
            return sw.getBuffer().toString();
        }
        catch (Exception e) {
            try {
                return Jsoup.parse((String)content).html();
            }
            catch (Exception e2) {
                log.debug("Exception while pretty-printing {}", (Object)content);
                return content;
            }
        }
    }

    public static List<DivTag> addNotes(RbelElement el, String ... extraClasses) {
        String className = StringUtils.join((Object[])extraClasses, (String)" ");
        return el.getNotes().stream().map(note -> RbelHtmlRenderingToolkit.createNote(className, note)).toList();
    }

    public static DivTag createNote(String className, RbelNoteFacet note) {
        return (DivTag)((DivTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.i().with((DomContent)new UnescapedText(note.getValue().replace("\n", "<br/>")))}).withClass("is-family-primary has-text-weight-light m-3 " + className + " " + note.getStyle().toCssClass())).withStyle("word-break: normal;");
    }

    public static EmptyTag link2CSS(String url) {
        return (EmptyTag)((LinkTag)TagCreator.link().attr("rel", (Object)"stylesheet")).withHref(url);
    }

    public static ContainerTag ancestorTitle() {
        return (ContainerTag)TagCreator.div().withClass("tile is-ancestor pe-3");
    }

    public static ContainerTag vertParentTitle() {
        return (ContainerTag)TagCreator.div().withClass("tile is-vertical is-parent pe-3");
    }

    public static ContainerTag childBoxNotifTitle(String addClasses) {
        return (ContainerTag)TagCreator.div().withClass("tile is-child box notification pe-3 " + addClasses);
    }

    public static ContainerTag t1ms(String text) {
        return (ContainerTag)TagCreator.h1((String)text).withClass("font-monospace title");
    }

    public static ContainerTag t2(String text) {
        return (ContainerTag)TagCreator.h2((String)text).withClass("title");
    }

    public DomContent constructMessageId(RbelElement message) {
        if (message.getParentNode() != null) {
            return TagCreator.span();
        }
        return TagCreator.span((String)this.getElementSequenceNumber(message)).withClass("msg-sequence tag is-info is-light me-3 is-size-4 test-message-number");
    }

    public ContainerTag convert(RbelElement element) {
        return this.convert(element, Optional.empty());
    }

    private static ContainerTag addNotes(RbelElement element, ContainerTag elementTag) {
        elementTag.with(element.getFacets().stream().filter(RbelNoteFacet.class::isInstance).map(RbelNoteFacet.class::cast).map(RbelNoteFacet::renderToHtml).toList());
        return elementTag;
    }

    public ContainerTag convert(RbelElement element, Optional<String> key) {
        if (element.getRawContent() != null && !this.shouldRenderEntitiesWithSize(element.getRawContent().length)) {
            return RbelHtmlRenderingToolkit.addNotes(element, (ContainerTag)TagCreator.span((String)RbelHtmlRenderer.buildOversizeReplacementString(element)).withClass("is-size-7"));
        }
        return this.convertUnforced(element, key).orElseGet(() -> {
            if (element.hasFacet(RbelBinaryFacet.class)) {
                return RbelHtmlRenderingToolkit.addNotes(element, this.printAsBinary(element));
            }
            return RbelHtmlRenderingToolkit.addNotes(element, (ContainerTag)TagCreator.span((String)this.performElementToTextConversion(element)).withClass("is-size-7"));
        });
    }

    private String performElementToTextConversion(RbelElement el) {
        return this.rbelHtmlRenderer.getRbelValueShader().shadeValue(el, el.findKeyInParentElement()).or(() -> Optional.ofNullable(el).map(RbelElement::getRawStringContent).map(str -> str.replace("\n", "<br/>"))).orElse("");
    }

    public Optional<ContainerTag> convertUnforced(RbelElement element, Optional<String> key) {
        return this.rbelHtmlRenderer.convert(element, key, this);
    }

    public Optional<String> shadeValue(RbelElement element, Optional<String> key) {
        return this.rbelHtmlRenderer.getRbelValueShader().shadeValue(element, key);
    }

    public ContainerTag printAsBinary(RbelElement el) {
        return TagCreator.div((DomContent[])new DomContent[]{((PreTag)TagCreator.pre().withStyle(HEX_STYLE)).withText("Offset     |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f | ASCII Text      ")}).with(IntStream.range(0, (el.getRawContent().length + 15) / 16).limit(30L).mapToObj(line -> TagCreator.div((DomContent[])new DomContent[]{((PreTag)TagCreator.pre().withStyle(HEX_STYLE)).withText(StringUtils.leftPad((String)Integer.toHexString(line * 16), (int)8, (char)'0') + "   | " + this.getLineAsHexString(el.getRawContent(), line) + " | " + this.getLineAsAsciiString(el.getRawContent(), line))})).toList());
    }

    private String getLineAsHexString(byte[] rawContent, int start) {
        return StringUtils.rightPad((String)IntStream.range(start * 16, Math.min((start + 1) * 16, rawContent.length)).mapToObj(index -> Hex.toHexString((byte[])rawContent, (int)index, (int)1)).collect(Collectors.joining(" ")), (int)47, (char)' ');
    }

    private String getLineAsAsciiString(byte[] rawContent, int start) {
        return StringUtils.rightPad((String)IntStream.range(start * 16, Math.min((start + 1) * 16, rawContent.length)).mapToObj(index -> rawContent[index]).filter(Objects::nonNull).map(bit -> new String(new byte[]{bit}, StandardCharsets.US_ASCII).replaceAll("[^ -~]", ".")).collect(Collectors.joining("")), (int)16, (char)' ');
    }

    public DomContent renderMenu() {
        return ((DivTag)TagCreator.div().withClass(" col is-one-fifth menu is-size-4 sidebar")).with(new DomContent[]{((ATag)((ATag)TagCreator.a((DomContent[])new DomContent[]{TagCreator.i().withClass("fas fa-angle-double-up")}).withId("collapse-all")).withHref("#")).withClass("float-end me-3"), ((ATag)((ATag)TagCreator.a((DomContent[])new DomContent[]{TagCreator.i().withClass("fas fa-angle-double-down")}).withId("expand-all")).withHref("#")).withClass("float-end me-3"), TagCreator.h2((String)"Flow").withClass("mb-3 ms-2"), ((DivTag)TagCreator.div().withClass("ms-1")).withId("sidebar-menu")});
    }

    public String menuTab(RbelElement rbelElement) {
        String uuid = rbelElement.getUuid();
        JSONObject metaData = new JSONObject();
        metaData.put("uuid", (Object)uuid);
        metaData.put("sequenceNumber", Integer.parseInt(this.getElementSequenceNumber(rbelElement)) - 1);
        if (rbelElement.hasFacet(RbelRequestFacet.class)) {
            metaData.put("menuInfoString", (Object)rbelElement.getFacetOrFail(RbelRequestFacet.class).getMenuInfoString());
        } else {
            metaData.put("menuInfoString", (Object)rbelElement.getFacet(RbelResponseFacet.class).map(RbelResponseFacet::getMenuInfoString).orElse(""));
        }
        metaData.put("timestamp", rbelElement.getFacet(RbelMessageTimingFacet.class).map(RbelMessageTimingFacet::getTransmissionTime).orElse(null));
        metaData.put("isRequest", rbelElement.hasFacet(RbelRequestFacet.class));
        return "createMenuEntry(" + metaData.toString() + ")";
    }

    private String getElementSequenceNumber(RbelElement rbelElement) {
        return rbelElement.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getSequenceNumber).map(zeroBased -> zeroBased + 1L).map(Object::toString).orElse("0");
    }

    public String renderDocument(List<RbelElement> elements, boolean localRessources) throws IOException {
        return TagCreator.document((HtmlTag)((HtmlTag)TagCreator.html((DomContent[])new DomContent[]{TagCreator.head((DomContent[])new DomContent[]{TagCreator.meta().attr("charset", (Object)"utf-8"), ((MetaTag)TagCreator.meta().attr("name", (Object)"viewport")).attr("content", (Object)"width=device-width, initial-scale=1"), TagCreator.title().withText(this.rbelHtmlRenderer.getTitle()), TagCreator.script().withSrc(localRessources ? "../webjars/sockjs-client/sockjs.min.js" : "https://cdn.jsdelivr.net/npm/sockjs-client@1/dist/sockjs.min.js"), TagCreator.script().withSrc(localRessources ? "../webjars/stomp-websocket/stomp.min.js" : "https://cdn.jsdelivr.net/npm/stompjs@2.3.3/lib/stomp.min.js"), TagCreator.script().withSrc(localRessources ? "../webjars/jquery/jquery.min.js" : "https://code.jquery.com/jquery-1.12.4.js"), TagCreator.script().withSrc(localRessources ? "../webjars/bootstrap/js/bootstrap.bundle.min.js" : "https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"), TagCreator.script().withSrc(localRessources ? "../webjars/highlightjs/highlight.min.js" : "https://cdn.jsdelivr.net/gh/highlightjs/cdn-release@11.7.0/build/highlight.min.js"), TagCreator.script().withSrc(localRessources ? "../webjars/highlightjs/languages/xml.min.js" : "https://cdn.jsdelivr.net/gh/highlightjs/cdn-release@11.7.0/build/languages/xml.min.js"), TagCreator.script().withSrc(localRessources ? "../webjars/dayjs/dayjs.min.js" : "https://cdnjs.cloudflare.com/ajax/libs/dayjs/1.11.10/dayjs.min.js"), RbelHtmlRenderingToolkit.link2CSS(localRessources ? "../webjars/bootstrap/css/bootstrap.min.css" : "https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css"), RbelHtmlRenderingToolkit.link2CSS(localRessources ? "../webjars/highlightjs/styles/stackoverflow-dark.min.css" : "https://cdn.jsdelivr.net/gh/highlightjs/cdn-release@11.7.0/build/styles/stackoverflow-dark.min.css"), RbelHtmlRenderingToolkit.link2CSS(localRessources ? "../webjars/font-awesome/css/all.min.css" : "https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"), ((LinkTag)((LinkTag)TagCreator.link().withRel("icon")).withType("image/png")).withHref(this.getLogoBase64Str()), TagCreator.tag((String)"style").with((DomContent)new UnescapedText(IOUtils.resourceToString((String)"/rbel.css", (Charset)StandardCharsets.UTF_8)))}), TagCreator.body().with(new DomContent[]{TagCreator.div().withId("navbardiv"), ((SectionTag)TagCreator.section().withClass("main-content")).with((DomContent)((SectionTag)TagCreator.section().withClass("row header")).with(new DomContent[]{((DivTag)TagCreator.div().withClass("col-1 h-100 my-auto logo")).with((DomContent)((ImgTag)TagCreator.img().withSrc(this.getLogoBase64Str())).withId("test-tiger-logo")), ((DivTag)TagCreator.div().withClass("col is-size-6")).with(new DomContent[]{((DivTag)TagCreator.div().withClass("row my-auto")).with(new DomContent[]{TagCreator.div((String)this.rbelHtmlRenderer.getTitle()).withClass("col navbar-title is-size-3 h-100 my-auto"), TagCreator.span((String)this.rbelHtmlRenderer.getVersionInfo()).withClass("col-2 is-size-7 navbar-version")}), TagCreator.div((DomContent[])new DomContent[]{new UnescapedText(this.rbelHtmlRenderer.getSubTitle())})})})), ((SectionTag)((SectionTag)TagCreator.section().withClass("row is-fullheight")).withId("test-rbel-section")).with(new DomContent[]{this.renderMenu(), ((DivTag)TagCreator.div().withClass("col ms-6")).with(new DomContent[]{TagCreator.div((String)("Created " + DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now()))).withClass("created fst-italic is-size-6 float-end me-6"), TagCreator.div().with(elements.stream().map(this::convertMessage).toList()), TagCreator.div((String)("Created " + DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now()))).withClass("created fst-italic is-size-6 float-end me-6")})})})}).with(new DomContent[]{((ScriptTag)TagCreator.script().with((DomContent)new UnescapedText(IOUtils.resourceToString((String)"/rbel.js", (Charset)StandardCharsets.UTF_8)))).attr("id", (Object)"mainWebUiScript"), TagCreator.script((String)elements.stream().map(this::menuTab).collect(Collectors.joining("\n")))})));
    }

    private String getLogoBase64Str() {
        return logoFilePath.getValue().filter(StringUtils::isNotEmpty).map(filePath -> {
            try {
                byte[] bytes = FileUtils.readFileToByteArray((File)new File((String)filePath));
                return "data:image/png;base64," + Base64.getEncoder().encodeToString(bytes);
            }
            catch (IOException e) {
                throw new RbelRenderingException("Could not load file", e);
            }
        }).orElseGet(() -> {
            try {
                return IOUtils.resourceToString((String)"/tiger-monochrome-64.png.base64", (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RbelRenderingException("Could not load file", e);
            }
        });
    }

    public DomContent convertMessage(RbelElement element) {
        return TagCreator.div((DomContent[])new DomContent[]{new RbelMessageRenderer().performRendering(element, Optional.empty(), this)});
    }

    public JsonNode shadeJson(JsonNode input, Optional<String> key, RbelElement originalElement) {
        if (input.isValueNode()) {
            return this.shadeJsonPrimitive(input, key, originalElement);
        }
        if (input.isObject()) {
            return this.shadeJsonObject(input, originalElement);
        }
        if (input.isArray()) {
            return this.shadeJsonArray(input, key, originalElement);
        }
        if (input.isNull()) {
            return input;
        }
        throw new RbelRenderingException("Unshadeable JSON-Type " + input.getClass().getSimpleName());
    }

    private JsonNode shadeJsonArray(JsonNode input, Optional<String> key, RbelElement originalElement) {
        ArrayNode output = this.objectMapper.createArrayNode();
        if (originalElement.hasFacet(RbelNoteFacet.class)) {
            UUID uuid = UUID.randomUUID();
            this.noteTags.put(uuid, JsonNoteEntry.builder().stringToMatch("\"" + uuid + "\"").tagForKeyReplacement((Tag)TagCreator.span()).tagForValueReplacement(((SpanTag)TagCreator.span().with(originalElement.getNotes().stream().map(note -> (DivTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.i((String)note.getValue())}).withClass(note.getStyle().toCssClass())).toList())).withClass(JSON_NOTE)).build());
            output.add(uuid.toString());
        }
        for (int i = 0; i < input.size(); ++i) {
            int finalI = i;
            List<RbelElement> rbelListElements = originalElement.getFacetOrFail(RbelListFacet.class).getChildNodes();
            output.add(this.shadeJson(input.get(i), key.map(v -> v + "." + finalI), rbelListElements.get(i)));
        }
        return output;
    }

    private JsonNode shadeJsonObject(JsonNode input, RbelElement originalElement) {
        ObjectNode output = this.objectMapper.createObjectNode();
        if (originalElement.hasFacet(RbelNoteFacet.class)) {
            UUID uuid = UUID.randomUUID();
            this.noteTags.put(uuid, JsonNoteEntry.builder().stringToMatch("\"note\" : \"" + uuid + "\"" + (input.isEmpty() ? "" : ",")).tagForKeyReplacement((Tag)TagCreator.span()).tagForValueReplacement(((SpanTag)TagCreator.span().with(originalElement.getNotes().stream().map(note -> (DivTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.i((String)note.getValue())}).withClass(note.getStyle().toCssClass())).toList())).withClass(JSON_NOTE)).build());
            output.put("note", uuid.toString());
        }
        Iterator it = input.fields();
        while (it.hasNext()) {
            Map.Entry element = (Map.Entry)it.next();
            output.set((String)element.getKey(), this.shadeJson((JsonNode)element.getValue(), Optional.of((String)element.getKey()), originalElement.getFirst((String)element.getKey()).orElseThrow(() -> new RuntimeException("Unable to find matching Element for key " + (String)element.getKey()))));
        }
        return output;
    }

    private JsonNode shadeJsonPrimitive(JsonNode input, Optional<String> key, RbelElement originalElement) {
        JsonNode jsonElement = this.rbelHtmlRenderer.getRbelValueShader().shadeValue(input, key).map(shadedValue -> new TextNode(StringEscapeUtils.escapeHtml4((String)shadedValue))).orElse(input);
        if (!originalElement.getNotes().isEmpty()) {
            UUID uuid = UUID.randomUUID();
            this.noteTags.put(uuid, JsonNoteEntry.builder().stringToMatch("\"" + uuid + "\"").tagForKeyReplacement((Tag)TagCreator.span((String)jsonElement.toString())).tagForValueReplacement(((SpanTag)TagCreator.span().with(originalElement.getNotes().stream().map(note -> (DivTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.i((DomContent[])new DomContent[]{TagCreator.text((String)note.getValue())})}).withClass(note.getStyle().toCssClass())).toList())).withClass(JSON_NOTE)).build());
            return new TextNode(uuid.toString());
        }
        return jsonElement;
    }

    public List<? extends ContainerTag> convertNested(RbelElement el) {
        return el.traverseAndReturnNestedMembers().stream().filter(entry -> !entry.getFacets().isEmpty()).map(child -> Pair.of((Object)child, this.rbelHtmlRenderer.isRenderNestedObjectsWithoutFacetRenderer() ? Optional.of(this.convert((RbelElement)child, Optional.empty())) : this.convertUnforced((RbelElement)child, Optional.empty()))).filter(pair -> ((Optional)pair.getValue()).isPresent()).map(pair -> (ArticleTag)((ArticleTag)TagCreator.article().withClass("message is-ancestor notification is-warning my-6 py-3 px-3")).with(new DomContent[]{((DivTag)((DivTag)TagCreator.div((DomContent[])new DomContent[]{((H2Tag)TagCreator.h2((String)((RbelElement)pair.getKey()).findNodePath()).withClass("title")).withStyle("word-break: keep-all;")}).withClass("message-header")).with(RbelHtmlRenderingToolkit.addNotes((RbelElement)pair.getKey(), new String[0]))).with(RbelHtmlRenderer.showContentButtonAndDialog((RbelElement)pair.getKey(), this)), TagCreator.div((DomContent[])new DomContent[]{TagCreator.div((DomContent[])new DomContent[]{((ContainerTag)((Optional)pair.getValue()).get()).withClass("notification tile is-child box pe-3")}).withClass("notification tile is-parent pe-3")}).withClass("message-body px-0")})).toList();
    }

    public List<DomContent> packAsInfoLine(String parameterName, DomContent ... contentObject) {
        return List.of(((DivTag)TagCreator.div().withClass("row is-multiline is-mobile")).with(new DomContent[]{((DivTag)TagCreator.div().withClass("col-sm-4")).with((DomContent)TagCreator.b().withText(parameterName + ": ")), ((DivTag)TagCreator.div().withClass("col")).with(contentObject)}));
    }

    public DomContent formatHex(RbelElement value) {
        return ((SpanTag)TagCreator.span().withText(Hex.toHexString((byte[])value.getRawContent()))).withStyle("font-family: monospace; padding-right: 0.3rem;");
    }

    public DomContent formatHexAlike(String value) {
        return ((SpanTag)TagCreator.span().withText(value)).withStyle("font-family: monospace; padding-right: 0.3rem;");
    }

    public boolean shouldRenderEntitiesWithSize(int length) {
        return this.rbelHtmlRenderer.getMaximumEntitySizeInBytes() > length;
    }

    @ConstructorProperties(value={"rbelHtmlRenderer"})
    @Generated
    public RbelHtmlRenderingToolkit(RbelHtmlRenderer rbelHtmlRenderer) {
        this.rbelHtmlRenderer = rbelHtmlRenderer;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public Map<UUID, JsonNoteEntry> getNoteTags() {
        return this.noteTags;
    }

    public static class JsonNoteEntry {
        private final String stringToMatch;
        private final Tag tagForKeyReplacement;
        private final Tag tagForValueReplacement;

        @Generated
        public static JsonNoteEntryBuilder builder() {
            return new JsonNoteEntryBuilder();
        }

        @ConstructorProperties(value={"stringToMatch", "tagForKeyReplacement", "tagForValueReplacement"})
        @Generated
        public JsonNoteEntry(String stringToMatch, Tag tagForKeyReplacement, Tag tagForValueReplacement) {
            this.stringToMatch = stringToMatch;
            this.tagForKeyReplacement = tagForKeyReplacement;
            this.tagForValueReplacement = tagForValueReplacement;
        }

        @Generated
        public String getStringToMatch() {
            return this.stringToMatch;
        }

        @Generated
        public Tag getTagForKeyReplacement() {
            return this.tagForKeyReplacement;
        }

        @Generated
        public Tag getTagForValueReplacement() {
            return this.tagForValueReplacement;
        }

        @Generated
        public static class JsonNoteEntryBuilder {
            @Generated
            private String stringToMatch;
            @Generated
            private Tag tagForKeyReplacement;
            @Generated
            private Tag tagForValueReplacement;

            @Generated
            JsonNoteEntryBuilder() {
            }

            @Generated
            public JsonNoteEntryBuilder stringToMatch(String stringToMatch) {
                this.stringToMatch = stringToMatch;
                return this;
            }

            @Generated
            public JsonNoteEntryBuilder tagForKeyReplacement(Tag tagForKeyReplacement) {
                this.tagForKeyReplacement = tagForKeyReplacement;
                return this;
            }

            @Generated
            public JsonNoteEntryBuilder tagForValueReplacement(Tag tagForValueReplacement) {
                this.tagForValueReplacement = tagForValueReplacement;
                return this;
            }

            @Generated
            public JsonNoteEntry build() {
                return new JsonNoteEntry(this.stringToMatch, this.tagForKeyReplacement, this.tagForValueReplacement);
            }

            @Generated
            public String toString() {
                return "RbelHtmlRenderingToolkit.JsonNoteEntry.JsonNoteEntryBuilder(stringToMatch=" + this.stringToMatch + ", tagForKeyReplacement=" + this.tagForKeyReplacement + ", tagForValueReplacement=" + this.tagForValueReplacement + ")";
            }
        }
    }
}

