/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.renderer;

import de.gematik.rbellogger.converter.RbelValueShader;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelAsn1Facet;
import de.gematik.rbellogger.renderer.RbelHtmlFacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import de.gematik.rbellogger.util.BinaryClassifier;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.ArticleTag;
import j2html.tags.specialized.ButtonTag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.HeaderTag;
import j2html.tags.specialized.PTag;
import j2html.tags.specialized.PreTag;
import j2html.tags.specialized.SpanTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelHtmlRenderer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelHtmlRenderer.class);
    private static final List<RbelHtmlFacetRenderer> htmlRenderer = new ArrayList<RbelHtmlFacetRenderer>();
    public static final String OVERSIZE_REPLACEMENT_TEXT_PRE = "<...redacted due to size of ";
    public static final String OVERSIZE_REPLACEMENT_TEXT_POST = " Mb...>";
    public static final String MODAL = "modal";
    private final RbelValueShader rbelValueShader;
    private boolean renderAsn1Objects = false;
    private boolean renderNestedObjectsWithoutFacetRenderer = false;
    private int maximumEntitySizeInBytes = 0x400000;
    private String title = "Tiger Proxy Log";
    private String subTitle = "";
    private String versionInfo = "";

    public RbelHtmlRenderer(RbelValueShader rbelValueShader) {
        this.rbelValueShader = rbelValueShader;
    }

    public RbelHtmlRenderer() {
        this.rbelValueShader = new RbelValueShader();
    }

    public static String render(Collection<RbelElement> elements) {
        return RbelHtmlRenderer.render(elements, new RbelValueShader());
    }

    public static String render(Collection<RbelElement> elements, RbelValueShader valueShader) {
        return new RbelHtmlRenderer(valueShader).performRendering(elements, false);
    }

    public static ContainerTag collapsibleCard(ContainerTag title, ContainerTag body, String classes, String spaces, String contentClasses) {
        return ((DivTag)TagCreator.div().withClass("container page-break " + spaces)).with((DomContent)((DivTag)TagCreator.div().withClass("card full-width test-card " + classes)).with(new DomContent[]{((HeaderTag)TagCreator.header().withClass("card-header test-card-header")).with((DomContent)((DivTag)TagCreator.div().withClass("card-header-title test-card-header-title card-toggle")).with((DomContent)title)), ((DivTag)TagCreator.div().withClass("card-content test-card-content " + contentClasses)).with((DomContent)TagCreator.div().with((DomContent)body))}));
    }

    public static DomContent showContentButtonAndDialog(RbelElement el, RbelHtmlRenderingToolkit renderingToolkit) {
        String id = "dialog" + RandomStringUtils.randomAlphanumeric((int)20);
        return TagCreator.span().with(new DomContent[]{((ATag)((ATag)((ATag)TagCreator.a().withClass("btn modal-button modal-button-details float-end mx-2 test-modal-content")).attr("data-bs-target", (Object)("#" + id))).attr("data-bs-toggle", (Object)MODAL)).with((DomContent)((SpanTag)TagCreator.span().withClass("icon is-small")).with((DomContent)TagCreator.i().withClass("fas fa-align-left"))), ((DivTag)((DivTag)((DivTag)TagCreator.div().withClass(MODAL)).withId(id)).attr("role", (Object)"dialog")).with((DomContent)((DivTag)TagCreator.div().withClass("modal-dialog")).with(new DomContent[]{TagCreator.div().withClass("modal-background"), ((DivTag)((DivTag)((DivTag)TagCreator.div().withClass("modal-content")).attr("role", (Object)"document")).attr("style", (Object)"width: 900px;")).with(new DomContent[]{((DivTag)TagCreator.div().withClass("modal-header bg-dark")).with(new DomContent[]{((DivTag)TagCreator.div().withStyle("display: inline-flex;")).with(new DomContent[]{((PTag)TagCreator.p((String)("Raw content of " + el.findNodePath())).withStyle("align-self: center;color:#ffff;")).withClass("modal-title"), ((ButtonTag)((ButtonTag)TagCreator.button().withClass("btn btn-sm copyToClipboard-button")).attr("data-target", (Object)("text-" + id))).with((DomContent)TagCreator.i().withClass("fa fa-clipboard"))}), ((ButtonTag)((ButtonTag)TagCreator.button().withClass("btn btn-close btn-close-white")).attr("data-bs-dismiss", (Object)MODAL)).attr("aria-label", (Object)"Close")}), ((ArticleTag)TagCreator.article().withClass("message")).with((DomContent)((DivTag)TagCreator.div().withClass("message-body")).with((DomContent)((PreTag)TagCreator.pre((String)RbelHtmlRenderer.printRawContentOfElement(el, renderingToolkit)).withId("text-" + id)).withStyle("white-space: pre-wrap;word-wrap: break-word;")))})}))});
    }

    @Nullable
    private static String printRawContentOfElement(RbelElement el, RbelHtmlRenderingToolkit renderingToolkit) {
        if (renderingToolkit.shouldRenderEntitiesWithSize(el.getRawContent().length)) {
            if (BinaryClassifier.isBinary(el.getRawContent())) {
                return Hex.toHexString((byte[])el.getRawContent());
            }
            return el.getRawStringContent();
        }
        return RbelHtmlRenderer.buildOversizeReplacementString(el);
    }

    public static String buildOversizeReplacementString(RbelElement el) {
        return OVERSIZE_REPLACEMENT_TEXT_PRE + (double)el.getRawContent().length / 10000.0 / 100.0 + OVERSIZE_REPLACEMENT_TEXT_POST;
    }

    public static void registerFacetRenderer(RbelHtmlFacetRenderer rbelFacetRenderer) {
        htmlRenderer.add(rbelFacetRenderer);
    }

    public String doRender(Collection<RbelElement> elements) {
        return this.performRendering(elements, false);
    }

    private String performRendering(Collection<RbelElement> elements, boolean localRessources) {
        RbelHtmlRenderingToolkit renderingToolkit = new RbelHtmlRenderingToolkit(this);
        return renderingToolkit.renderDocument(new ArrayList<RbelElement>(elements), localRessources);
    }

    public Optional<ContainerTag> convert(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
        if (element.getFacets().isEmpty() && ArrayUtils.isEmpty((byte[])element.getRawContent())) {
            return Optional.empty();
        }
        List<ContainerTag> renderedFacets = htmlRenderer.stream().filter(renderer -> this.renderAsn1Objects || !renderer.getClass().getName().startsWith(RbelAsn1Facet.class.getName())).filter(renderer -> renderer.checkForRendering(element)).sorted(Comparator.comparing(RbelHtmlFacetRenderer::order)).map(renderer -> renderer.performRendering(element, key, renderingToolkit)).toList();
        if (renderedFacets.isEmpty()) {
            return Optional.empty();
        }
        if (renderedFacets.size() == 1) {
            return Optional.of(renderedFacets.get(0));
        }
        return Optional.of(TagCreator.div().with(renderedFacets));
    }

    public String getEmptyPage(boolean localRessources) {
        return this.performRendering(List.of(), localRessources);
    }

    @Generated
    public RbelValueShader getRbelValueShader() {
        return this.rbelValueShader;
    }

    @Generated
    public boolean isRenderAsn1Objects() {
        return this.renderAsn1Objects;
    }

    @Generated
    public boolean isRenderNestedObjectsWithoutFacetRenderer() {
        return this.renderNestedObjectsWithoutFacetRenderer;
    }

    @Generated
    public int getMaximumEntitySizeInBytes() {
        return this.maximumEntitySizeInBytes;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getSubTitle() {
        return this.subTitle;
    }

    @Generated
    public String getVersionInfo() {
        return this.versionInfo;
    }

    @Generated
    public void setRenderAsn1Objects(boolean renderAsn1Objects) {
        this.renderAsn1Objects = renderAsn1Objects;
    }

    @Generated
    public void setRenderNestedObjectsWithoutFacetRenderer(boolean renderNestedObjectsWithoutFacetRenderer) {
        this.renderNestedObjectsWithoutFacetRenderer = renderNestedObjectsWithoutFacetRenderer;
    }

    @Generated
    public void setMaximumEntitySizeInBytes(int maximumEntitySizeInBytes) {
        this.maximumEntitySizeInBytes = maximumEntitySizeInBytes;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    @Generated
    public void setVersionInfo(String versionInfo) {
        this.versionInfo = versionInfo;
    }
}

