/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.modifier;

import de.gematik.rbellogger.converter.brainpool.BrainpoolCurves;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelVauErpFacet;
import de.gematik.rbellogger.exceptions.RbelPkiException;
import de.gematik.rbellogger.key.RbelKey;
import de.gematik.rbellogger.modifier.RbelElementWriter;
import de.gematik.rbellogger.util.CryptoUtils;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelVauErpWriter
implements RbelElementWriter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelVauErpWriter.class);

    public static byte[] encrypt(byte[] input, byte[] key) {
        byte[] iv = new byte[12];
        ThreadLocalRandom.current().nextBytes(iv);
        SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
        cipher.init(1, (Key)secretKey, new GCMParameterSpec(128, iv));
        byte[] cipherTextPlusTag = cipher.doFinal(input);
        byte[] encMessage = Arrays.copyOf(iv, 12 + cipherTextPlusTag.length);
        System.arraycopy(cipherTextPlusTag, 0, encMessage, 12, cipherTextPlusTag.length);
        return encMessage;
    }

    @Override
    public boolean canWrite(RbelElement oldTargetElement) {
        return oldTargetElement.hasFacet(RbelVauErpFacet.class) && oldTargetElement.getFacet(RbelVauErpFacet.class).flatMap(RbelVauErpFacet::getKeyUsed).isPresent();
    }

    @Override
    public byte[] write(RbelElement oldTargetElement, RbelElement oldTargetModifiedChild, byte[] newContent) {
        Optional decryptionKey = oldTargetElement.getFacet(RbelVauErpFacet.class).flatMap(RbelVauErpFacet::getKeyUsed);
        if (decryptionKey.isEmpty()) {
            throw new RbelPkiException("Error while trying to write VAU Erp Message: No decryption-key found!");
        }
        if (((RbelKey)decryptionKey.get()).getKey() instanceof ECPrivateKey) {
            return this.rewriteErpVauRequest(oldTargetElement, newContent, (RbelKey)decryptionKey.get());
        }
        return this.rewriteErpVauResponse(oldTargetElement, newContent, (RbelKey)decryptionKey.get());
    }

    private byte[] rewriteErpVauResponse(RbelElement oldTargetElement, byte[] newContent, RbelKey decryptionKey) {
        String[] pParts = oldTargetElement.getFacet(RbelVauErpFacet.class).map(RbelVauErpFacet::getDecryptedPString).flatMap(RbelElement::seekValue).get().toString().split(" ");
        return RbelVauErpWriter.encrypt(ArrayUtils.addAll((byte[])(pParts[0] + " " + pParts[1] + " ").getBytes(StandardCharsets.UTF_8), (byte[])newContent), decryptionKey.getKey().getEncoded());
    }

    private byte[] rewriteErpVauRequest(RbelElement oldTargetElement, byte[] newContent, RbelKey decryptionKey) {
        String[] pParts = oldTargetElement.getFacet(RbelVauErpFacet.class).map(RbelVauErpFacet::getDecryptedPString).flatMap(RbelElement::seekValue).get().toString().split(" ");
        ECPublicKey otherSidePublicKey = this.extractPublicKeyFromVauMessage(oldTargetElement.getRawContent());
        byte[] sharedSecret = CryptoUtils.ecka((PrivateKey)decryptionKey.getKey(), otherSidePublicKey);
        byte[] aesKeyBytes = CryptoUtils.hkdf(sharedSecret, "ecies-vau-transport", 16);
        byte[] newCiphertext = RbelVauErpWriter.encrypt(ArrayUtils.addAll((byte[])(pParts[0] + " " + pParts[1] + " " + pParts[2] + " " + pParts[3] + " ").getBytes(StandardCharsets.UTF_8), (byte[])newContent), aesKeyBytes);
        if (log.isTraceEnabled()) {
            log.trace("Encrypting. AesKey '{}' and ciphertext {}", (Object)Base64.getEncoder().encodeToString(aesKeyBytes), (Object)Base64.getEncoder().encodeToString(newCiphertext));
        }
        byte[] oldCombinedMessage = oldTargetElement.getFacet(RbelVauErpFacet.class).map(RbelVauErpFacet::getEncryptedMessage).map(RbelElement::getRawContent).orElseThrow();
        return ArrayUtils.addAll((byte[])Arrays.copyOfRange(oldCombinedMessage, 0, 65), (byte[])newCiphertext);
    }

    private ECPublicKey extractPublicKeyFromVauMessage(byte[] encMessage) {
        ECPoint ecPoint = new ECPoint(new BigInteger(1, Arrays.copyOfRange(encMessage, 1, 33)), new BigInteger(1, Arrays.copyOfRange(encMessage, 33, 65)));
        ECPublicKeySpec keySpec = new ECPublicKeySpec(ecPoint, BrainpoolCurves.BP256);
        return (ECPublicKey)KeyFactory.getInstance("EC").generatePublic(keySpec);
    }

    @Generated
    public RbelVauErpWriter() {
    }
}

