/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.modifier;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelVauEpaFacet;
import de.gematik.rbellogger.exceptions.RbelPkiException;
import de.gematik.rbellogger.key.RbelKey;
import de.gematik.rbellogger.modifier.RbelElementWriter;
import de.gematik.rbellogger.modifier.RbelModifier;
import de.gematik.rbellogger.util.CryptoUtils;
import java.nio.ByteBuffer;
import java.security.Key;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelVauEpaWriter
implements RbelElementWriter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelVauEpaWriter.class);

    public static byte[] encrypt(byte[] input, byte[] key, byte[] iv) {
        SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
        cipher.init(1, (Key)secretKey, new GCMParameterSpec(128, iv));
        byte[] cipherTextPlusTag = cipher.doFinal(input);
        byte[] encMessage = Arrays.copyOf(iv, 12 + cipherTextPlusTag.length);
        System.arraycopy(cipherTextPlusTag, 0, encMessage, 12, cipherTextPlusTag.length);
        return encMessage;
    }

    @Override
    public boolean canWrite(RbelElement oldTargetElement) {
        return oldTargetElement.hasFacet(RbelVauEpaFacet.class);
    }

    @Override
    public byte[] write(RbelElement oldTargetElement, RbelElement oldTargetModifiedChild, byte[] newContent) {
        Optional decryptionKey = oldTargetElement.getFacet(RbelVauEpaFacet.class).flatMap(RbelVauEpaFacet::getKeyUsed);
        if (decryptionKey.isEmpty()) {
            throw new RbelPkiException("Error while trying to write VAU Erp Message: No decryption-key found!");
        }
        byte[] oldEncryptedMessage = oldTargetElement.getFacetOrFail(RbelVauEpaFacet.class).getEncryptedMessage().getRawContent();
        byte[] oldCleartext = CryptoUtils.decrypt(oldEncryptedMessage, oldTargetElement.getFacetOrFail(RbelVauEpaFacet.class).getKeyUsed().get().getKey()).get();
        int headerLength = ByteBuffer.wrap(Arrays.copyOfRange(oldCleartext, 9, 13)).getInt();
        int introLength = 13 + headerLength;
        byte[] oldIv = Arrays.copyOfRange(oldEncryptedMessage, 0, 12);
        byte[] newCleartext = ArrayUtils.addAll((byte[])Arrays.copyOfRange(oldCleartext, 0, introLength), (byte[])newContent);
        byte[] newVauMessage = ArrayUtils.addAll((byte[])Arrays.copyOfRange(oldTargetElement.getRawContent(), 0, 32), (byte[])RbelVauEpaWriter.encrypt(newCleartext, ((RbelKey)decryptionKey.get()).getKey().getEncoded(), oldIv));
        Pair<byte[], byte[]> splitVauMessage = this.splitVauMessage(newVauMessage);
        log.info("splitted into {} and {}", (Object)Base64.getEncoder().encodeToString((byte[])splitVauMessage.getLeft()), (Object)Base64.getEncoder().encodeToString((byte[])splitVauMessage.getRight()));
        return newVauMessage;
    }

    private Pair<byte[], byte[]> splitVauMessage(byte[] vauMessage) {
        try {
            byte[] keyID = new byte[32];
            System.arraycopy(vauMessage, 0, keyID, 0, 32);
            byte[] enc = new byte[vauMessage.length - 32];
            System.arraycopy(vauMessage, 32, enc, 0, vauMessage.length - 32);
            return Pair.of((Object)keyID, (Object)enc);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RbelModifier.RbelModificationException("Unable to write VAU message", e);
        }
    }

    @Generated
    public RbelVauEpaWriter() {
    }
}

