/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.file;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.file.BundledServerNameWriterAndReader;
import de.gematik.rbellogger.file.MessageTimeWriter;
import de.gematik.rbellogger.file.RbelFilePreSaveListener;
import de.gematik.rbellogger.file.TcpIpMessageFaceWriter;
import de.gematik.rbellogger.util.RbelMessagePostProcessor;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelFileWriter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelFileWriter.class);
    private static final String FILE_DIVIDER = "\n";
    public static final String RAW_MESSAGE_CONTENT = "rawMessageContent";
    public static final String SENDER_HOSTNAME = "senderHostname";
    public static final String RECEIVER_HOSTNAME = "receiverHostname";
    public static final String SEQUENCE_NUMBER = "sequenceNumber";
    public static final String MESSAGE_TIME = "timestamp";
    public static final String MESSAGE_UUID = "uuid";
    public static final List<RbelFilePreSaveListener> DEFAULT_PRE_SAVE_LISTENER = new ArrayList<BundledServerNameWriterAndReader>(List.of(new MessageTimeWriter(), new TcpIpMessageFaceWriter(), new BundledServerNameWriterAndReader()));
    public static final List<RbelMessagePostProcessor> DEFAULT_POST_CONVERSION_LISTENER = new ArrayList<BundledServerNameWriterAndReader>(List.of(new BundledServerNameWriterAndReader()));
    public final List<RbelMessagePostProcessor> postConversionListener = new ArrayList<RbelMessagePostProcessor>(DEFAULT_POST_CONVERSION_LISTENER);
    public final List<RbelFilePreSaveListener> preSaveListener = new ArrayList<RbelFilePreSaveListener>(DEFAULT_PRE_SAVE_LISTENER);
    private final RbelConverter rbelConverter;

    public String convertToRbelFileString(RbelElement rbelElement) {
        JSONObject jsonObject = new JSONObject(Map.of(RAW_MESSAGE_CONTENT, Base64.getEncoder().encodeToString(rbelElement.getRawContent()), MESSAGE_UUID, rbelElement.getUuid()));
        this.preSaveListener.forEach(listener -> listener.preSaveCallback(rbelElement, jsonObject));
        return jsonObject + FILE_DIVIDER;
    }

    public List<RbelElement> convertFromRbelFile(String rbelFileContent) {
        return this.readRbelFileStream(Arrays.stream(rbelFileContent.split(FILE_DIVIDER)));
    }

    private List<RbelElement> readRbelFileStream(Stream<String> rbelFileStream) {
        List<String> rawMessageStrings = rbelFileStream.filter(StringUtils::isNotEmpty).toList();
        log.info("Found {} messages in file, starting parsing...", (Object)rawMessageStrings.size());
        AtomicInteger numberOfParsedMessages = new AtomicInteger(0);
        return rawMessageStrings.stream().peek(str -> {
            if (numberOfParsedMessages.getAndIncrement() % 500 == 0) {
                log.info("Parsed {} messages, continuing...", (Object)numberOfParsedMessages);
            }
        }).map(JSONObject::new).sorted(Comparator.comparing(json -> json.optInt(SEQUENCE_NUMBER, Integer.MAX_VALUE))).map(this::parseFileObject).filter(Optional::isPresent).map(Optional::get).toList();
    }

    private Optional<RbelElement> parseFileObject(JSONObject messageObject) {
        try {
            String msgUuid = messageObject.optString(MESSAGE_UUID);
            if (this.rbelConverter.isMessageUuidAlreadyKnown(msgUuid)) {
                return Optional.empty();
            }
            RbelElement rawMessageObject = RbelElement.builder().rawContent(Base64.getDecoder().decode(messageObject.getString(RAW_MESSAGE_CONTENT))).uuid(msgUuid).parentNode(null).build();
            RbelElement parsedMessage = this.rbelConverter.parseMessage(rawMessageObject, (RbelHostname)RbelHostname.fromString(messageObject.getString(SENDER_HOSTNAME)).orElse(null), (RbelHostname)RbelHostname.fromString(messageObject.getString(RECEIVER_HOSTNAME)).orElse(null), messageObject.has(MESSAGE_TIME) ? RbelFileWriter.parseTransmissionTimeFromString(messageObject.getString(MESSAGE_TIME)) : Optional.empty());
            this.postConversionListener.forEach(listener -> listener.performMessagePostConversionProcessing(parsedMessage, this.rbelConverter, messageObject));
            return Optional.ofNullable(parsedMessage);
        }
        catch (Exception e) {
            throw new RbelFileReadingException("Error while converting from object '" + messageObject.toString() + "'", e);
        }
    }

    private static Optional<ZonedDateTime> parseTransmissionTimeFromString(String time) {
        if (StringUtils.isBlank((CharSequence)time)) {
            return Optional.empty();
        }
        return Optional.of(ZonedDateTime.parse(time));
    }

    @ConstructorProperties(value={"rbelConverter"})
    @Generated
    public RbelFileWriter(RbelConverter rbelConverter) {
        this.rbelConverter = rbelConverter;
    }

    private static class RbelFileReadingException
    extends RuntimeException {
        public RbelFileReadingException(String s, Exception e) {
            super(s, e);
        }
    }
}

