/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.facet;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.renderer.RbelHtmlFacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.H2Tag;
import j2html.tags.specialized.PTag;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.util.Optional;
import lombok.Generated;

public class RbelX509Facet
implements RbelFacet {
    private final RbelElement serialnumber;
    private final RbelElement issuer;
    private final RbelElement validFrom;
    private final RbelElement validUntil;
    private final RbelElement subject;
    private final X509Certificate certificate;

    public RbelX509Facet(RbelElement parent, String serialnumber, RbelElement issuer, ZonedDateTime validFrom, ZonedDateTime validUntil, RbelElement subject, X509Certificate certificate) {
        this.serialnumber = RbelElement.wrap(parent, serialnumber);
        this.issuer = issuer;
        this.validFrom = RbelElement.wrap(parent, validFrom);
        this.validUntil = RbelElement.wrap(parent, validUntil);
        this.subject = subject;
        this.certificate = certificate;
    }

    @Override
    public RbelMultiMap<RbelElement> getChildElements() {
        return new RbelMultiMap<RbelElement>().with("serialnumber", this.serialnumber).with("issuer", this.issuer).with("validFrom", this.validFrom).with("validUntil", this.validUntil).with("subject", this.subject);
    }

    @Generated
    public static RbelX509FacetBuilder builder() {
        return new RbelX509FacetBuilder();
    }

    @Generated
    public RbelElement getSerialnumber() {
        return this.serialnumber;
    }

    @Generated
    public RbelElement getIssuer() {
        return this.issuer;
    }

    @Generated
    public RbelElement getValidFrom() {
        return this.validFrom;
    }

    @Generated
    public RbelElement getValidUntil() {
        return this.validUntil;
    }

    @Generated
    public RbelElement getSubject() {
        return this.subject;
    }

    @Generated
    public X509Certificate getCertificate() {
        return this.certificate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelX509Facet)) {
            return false;
        }
        RbelX509Facet other = (RbelX509Facet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RbelElement this$serialnumber = this.getSerialnumber();
        RbelElement other$serialnumber = other.getSerialnumber();
        if (this$serialnumber == null ? other$serialnumber != null : !this$serialnumber.equals(other$serialnumber)) {
            return false;
        }
        RbelElement this$issuer = this.getIssuer();
        RbelElement other$issuer = other.getIssuer();
        if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
            return false;
        }
        RbelElement this$validFrom = this.getValidFrom();
        RbelElement other$validFrom = other.getValidFrom();
        if (this$validFrom == null ? other$validFrom != null : !this$validFrom.equals(other$validFrom)) {
            return false;
        }
        RbelElement this$validUntil = this.getValidUntil();
        RbelElement other$validUntil = other.getValidUntil();
        if (this$validUntil == null ? other$validUntil != null : !this$validUntil.equals(other$validUntil)) {
            return false;
        }
        RbelElement this$subject = this.getSubject();
        RbelElement other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        X509Certificate this$certificate = this.getCertificate();
        X509Certificate other$certificate = other.getCertificate();
        return !(this$certificate == null ? other$certificate != null : !((Object)this$certificate).equals(other$certificate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelX509Facet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelElement $serialnumber = this.getSerialnumber();
        result = result * 59 + ($serialnumber == null ? 43 : $serialnumber.hashCode());
        RbelElement $issuer = this.getIssuer();
        result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
        RbelElement $validFrom = this.getValidFrom();
        result = result * 59 + ($validFrom == null ? 43 : $validFrom.hashCode());
        RbelElement $validUntil = this.getValidUntil();
        result = result * 59 + ($validUntil == null ? 43 : $validUntil.hashCode());
        RbelElement $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        X509Certificate $certificate = this.getCertificate();
        result = result * 59 + ($certificate == null ? 43 : ((Object)$certificate).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelX509Facet(serialnumber=" + this.getSerialnumber() + ", issuer=" + this.getIssuer() + ", validFrom=" + this.getValidFrom() + ", validUntil=" + this.getValidUntil() + ", subject=" + this.getSubject() + ", certificate=" + this.getCertificate() + ")";
    }

    static {
        RbelHtmlRenderer.registerFacetRenderer(new RbelHtmlFacetRenderer(){

            @Override
            public boolean checkForRendering(RbelElement element) {
                return element.hasFacet(RbelX509Facet.class);
            }

            @Override
            public ContainerTag performRendering(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
                RbelX509Facet x509Facet = element.getFacetOrFail(RbelX509Facet.class);
                return TagCreator.div((DomContent[])new DomContent[]{((H2Tag)TagCreator.h2().withClass("title")).withText("X509 Certificate"), ((PTag)TagCreator.p().with((DomContent)TagCreator.b().withText("Subject: "))).withText(x509Facet.getSubject().printValue().orElse("")), ((PTag)TagCreator.p().with((DomContent)TagCreator.b().withText("Issuer: "))).withText(x509Facet.getIssuer().printValue().orElse("")), ((PTag)TagCreator.p().with((DomContent)TagCreator.b().withText("Serialnumber: "))).withText(x509Facet.getSerialnumber().printValue().orElse("")), ((PTag)TagCreator.p().with((DomContent)TagCreator.b().withText("Valid From: "))).withText(x509Facet.getValidFrom().printValue().orElse("")), ((PTag)TagCreator.p().with((DomContent)TagCreator.b().withText("Valid Until: "))).withText(x509Facet.getValidUntil().printValue().orElse("")), TagCreator.br(), RbelHtmlRenderingToolkit.ancestorTitle().with((DomContent)RbelHtmlRenderingToolkit.vertParentTitle().with(renderingToolkit.convertNested(element)))});
            }
        });
    }

    @Generated
    public static class RbelX509FacetBuilder {
        @Generated
        private RbelElement parent;
        @Generated
        private String serialnumber;
        @Generated
        private RbelElement issuer;
        @Generated
        private ZonedDateTime validFrom;
        @Generated
        private ZonedDateTime validUntil;
        @Generated
        private RbelElement subject;
        @Generated
        private X509Certificate certificate;

        @Generated
        RbelX509FacetBuilder() {
        }

        @Generated
        public RbelX509FacetBuilder parent(RbelElement parent) {
            this.parent = parent;
            return this;
        }

        @Generated
        public RbelX509FacetBuilder serialnumber(String serialnumber) {
            this.serialnumber = serialnumber;
            return this;
        }

        @Generated
        public RbelX509FacetBuilder issuer(RbelElement issuer) {
            this.issuer = issuer;
            return this;
        }

        @Generated
        public RbelX509FacetBuilder validFrom(ZonedDateTime validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        @Generated
        public RbelX509FacetBuilder validUntil(ZonedDateTime validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        @Generated
        public RbelX509FacetBuilder subject(RbelElement subject) {
            this.subject = subject;
            return this;
        }

        @Generated
        public RbelX509FacetBuilder certificate(X509Certificate certificate) {
            this.certificate = certificate;
            return this;
        }

        @Generated
        public RbelX509Facet build() {
            return new RbelX509Facet(this.parent, this.serialnumber, this.issuer, this.validFrom, this.validUntil, this.subject, this.certificate);
        }

        @Generated
        public String toString() {
            return "RbelX509Facet.RbelX509FacetBuilder(parent=" + this.parent + ", serialnumber=" + this.serialnumber + ", issuer=" + this.issuer + ", validFrom=" + this.validFrom + ", validUntil=" + this.validUntil + ", subject=" + this.subject + ", certificate=" + this.certificate + ")";
        }
    }
}

