/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.facet;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.renderer.RbelHtmlFacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.PreTag;
import j2html.tags.specialized.TableTag;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class RbelHttpHeaderFacet
implements RbelFacet,
Map<String, RbelElement> {
    private final RbelMultiMap<RbelElement> values;

    public RbelHttpHeaderFacet() {
        this.values = new RbelMultiMap();
    }

    public RbelHttpHeaderFacet(RbelMultiMap<RbelElement> values) {
        this.values = values;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.values.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    @Override
    public RbelElement get(Object key) {
        return this.values.get(key);
    }

    @Override
    public RbelElement put(String key, RbelElement value) {
        this.values.put(key, value);
        return value;
    }

    @Override
    public RbelElement remove(Object key) {
        return this.values.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends RbelElement> m) {
        this.values.putAll((Map<String, RbelElement>)m);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.values.keySet();
    }

    @Override
    public List<RbelElement> values() {
        return this.values.stream().map(Map.Entry::getValue).toList();
    }

    @Override
    @Deprecated(forRemoval=true)
    public Set<Map.Entry<String, RbelElement>> entrySet() {
        throw new UnsupportedOperationException("This method is not supported as it would not respect the order of the entries");
    }

    public List<Map.Entry<String, RbelElement>> entries() {
        return this.values.getValues().stream().toList();
    }

    @Override
    public RbelMultiMap<RbelElement> getChildElements() {
        return this.values;
    }

    public Stream<RbelElement> getCaseInsensitiveMatches(String key) {
        String lowerCaseKey = key.toLowerCase();
        return this.values.getValues().stream().filter(entry -> entry.getKey() != null).filter(entry -> ((String)entry.getKey()).toLowerCase().equals(lowerCaseKey)).map(Map.Entry::getValue);
    }

    public boolean hasValueMatching(String headerKey, String prefix) {
        return this.values.getValues().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(headerKey)).map(Map.Entry::getValue).map(RbelElement::getRawStringContent).anyMatch(str -> str.startsWith(prefix));
    }

    static {
        RbelHtmlRenderer.registerFacetRenderer(new RbelHtmlFacetRenderer(){

            @Override
            public boolean checkForRendering(RbelElement element) {
                return element.hasFacet(RbelHttpHeaderFacet.class);
            }

            @Override
            public ContainerTag performRendering(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
                return ((TableTag)TagCreator.table().withClass("table")).with((DomContent)TagCreator.tbody().with(element.getFacetOrFail(RbelHttpHeaderFacet.class).getChildElements().stream().map(entry -> TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((DomContent[])new DomContent[]{TagCreator.pre((String)((String)entry.getKey()))}), TagCreator.td((DomContent[])new DomContent[]{((PreTag)TagCreator.pre().with((DomContent)renderingToolkit.convert((RbelElement)entry.getValue(), Optional.ofNullable((String)entry.getKey())))).withClass("value")}).with(RbelHtmlRenderingToolkit.addNotes((RbelElement)entry.getValue(), new String[0]))})).toList()));
            }
        });
    }
}

