/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.facet;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.facet.RbelFacet;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import lombok.Generated;

public class RbelHostnameFacet
implements RbelFacet {
    private final RbelElement port;
    private final RbelElement domain;
    private Optional<RbelElement> bundledServerName;

    public static RbelElement buildRbelHostnameFacet(RbelElement parentNode, RbelHostname rbelHostname) {
        return RbelHostnameFacet.buildRbelHostnameFacet(parentNode, rbelHostname, null);
    }

    public static RbelElement buildRbelHostnameFacet(RbelElement parentNode, RbelHostname rbelHostname, String bundledServerName) {
        if (rbelHostname == null) {
            return new RbelElement(null, parentNode);
        }
        RbelElement result = new RbelElement(rbelHostname.toString().getBytes(StandardCharsets.UTF_8), parentNode);
        result.addFacet(RbelHostnameFacet.builder().port(RbelElement.wrap(result, rbelHostname.getPort())).domain(RbelElement.wrap(result, rbelHostname.getHostname())).bundledServerName(Optional.ofNullable(bundledServerName).map(bundledName -> RbelElement.wrap(parentNode, bundledName))).build());
        return result;
    }

    @Override
    public RbelMultiMap<RbelElement> getChildElements() {
        return new RbelMultiMap<RbelElement>().withSkipIfNull("bundledServerName", this.bundledServerName.orElse(null)).with("port", this.port).with("domain", this.domain);
    }

    public String toString() {
        return (String)this.bundledServerName.flatMap(el -> el.seekValue(String.class)).or(() -> this.domain.seekValue(String.class)).orElseThrow(() -> new RbelHostnameStructureException("Could not find domain-name!")) + this.port.seekValue(Integer.class).map(bundledServerPort -> ":" + bundledServerPort).orElse("");
    }

    public RbelHostname toRbelHostname() {
        return RbelHostname.builder().hostname((String)this.bundledServerName.flatMap(el -> el.seekValue(String.class)).or(() -> this.domain.seekValue(String.class)).orElseThrow()).port(this.port.seekValue(Integer.class).orElse(0)).build();
    }

    @Generated
    private static Optional<RbelElement> $default$bundledServerName() {
        return Optional.empty();
    }

    @Generated
    public static RbelHostnameFacetBuilder builder() {
        return new RbelHostnameFacetBuilder();
    }

    @Generated
    public RbelHostnameFacetBuilder toBuilder() {
        return new RbelHostnameFacetBuilder().port(this.port).domain(this.domain).bundledServerName(this.bundledServerName);
    }

    @Generated
    public RbelElement getPort() {
        return this.port;
    }

    @Generated
    public RbelElement getDomain() {
        return this.domain;
    }

    @Generated
    public Optional<RbelElement> getBundledServerName() {
        return this.bundledServerName;
    }

    @Generated
    public void setBundledServerName(Optional<RbelElement> bundledServerName) {
        this.bundledServerName = bundledServerName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelHostnameFacet)) {
            return false;
        }
        RbelHostnameFacet other = (RbelHostnameFacet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RbelElement this$port = this.getPort();
        RbelElement other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        RbelElement this$domain = this.getDomain();
        RbelElement other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        Optional<RbelElement> this$bundledServerName = this.getBundledServerName();
        Optional<RbelElement> other$bundledServerName = other.getBundledServerName();
        return !(this$bundledServerName == null ? other$bundledServerName != null : !((Object)this$bundledServerName).equals(other$bundledServerName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelHostnameFacet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelElement $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        RbelElement $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        Optional<RbelElement> $bundledServerName = this.getBundledServerName();
        result = result * 59 + ($bundledServerName == null ? 43 : ((Object)$bundledServerName).hashCode());
        return result;
    }

    @ConstructorProperties(value={"port", "domain", "bundledServerName"})
    @Generated
    private RbelHostnameFacet(RbelElement port, RbelElement domain, Optional<RbelElement> bundledServerName) {
        this.port = port;
        this.domain = domain;
        this.bundledServerName = bundledServerName;
    }

    @Generated
    public static class RbelHostnameFacetBuilder {
        @Generated
        private RbelElement port;
        @Generated
        private RbelElement domain;
        @Generated
        private boolean bundledServerName$set;
        @Generated
        private Optional<RbelElement> bundledServerName$value;

        @Generated
        RbelHostnameFacetBuilder() {
        }

        @Generated
        public RbelHostnameFacetBuilder port(RbelElement port) {
            this.port = port;
            return this;
        }

        @Generated
        public RbelHostnameFacetBuilder domain(RbelElement domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public RbelHostnameFacetBuilder bundledServerName(Optional<RbelElement> bundledServerName) {
            this.bundledServerName$value = bundledServerName;
            this.bundledServerName$set = true;
            return this;
        }

        @Generated
        public RbelHostnameFacet build() {
            Optional<RbelElement> bundledServerName$value = this.bundledServerName$value;
            if (!this.bundledServerName$set) {
                bundledServerName$value = RbelHostnameFacet.$default$bundledServerName();
            }
            return new RbelHostnameFacet(this.port, this.domain, bundledServerName$value);
        }

        @Generated
        public String toString() {
            return "RbelHostnameFacet.RbelHostnameFacetBuilder(port=" + this.port + ", domain=" + this.domain + ", bundledServerName$value=" + this.bundledServerName$value + ")";
        }
    }

    private class RbelHostnameStructureException
    extends RuntimeException {
        public RbelHostnameStructureException(String s) {
            super(s);
        }
    }
}

