/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.decorator;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.facet.RbelHostnameFacet;
import de.gematik.rbellogger.util.GlobalServerMap;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;

public class ServernameFromSpyPortMapping
implements Function<RbelElement, Optional<String>> {
    @Override
    public Optional<String> apply(RbelElement element) {
        return this.findBundledServerNameForHostnameFacet(element);
    }

    private Optional<String> findBundledServerNameForHostnameFacet(RbelElement hostNameElement) {
        Integer port = this.extractPort(hostNameElement).orElseThrow(() -> new IllegalStateException("failed to extract port"));
        return GlobalServerMap.getServerNameForPort((int)port);
    }

    private Optional<Integer> extractPort(RbelElement hostNameElement) {
        return hostNameElement.getFacet(RbelHostnameFacet.class).map(RbelHostnameFacet::toRbelHostname).map(RbelHostname::getPort);
    }

    @Generated
    public ServernameFromSpyPortMapping() {
    }
}

