/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.decorator;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.facet.RbelHostnameFacet;
import de.gematik.rbellogger.util.GlobalServerMap;
import de.gematik.rbellogger.util.PortToProcessMapper;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import lombok.Generated;

public class ServernameFromProcessAndPortSupplier
implements Function<RbelElement, Optional<String>> {
    @Override
    public Optional<String> apply(RbelElement element) {
        return this.findBundledServerNameForHostnameFacet(element);
    }

    private Optional<String> findBundledServerNameForHostnameFacet(RbelElement hostNameElement) {
        Integer port = this.extractPort(hostNameElement).orElseThrow(() -> new IllegalStateException("failed to extract port"));
        Long processId = (Long)GlobalServerMap.getPortToProcessId().get(port);
        if (processId == null) {
            ConcurrentMap updatedMapWithPortsAndProcessIds = PortToProcessMapper.getProcessIdsForPort((int)port);
            processId = (Long)updatedMapWithPortsAndProcessIds.get(port);
        }
        if (processId != null && GlobalServerMap.getProcessIdToBundledServerName().containsKey(processId)) {
            return Optional.of((String)GlobalServerMap.getProcessIdToBundledServerName().get(processId));
        }
        return Optional.empty();
    }

    private Optional<Integer> extractPort(RbelElement hostNameElement) {
        return hostNameElement.getFacet(RbelHostnameFacet.class).map(RbelHostnameFacet::toRbelHostname).map(RbelHostname::getPort);
    }

    @Generated
    public ServernameFromProcessAndPortSupplier() {
    }
}

