/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public class RbelMultiMap<T>
implements Map<String, T> {
    public static final Collector<Map.Entry<String, ?>, RbelMultiMap, RbelMultiMap> COLLECTOR = Collector.of(RbelMultiMap::new, RbelMultiMap::put, (m1, m2) -> {
        m1.putAll((Map)m2);
        return m1;
    }, new Collector.Characteristics[0]);
    private final Queue<Map.Entry<String, T>> values = new ConcurrentLinkedQueue<Map.Entry<String, T>>();

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.values.stream().anyMatch(entry -> ((String)entry.getKey()).equals(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.stream().anyMatch(entry -> entry.getValue().equals(value));
    }

    @Override
    public T get(Object key) {
        return this.values.stream().filter(entry -> ((String)entry.getKey()).equals(key)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public List<T> getAll(Object key) {
        return this.values.stream().filter(entry -> ((String)entry.getKey()).equals(key)).map(Map.Entry::getValue).toList();
    }

    @Override
    public T put(String key, T value) {
        this.values.add((Map.Entry<String, T>)Pair.of((Object)key, value));
        return null;
    }

    public T put(Map.Entry<String, T> value) {
        this.values.add(value);
        return null;
    }

    @Override
    public T remove(Object key) {
        return this.removeAll(key.toString()).stream().findFirst().orElse(null);
    }

    public List<T> removeAll(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Iterator iterator = this.values.iterator();
        ArrayList removed = new ArrayList();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!key.equals(entry.getKey())) continue;
            iterator.remove();
            removed.add(entry.getValue());
        }
        return removed;
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> m) {
        for (Map.Entry<String, T> entry : m.entrySet()) {
            this.values.add((Map.Entry<String, T>)Pair.of((Object)entry.getKey(), entry.getValue()));
        }
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.values.stream().map(Map.Entry::getKey).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    @Deprecated(forRemoval=true)
    public List<T> values() {
        throw new UnsupportedOperationException("This method is not supported as it would not respect the order of the entries");
    }

    @Override
    @Deprecated(forRemoval=true)
    public Set<Map.Entry<String, T>> entrySet() {
        throw new UnsupportedOperationException("This method is not supported as it would not respect the order of the entries");
    }

    public Stream<Map.Entry<String, T>> stream() {
        return this.values.stream();
    }

    public RbelMultiMap<T> with(String key, T value) {
        this.put(key, value);
        return this;
    }

    public RbelMultiMap<T> withSkipIfNull(String key, T value) {
        if (value != null) {
            this.put(key, value);
        }
        return this;
    }

    public Iterator<Map.Entry<String, T>> iterator() {
        return this.values.iterator();
    }

    @Generated
    public RbelMultiMap() {
    }

    @Generated
    public Queue<Map.Entry<String, T>> getValues() {
        return this.values;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelMultiMap)) {
            return false;
        }
        RbelMultiMap other = (RbelMultiMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Queue<Map.Entry<String, T>> this$values = this.getValues();
        Queue<Map.Entry<String, T>> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !this$values.equals(other$values));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelMultiMap;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Queue<Map.Entry<String, T>> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : $values.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelMultiMap(values=" + this.getValues() + ")";
    }
}

