/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.facet.RbelCborFacet;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelHttpMessageFacet;
import de.gematik.rbellogger.data.facet.RbelHttpRequestFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.data.facet.RbelJsonFacet;
import de.gematik.rbellogger.data.facet.RbelNestedFacet;
import de.gematik.rbellogger.data.facet.RbelNoteFacet;
import de.gematik.rbellogger.data.facet.RbelRootFacet;
import de.gematik.rbellogger.data.facet.RbelValueFacet;
import de.gematik.rbellogger.data.util.RbelElementTreePrinter;
import de.gematik.rbellogger.util.RbelException;
import de.gematik.rbellogger.util.RbelJexlExecutor;
import de.gematik.rbellogger.util.RbelPathAble;
import de.gematik.rbellogger.util.RbelPathExecutor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelElement
extends RbelPathAble {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelElement.class);
    private final String uuid;
    private final byte[] rawContent;
    private final RbelElement parentNode;
    private final Queue<RbelFacet> facets = new ConcurrentLinkedQueue<RbelFacet>();
    private Optional<Charset> charset;
    private final long size;

    public RbelElement(byte[] rawContent, RbelElement parentNode) {
        this(null, rawContent, parentNode, Optional.empty());
    }

    public RbelElement(byte[] rawContent, RbelElement parentNode, Optional<Charset> charset) {
        this(null, rawContent, parentNode, charset);
    }

    public RbelElement(@Nullable String uuid, byte[] rawContent, RbelElement parentNode, Optional<Charset> charset) {
        this.uuid = StringUtils.isNotEmpty((CharSequence)uuid) ? uuid : UUID.randomUUID().toString();
        this.rawContent = rawContent;
        this.parentNode = parentNode;
        this.charset = Objects.requireNonNullElseGet(charset, Optional::empty);
        this.size = rawContent != null ? (long)rawContent.length : 0L;
    }

    public static RbelElement wrap(byte[] rawValue, @NonNull RbelElement parentNode, Object value) {
        if (parentNode == null) {
            throw new NullPointerException("parentNode is marked non-null but is null");
        }
        return new RbelElement(rawValue, parentNode).addFacet(new RbelValueFacet<Object>(value));
    }

    public static RbelElement wrap(@NonNull RbelElement parentNode, Object value) {
        if (parentNode == null) {
            throw new NullPointerException("parentNode is marked non-null but is null");
        }
        return new RbelElement(value.toString().getBytes(parentNode.getElementCharset()), parentNode).addFacet(new RbelValueFacet<Object>(value));
    }

    public <T> Optional<T> getFacet(@NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.getFacetStream().filter(facet -> clazz.isAssignableFrom(facet.getClass())).map(clazz::cast).findFirst();
    }

    public boolean hasFacet(Class<? extends RbelFacet> clazz) {
        return this.getFacet(clazz).isPresent();
    }

    public RbelElement addFacet(RbelFacet facet) {
        this.facets.add(facet);
        return this;
    }

    public List<RbelElement> getChildNodes() {
        return this.getFacetStream().map(RbelFacet::getChildElements).map(RbelMultiMap::getValues).flatMap(Collection::stream).map(Map.Entry::getValue).filter(Objects::nonNull).toList();
    }

    private Stream<RbelFacet> getFacetStream() {
        return new ArrayList<RbelFacet>(this.facets).stream();
    }

    public RbelMultiMap<RbelElement> getChildNodesWithKey() {
        return this.getFacetStream().map(RbelFacet::getChildElements).map(RbelMultiMap::getValues).flatMap(Collection::stream).filter(el -> el.getValue() != null).collect(RbelMultiMap.COLLECTOR);
    }

    public void triggerPostConversionListener(RbelConverter context) {
        for (RbelElement element : this.getChildNodes()) {
            element.triggerPostConversionListener(context);
        }
        context.triggerPostConversionListenerFor(this);
    }

    public List<RbelElement> traverseAndReturnNestedMembers() {
        return this.getChildNodes().stream().map(RbelElement::traverseAndReturnNestedMembersInternal).flatMap(Collection::stream).toList();
    }

    List<RbelElement> traverseAndReturnNestedMembersInternal() {
        log.trace("Traversing into {}: facets are {}", (Object)this.findNodePath(), this.getFacets().stream().map(Object::getClass).map(Class::getSimpleName).toList());
        if (this.hasFacet(RbelRootFacet.class)) {
            return List.of(this);
        }
        return this.getChildNodes().stream().map(RbelElement::traverseAndReturnNestedMembersInternal).flatMap(Collection::stream).toList();
    }

    public Optional<RbelElement> getFirst(String key) {
        return this.getChildNodesWithKey().stream().filter(entry -> ((String)entry.getKey()).equals(key)).map(Map.Entry::getValue).findFirst();
    }

    public List<RbelElement> getAll(String key) {
        return this.getChildNodesWithKey().stream().filter(entry -> ((String)entry.getKey()).equals(key)).map(Map.Entry::getValue).toList();
    }

    public Optional<String> findKeyInParentElement() {
        return Optional.of(this).map(RbelElement::getParentNode).stream().flatMap(parent -> parent.getChildNodesWithKey().stream()).filter(e -> e.getValue() == this).map(Map.Entry::getKey).findFirst();
    }

    public List<RbelElement> findRbelPathMembers(String rbelPath) {
        return new RbelPathExecutor<RbelElement>(this, rbelPath).execute();
    }

    @Override
    @Nullable
    public String getRawStringContent() {
        if (this.rawContent == null) {
            return null;
        }
        return new String(this.rawContent, this.getElementCharset());
    }

    public Charset getElementCharset() {
        return this.charset.or(() -> Optional.ofNullable(this.parentNode).map(RbelElement::getElementCharset)).orElse(StandardCharsets.UTF_8);
    }

    public <T extends RbelFacet> T getFacetOrFail(Class<T> facetClass) {
        return (T)((RbelFacet)this.getFacet(facetClass).orElseThrow());
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "(" + this.uuid + ") at $." + this.findNodePath() + " with facets " + this.facets.stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(",")) + "]";
    }

    public Optional<Object> seekValue() {
        return this.getFacet(RbelValueFacet.class).map(RbelValueFacet::getValue);
    }

    public Optional<String> printValue() {
        return this.getFacet(RbelValueFacet.class).map(RbelValueFacet::getValue).map(Object::toString);
    }

    public <T> Optional<T> seekValue(Class<T> clazz) {
        return this.getFacet(RbelValueFacet.class).map(RbelValueFacet::getValue).filter(clazz::isInstance).map(clazz::cast);
    }

    @Override
    public Optional<String> getKey() {
        if (this.parentNode == null) {
            return Optional.empty();
        }
        for (Map.Entry entry : this.parentNode.getChildNodesWithKey().getValues()) {
            if (entry.getValue() != this) continue;
            return Optional.ofNullable((String)entry.getKey());
        }
        throw new RbelException("Unable to find key for element " + this);
    }

    public void addOrReplaceFacet(RbelFacet facet) {
        this.getFacet(facet.getClass()).ifPresent(this.facets::remove);
        this.facets.add(facet);
    }

    public void removeFacetsOfType(Class<? extends RbelFacet> facetClass) {
        List<RbelFacet> facetsToBeRemoved = this.facets.stream().filter(facetClass::isInstance).toList();
        facetsToBeRemoved.forEach(this.facets::remove);
        facetsToBeRemoved.forEach(facet -> facet.facetRemovedCallback(this));
    }

    public Optional<RbelElement> findElement(String rbelPath) {
        List<RbelElement> resultList = this.findRbelPathMembers(rbelPath);
        if (resultList.isEmpty()) {
            return Optional.empty();
        }
        if (resultList.size() == 1) {
            return Optional.of(resultList.get(0));
        }
        throw new RbelPathNotUniqueException("RbelPath '" + rbelPath + "' is not unique! Found " + resultList.size() + " elements, expected only one!");
    }

    public String printTreeStructureWithoutColors() {
        return RbelElementTreePrinter.builder().rootElement(this).printColors(false).build().execute();
    }

    public String printTreeStructure() {
        return RbelElementTreePrinter.builder().rootElement(this).build().execute();
    }

    public String printTreeStructure(int maximumLevels, boolean printKeys) {
        return RbelElementTreePrinter.builder().rootElement(this).printKeys(printKeys).maximumLevels(maximumLevels).build().execute();
    }

    public List<RbelNoteFacet> getNotes() {
        return this.getFacetStream().flatMap(facet -> {
            if (facet instanceof RbelNestedFacet) {
                RbelNestedFacet asRbelNestedFacet = (RbelNestedFacet)facet;
                if (asRbelNestedFacet.getNestedElement().hasFacet(RbelRootFacet.class)) {
                    return Stream.empty();
                }
                return asRbelNestedFacet.getNestedElement().getFacets().stream();
            }
            return Stream.of(facet);
        }).filter(RbelNoteFacet.class::isInstance).map(RbelNoteFacet.class::cast).toList();
    }

    public RbelElement findMessage() {
        RbelElement position = this;
        while (position.getParentNode() != null) {
            position = position.getParentNode();
        }
        return position;
    }

    public Optional<RbelElement> findAncestorWithFacet(Class<? extends RbelFacet> rbelFacetClass) {
        for (RbelElement position = this.getParentNode(); position != null; position = position.getParentNode()) {
            if (!position.hasFacet(rbelFacetClass)) continue;
            return Optional.of(position);
        }
        return Optional.empty();
    }

    @Override
    public List<RbelPathAble> descendToContentNodeIfAdvised() {
        if ((this.hasFacet(RbelJsonFacet.class) || this.hasFacet(RbelCborFacet.class)) && this.hasFacet(RbelNestedFacet.class)) {
            return List.of((RbelPathAble)this.getFacet(RbelNestedFacet.class).map(RbelNestedFacet::getNestedElement).orElseThrow(), this);
        }
        return List.of(this);
    }

    @Override
    public boolean shouldElementBeKeptInFinalResult() {
        return !this.hasFacet(RbelJsonFacet.class) && !this.hasFacet(RbelCborFacet.class) || !this.hasFacet(RbelNestedFacet.class);
    }

    public String printHttpDescription() {
        return this.getFacet(RbelHttpRequestFacet.class).map(req -> "HTTP " + req.getMethod().getRawStringContent() + " " + req.getPathAsString()).orElse("") + this.getFacet(RbelHttpResponseFacet.class).map(req -> "HTTP " + req.getResponseCode().getRawStringContent()).orElse("") + this.getFacet(RbelHttpMessageFacet.class).map(msg -> " with body '" + StringUtils.abbreviate((String)msg.getBody().getRawStringContent(), (int)30) + "'").orElse("");
    }

    public RbelElement findRootElement() {
        RbelElement result = this;
        RbelElement newResult = result.getParentNode();
        while (newResult != null) {
            result = newResult;
            newResult = result.getParentNode();
        }
        return result;
    }

    @Generated
    public static RbelElementBuilder builder() {
        return new RbelElementBuilder();
    }

    @Generated
    public RbelElementBuilder toBuilder() {
        return new RbelElementBuilder().uuid(this.uuid).rawContent(this.rawContent).parentNode(this.parentNode).charset(this.charset);
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public byte[] getRawContent() {
        return this.rawContent;
    }

    @Override
    @Generated
    public RbelElement getParentNode() {
        return this.parentNode;
    }

    @Generated
    public Queue<RbelFacet> getFacets() {
        return this.facets;
    }

    @Generated
    public Optional<Charset> getCharset() {
        return this.charset;
    }

    @Generated
    public long getSize() {
        return this.size;
    }

    @Generated
    public void setCharset(Optional<Charset> charset) {
        this.charset = charset;
    }

    static {
        RbelJexlExecutor.initialize();
    }

    private static class RbelPathNotUniqueException
    extends RuntimeException {
        public RbelPathNotUniqueException(String s) {
            super(s);
        }
    }

    @Generated
    public static class RbelElementBuilder {
        @Generated
        private String uuid;
        @Generated
        private byte[] rawContent;
        @Generated
        private RbelElement parentNode;
        @Generated
        private Optional<Charset> charset;

        @Generated
        RbelElementBuilder() {
        }

        @Generated
        public RbelElementBuilder uuid(@Nullable String uuid) {
            this.uuid = uuid;
            return this;
        }

        @Generated
        public RbelElementBuilder rawContent(byte[] rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        @Generated
        public RbelElementBuilder parentNode(RbelElement parentNode) {
            this.parentNode = parentNode;
            return this;
        }

        @Generated
        public RbelElementBuilder charset(Optional<Charset> charset) {
            this.charset = charset;
            return this;
        }

        @Generated
        public RbelElement build() {
            return new RbelElement(this.uuid, this.rawContent, this.parentNode, this.charset);
        }

        @Generated
        public String toString() {
            return "RbelElement.RbelElementBuilder(uuid=" + this.uuid + ", rawContent=" + Arrays.toString(this.rawContent) + ", parentNode=" + this.parentNode + ", charset=" + this.charset + ")";
        }
    }
}

