/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.facet.RbelMapFacet;
import de.gematik.rbellogger.data.facet.RbelValueFacet;
import java.io.IOException;
import lombok.Generated;
import org.bouncycastle.asn1.x500.style.X500NameTokenizer;
import org.bouncycastle.jce.X509Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelX500Converter
implements RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelX500Converter.class);

    @Override
    public void consumeElement(RbelElement element, RbelConverter context) {
        try {
            if (element.getFacets().isEmpty()) {
                RbelMultiMap<RbelElement> rdnMap = new RbelMultiMap<RbelElement>();
                X500NameTokenizer nameTokenizer = new X500NameTokenizer(new X509Principal(element.getRawContent()).toString());
                while (nameTokenizer.hasMoreTokens()) {
                    String[] token = nameTokenizer.nextToken().split("=");
                    rdnMap.put(token[0], context.convertElement(token[1], element));
                }
                if (!rdnMap.isEmpty()) {
                    element.addFacet(new RbelMapFacet(rdnMap));
                    element.addFacet(new RbelValueFacet<String>(new X509Principal(element.getRawContent()).toString()));
                }
            }
        }
        catch (IOException | RuntimeException exception) {
            // empty catch block
        }
    }
}

