/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelJsonFacet;
import de.gematik.rbellogger.data.facet.RbelNoteFacet;
import de.gematik.rbellogger.key.RbelKey;
import de.gematik.rbellogger.key.RbelVauKey;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelVauEpaKeyDeriver
implements RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelVauEpaKeyDeriver.class);
    private static final String KEY_ID = "KeyID";
    private static final String AES_256_GCM_KEY = "AES-256-GCM-Key";
    private static final String AES_256_GCM_KEY_SERVER_TO_CLIENT = "AES-256-GCM-Key-Server-to-Client";
    private static final String AES_256_GCM_KEY_CLIENT_TO_SERVER = "AES-256-GCM-Key-Client-to-Server";

    @Override
    public void consumeElement(RbelElement rbelElement, RbelConverter converter) {
        Optional otherSidePublicKey = Optional.ofNullable(rbelElement).filter(el -> el.hasFacet(RbelJsonFacet.class)).flatMap(json -> json.getFirst("PublicKey")).flatMap(this::publicKeyFromJsonKey);
        if (otherSidePublicKey.isEmpty()) {
            return;
        }
        log.trace("Found otherside public key");
        Iterator it = converter.getRbelKeyManager().getAllKeys().iterator();
        while (it.hasNext()) {
            List<RbelKey> derivedKeys;
            RbelKey rbelKey = (RbelKey)it.next();
            Optional<PrivateKey> privateKey = rbelKey.retrieveCorrespondingKeyPair().map(KeyPair::getPrivate).map(PrivateKey.class::cast).or(() -> Optional.of(rbelKey.getKey()).filter(PrivateKey.class::isInstance).map(PrivateKey.class::cast));
            if (!privateKey.isPresent()) continue;
            if (log.isDebugEnabled()) {
                log.debug("Trying key derivation with {}...", (Object)rbelKey.getKeyName());
            }
            if ((derivedKeys = this.keyDerivation((PublicKey)otherSidePublicKey.get(), privateKey.get(), rbelKey)).isEmpty()) continue;
            this.addVauKeyToKeyManager(converter, derivedKeys);
            rbelElement.findMessage().addFacet(RbelNoteFacet.builder().style(RbelNoteFacet.NoteStyling.INFO).value("Added keys with name '" + rbelKey.getKeyName() + "'").build());
        }
    }

    private void addVauKeyToKeyManager(RbelConverter converter, List<RbelKey> derivedKeys) {
        for (RbelKey derivedKey : derivedKeys) {
            if (!converter.getRbelKeyManager().findKeyByName(derivedKey.getKeyName()).isEmpty()) continue;
            if (log.isTraceEnabled()) {
                log.trace("Adding key {} as VAU key", (Object)derivedKey.getKeyName());
            }
            converter.getRbelKeyManager().addKey(derivedKey);
        }
    }

    private Optional<PublicKey> publicKeyFromJsonKey(RbelElement element) {
        try {
            return Optional.ofNullable(KeyFactory.getInstance("ECDSA", "BC").generatePublic(new X509EncodedKeySpec(this.extractBinaryDataFromElement(element))));
        }
        catch (Exception e) {
            log.debug("Exception while converting Public Key {}:", (Object)element.getRawStringContent(), (Object)e);
            return Optional.empty();
        }
    }

    private byte[] extractBinaryDataFromElement(RbelElement element) {
        return Base64.getDecoder().decode(element.getRawStringContent().replace("\"", ""));
    }

    private List<RbelKey> keyDerivation(PublicKey otherSidePublicKey, PrivateKey privateKey, RbelKey parentKey) {
        byte[] sharedSecret;
        if (!(otherSidePublicKey instanceof ECPublicKey)) {
            return List.of();
        }
        ECPublicKey ephemeralPublicKeyClientBC = (ECPublicKey)otherSidePublicKey;
        ECNamedCurveSpec spec = (ECNamedCurveSpec)ephemeralPublicKeyClientBC.getParams();
        if (!"brainpoolP256r1".equals(spec.getName())) {
            return List.of();
        }
        if (log.isTraceEnabled()) {
            log.trace("Performing ECKA with {} and {}", (Object)Base64.getEncoder().encodeToString(privateKey.getEncoded()), (Object)Base64.getEncoder().encodeToString(otherSidePublicKey.getEncoded()));
        }
        try {
            sharedSecret = this.ecka(privateKey, otherSidePublicKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException e) {
            return List.of();
        }
        if (log.isTraceEnabled()) {
            log.trace("shared secret: " + Hex.toHexString((byte[])sharedSecret));
        }
        byte[] keyId = this.hkdf(sharedSecret, KEY_ID, 256);
        if (log.isTraceEnabled()) {
            log.trace("keyID: " + Hex.toHexString((byte[])keyId));
        }
        return List.of(this.mapToRbelKey(AES_256_GCM_KEY_CLIENT_TO_SERVER, "_client", keyId, sharedSecret, parentKey), this.mapToRbelKey(AES_256_GCM_KEY_SERVER_TO_CLIENT, "_server", keyId, sharedSecret, parentKey), this.mapToRbelKey(AES_256_GCM_KEY, "_old", keyId, sharedSecret, parentKey));
    }

    private RbelKey mapToRbelKey(String deriver, String suffix, byte[] keyId, byte[] sharedSecret, RbelKey parentKey) {
        byte[] keyRawBytes = this.hkdf(sharedSecret, deriver, 256);
        if (log.isTraceEnabled()) {
            log.trace("symKey: {}", (Object)Hex.toHexString((byte[])keyRawBytes));
        }
        return new RbelVauKey((Key)new SecretKeySpec(keyRawBytes, "AES"), Hex.toHexString((byte[])keyId) + suffix, 0, parentKey);
    }

    private byte[] ecka(PrivateKey prk, PublicKey puk) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        KeyAgreement ka = KeyAgreement.getInstance("ECDH", "BC");
        ka.init(prk);
        ka.doPhase(puk, true);
        byte[] sharedSecret = ka.generateSecret();
        return sharedSecret;
    }

    private byte[] hkdf(byte[] ikm, String info, int length) throws IllegalArgumentException, DataLengthException {
        return this.hkdf(ikm, info.getBytes(StandardCharsets.UTF_8), length);
    }

    private byte[] hkdf(byte[] ikm, byte[] info, int length) throws IllegalArgumentException, DataLengthException {
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator((Digest)new SHA256Digest());
        hkdf.init((DerivationParameters)new HKDFParameters(ikm, null, info));
        byte[] okm = new byte[length / 8];
        hkdf.generateBytes(okm, 0, length / 8);
        return okm;
    }
}

