/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelJexlShadingExpression;
import de.gematik.rbellogger.data.facet.RbelNoteFacet;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelValueShader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelValueShader.class);
    private final List<RbelJexlShadingExpression> jexlShadingMap = new ArrayList<RbelJexlShadingExpression>();
    private final List<RbelJexlShadingExpression> jexlNoteMap = new ArrayList<RbelJexlShadingExpression>();

    public Optional<String> shadeValue(Object element, Optional<String> key) {
        return this.jexlShadingMap.stream().filter(entry -> {
            try {
                return TigerJexlExecutor.matchesAsJexlExpression((Object)element, (String)entry.getJexlExpression(), (Optional)key);
            }
            catch (RuntimeException ignored) {
                return false;
            }
        }).map(this::incrementNumberOfMatches).map(entry -> String.format(entry.getShadingValue(), this.toStringValue(element))).findFirst();
    }

    private RbelJexlShadingExpression incrementNumberOfMatches(RbelJexlShadingExpression rbelJexlShadingExpression) {
        rbelJexlShadingExpression.getNumberOfMatches().incrementAndGet();
        return rbelJexlShadingExpression;
    }

    public void addNote(RbelElement element) {
        this.jexlNoteMap.stream().filter(entry -> {
            try {
                return TigerJexlExecutor.matchesAsJexlExpression((Object)element, (String)entry.getJexlExpression(), element.findKeyInParentElement());
            }
            catch (RuntimeException ignored) {
                return false;
            }
        }).map(this::incrementNumberOfMatches).map(entry -> String.format(entry.getShadingValue(), this.toStringValue(element))).map(note -> new RbelNoteFacet((String)note, RbelNoteFacet.NoteStyling.INFO)).forEach(element::addFacet);
    }

    private String toStringValue(Object value) {
        if (value instanceof RbelElement) {
            RbelElement element = (RbelElement)value;
            return element.getRawStringContent();
        }
        return value.toString();
    }

    public RbelValueShader addSimpleShadingCriterion(String attributeName, String stringFValue) {
        this.jexlShadingMap.add(RbelJexlShadingExpression.builder().jexlExpression("key == '" + attributeName + "'").shadingValue(stringFValue).build());
        return this;
    }

    public RbelValueShader addJexlShadingCriterion(String jsonPathExpression, String stringFValue) {
        this.jexlShadingMap.add(RbelJexlShadingExpression.builder().jexlExpression(jsonPathExpression).shadingValue(stringFValue).build());
        return this;
    }

    public RbelValueShader addJexlNoteCriterion(String jsonPathExpression, String stringFValue) {
        this.jexlNoteMap.add(RbelJexlShadingExpression.builder().jexlExpression(jsonPathExpression).shadingValue(stringFValue).build());
        return this;
    }

    public RbelConverterPlugin getPostConversionListener() {
        return (element, converter) -> this.addNote(element);
    }

    @Generated
    public RbelValueShader() {
    }

    @Generated
    public List<RbelJexlShadingExpression> getJexlShadingMap() {
        return this.jexlShadingMap;
    }

    @Generated
    public List<RbelJexlShadingExpression> getJexlNoteMap() {
        return this.jexlNoteMap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelValueShader)) {
            return false;
        }
        RbelValueShader other = (RbelValueShader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<RbelJexlShadingExpression> this$jexlShadingMap = this.getJexlShadingMap();
        List<RbelJexlShadingExpression> other$jexlShadingMap = other.getJexlShadingMap();
        if (this$jexlShadingMap == null ? other$jexlShadingMap != null : !((Object)this$jexlShadingMap).equals(other$jexlShadingMap)) {
            return false;
        }
        List<RbelJexlShadingExpression> this$jexlNoteMap = this.getJexlNoteMap();
        List<RbelJexlShadingExpression> other$jexlNoteMap = other.getJexlNoteMap();
        return !(this$jexlNoteMap == null ? other$jexlNoteMap != null : !((Object)this$jexlNoteMap).equals(other$jexlNoteMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelValueShader;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<RbelJexlShadingExpression> $jexlShadingMap = this.getJexlShadingMap();
        result = result * 59 + ($jexlShadingMap == null ? 43 : ((Object)$jexlShadingMap).hashCode());
        List<RbelJexlShadingExpression> $jexlNoteMap = this.getJexlNoteMap();
        result = result * 59 + ($jexlNoteMap == null ? 43 : ((Object)$jexlNoteMap).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelValueShader(jexlShadingMap=" + this.getJexlShadingMap() + ", jexlNoteMap=" + this.getJexlNoteMap() + ")";
    }

    public static class JexlMessage {
        public final String method;
        public final String url;
        public final boolean isRequest;
        public final boolean isResponse;
        public final Map<String, String> headers;
        public final String bodyAsString;
        public final RbelElement body;

        @ConstructorProperties(value={"method", "url", "isRequest", "isResponse", "headers", "bodyAsString", "body"})
        @Generated
        JexlMessage(String method, String url, boolean isRequest, boolean isResponse, Map<String, String> headers, String bodyAsString, RbelElement body) {
            this.method = method;
            this.url = url;
            this.isRequest = isRequest;
            this.isResponse = isResponse;
            this.headers = headers;
            this.bodyAsString = bodyAsString;
            this.body = body;
        }

        @Generated
        public static JexlMessageBuilder builder() {
            return new JexlMessageBuilder();
        }

        @Generated
        public String getMethod() {
            return this.method;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public boolean isRequest() {
            return this.isRequest;
        }

        @Generated
        public boolean isResponse() {
            return this.isResponse;
        }

        @Generated
        public Map<String, String> getHeaders() {
            return this.headers;
        }

        @Generated
        public String getBodyAsString() {
            return this.bodyAsString;
        }

        @Generated
        public RbelElement getBody() {
            return this.body;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JexlMessage)) {
                return false;
            }
            JexlMessage other = (JexlMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isRequest() != other.isRequest()) {
                return false;
            }
            if (this.isResponse() != other.isResponse()) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            Map<String, String> this$headers = this.getHeaders();
            Map<String, String> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            String this$bodyAsString = this.getBodyAsString();
            String other$bodyAsString = other.getBodyAsString();
            if (this$bodyAsString == null ? other$bodyAsString != null : !this$bodyAsString.equals(other$bodyAsString)) {
                return false;
            }
            RbelElement this$body = this.getBody();
            RbelElement other$body = other.getBody();
            return !(this$body == null ? other$body != null : !this$body.equals(other$body));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JexlMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRequest() ? 79 : 97);
            result = result * 59 + (this.isResponse() ? 79 : 97);
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            Map<String, String> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            String $bodyAsString = this.getBodyAsString();
            result = result * 59 + ($bodyAsString == null ? 43 : $bodyAsString.hashCode());
            RbelElement $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RbelValueShader.JexlMessage(method=" + this.getMethod() + ", url=" + this.getUrl() + ", isRequest=" + this.isRequest() + ", isResponse=" + this.isResponse() + ", headers=" + this.getHeaders() + ", bodyAsString=" + this.getBodyAsString() + ", body=" + this.getBody() + ")";
        }

        @Generated
        public static class JexlMessageBuilder {
            @Generated
            private String method;
            @Generated
            private String url;
            @Generated
            private boolean isRequest;
            @Generated
            private boolean isResponse;
            @Generated
            private Map<String, String> headers;
            @Generated
            private String bodyAsString;
            @Generated
            private RbelElement body;

            @Generated
            JexlMessageBuilder() {
            }

            @Generated
            public JexlMessageBuilder method(String method) {
                this.method = method;
                return this;
            }

            @Generated
            public JexlMessageBuilder url(String url) {
                this.url = url;
                return this;
            }

            @Generated
            public JexlMessageBuilder isRequest(boolean isRequest) {
                this.isRequest = isRequest;
                return this;
            }

            @Generated
            public JexlMessageBuilder isResponse(boolean isResponse) {
                this.isResponse = isResponse;
                return this;
            }

            @Generated
            public JexlMessageBuilder headers(Map<String, String> headers) {
                this.headers = headers;
                return this;
            }

            @Generated
            public JexlMessageBuilder bodyAsString(String bodyAsString) {
                this.bodyAsString = bodyAsString;
                return this;
            }

            @Generated
            public JexlMessageBuilder body(RbelElement body) {
                this.body = body;
                return this;
            }

            @Generated
            public JexlMessage build() {
                return new JexlMessage(this.method, this.url, this.isRequest, this.isResponse, this.headers, this.bodyAsString, this.body);
            }

            @Generated
            public String toString() {
                return "RbelValueShader.JexlMessage.JexlMessageBuilder(method=" + this.method + ", url=" + this.url + ", isRequest=" + this.isRequest + ", isResponse=" + this.isResponse + ", headers=" + this.headers + ", bodyAsString=" + this.bodyAsString + ", body=" + this.body + ")";
            }
        }
    }
}

