/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelUriFacet;
import de.gematik.rbellogger.data.facet.RbelUriParameterFacet;
import de.gematik.rbellogger.exceptions.RbelConversionException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class RbelUriConverter
implements RbelConverterPlugin {
    public List<RbelElement> extractParameterMap(URI uri, RbelConverter context, String originalContent, RbelElement parentNode) {
        if (StringUtils.isEmpty((CharSequence)uri.getQuery())) {
            return List.of();
        }
        String[] split = originalContent.split("\\?");
        if (split.length < 2) {
            return List.of();
        }
        return Stream.of(split[1].split("\\&")).filter(StringUtils::isNotEmpty).map(param -> {
            RbelElement paramPair = new RbelElement(param.getBytes(parentNode.getElementCharset()), parentNode);
            String[] splitParams = param.split("\\=", 2);
            if (splitParams.length == 1) {
                paramPair.addFacet(RbelUriParameterFacet.builder().key(RbelElement.wrap(paramPair, splitParams[0])).value(context.convertElement("", paramPair)).build());
            } else {
                paramPair.addFacet(RbelUriParameterFacet.builder().key(RbelElement.wrap(paramPair, splitParams[0])).value(context.convertElement(URLDecoder.decode(splitParams[1], StandardCharsets.UTF_8).getBytes(parentNode.getElementCharset()), paramPair)).build());
            }
            return paramPair;
        }).toList();
    }

    public boolean canConvertElement(RbelElement rbel) {
        try {
            URI uri = new URI(rbel.getRawStringContent());
            boolean hasQuery = uri.getQuery() != null;
            boolean hasProtocol = uri.getScheme() != null;
            return hasQuery || hasProtocol || rbel.getRawStringContent().startsWith("/");
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    @Override
    public void consumeElement(RbelElement rbel, RbelConverter context) {
        if (!this.canConvertElement(rbel)) {
            return;
        }
        URI uri = this.convertToUri(rbel);
        String[] pathParts = rbel.getRawStringContent().split("\\?", 2);
        RbelUriFacet.RbelUriFacetBuilder uriFacetBuilder = RbelUriFacet.builder().basicPath(RbelElement.wrap(rbel, pathParts[0]));
        if (pathParts.length > 1) {
            uriFacetBuilder.queryParameters(this.extractParameterMap(uri, context, rbel.getRawStringContent(), rbel));
        } else {
            uriFacetBuilder.queryParameters(List.of());
        }
        rbel.addFacet(uriFacetBuilder.build());
    }

    private URI convertToUri(RbelElement target) {
        try {
            return new URI(target.getRawStringContent());
        }
        catch (URISyntaxException e) {
            throw new RbelConversionException("Unable to convert Path-Element '" + target.getRawStringContent() + "'", e);
        }
    }
}

