/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelBinaryFacet;
import de.gematik.rbellogger.data.facet.RbelHttpHeaderFacet;
import de.gematik.rbellogger.data.facet.RbelHttpMessageFacet;
import de.gematik.rbellogger.data.facet.RbelListFacet;
import de.gematik.rbellogger.data.facet.RbelMtomDataPartFacet;
import de.gematik.rbellogger.data.facet.RbelMtomFacet;
import de.gematik.rbellogger.data.util.MtomPart;
import de.gematik.rbellogger.util.RbelException;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelMtomConverter
implements RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelMtomConverter.class);
    public static final String CONTENT_ID = "Content-ID";

    @Override
    public void consumeElement(RbelElement rbelElement, RbelConverter converter) {
        if (!this.stringStartIsMtom(rbelElement)) {
            return;
        }
        new RbelMtomConverterExecutor(rbelElement, converter).execute();
    }

    private boolean stringStartIsMtom(RbelElement rbelElement) {
        return rbelElement.getRawStringContent().trim().startsWith("--");
    }

    private class RbelMtomConverterExecutor {
        private final RbelElement parentNode;
        private final RbelConverter converter;
        private List<MtomPart> mtomParts;
        private Map<String, String> dataParts = new HashMap<String, String>();
        private MtomPart rootPart;

        public void execute() {
            Optional<MediaType> vauContentType = this.getVauContentType(this.parentNode).or(() -> this.getMtomContentType(this.parentNode));
            if (vauContentType.isEmpty() || !vauContentType.get().is(MediaType.parse((String)"multipart/related"))) {
                return;
            }
            this.mtomParts = this.divideMessageIntoMtomParts(this.parentNode, vauContentType.get());
            if (this.mtomParts.isEmpty()) {
                return;
            }
            this.rootPart = this.mtomParts.stream().filter(mtomPart -> mtomPart.getMessageHeader().getOrDefault(RbelMtomConverter.CONTENT_ID, "").equals(((MediaType)vauContentType.get()).parameters().get((Object)"start").stream().findAny().orElse(""))).findAny().orElse(this.mtomParts.get(0));
            if (this.rootPart == null) {
                log.warn("Skipping MTOM/XOP reconstruction: Unable to find root-part!");
                return;
            }
            Optional<RbelMtomFacet> mtomFacet = this.reconstructMessage();
            if (mtomFacet.isEmpty()) {
                log.warn("Skipping MTOM/XOP reconstruction: Message reconstruction failed!");
                return;
            }
            this.parentNode.addFacet(mtomFacet.get());
        }

        private Optional<RbelMtomFacet> reconstructMessage() {
            try {
                Document document = DocumentHelper.parseText((String)this.rootPart.getMessageContent());
                Map<String, String> mtomMap = this.mtomParts.stream().filter(part -> StringUtils.isNotEmpty((CharSequence)part.getMessageHeader().get(RbelMtomConverter.CONTENT_ID))).collect(Collectors.toMap(p -> p.getMessageHeader().get(RbelMtomConverter.CONTENT_ID), MtomPart::getMessageContent));
                XPath xPath = DocumentHelper.createXPath((String)"//xop:Include");
                xPath.setNamespaceURIs(Map.of("xop", "http://www.w3.org/2004/08/xop/include"));
                List includeNodes = xPath.selectNodes((Object)document);
                for (Node includeNode : includeNodes) {
                    Optional<String> partId;
                    if (!(includeNode instanceof Element) || !(partId = this.extractContentIdFromInclude(includeNode).map(id -> "<" + id + ">")).isPresent()) continue;
                    Optional newNode = partId.map(mtomMap::get).flatMap(this::parseAsXml);
                    String part2 = mtomMap.remove(partId.get());
                    if (newNode.isPresent()) {
                        List elepar = includeNode.getParent().content();
                        elepar.set(elepar.indexOf(includeNode), (Node)newNode.get());
                        continue;
                    }
                    this.dataParts.put(includeNode.getPath(), part2);
                }
                return Optional.of(this.buildMtomFacet(document.asXML()));
            }
            catch (RbelException | DocumentException e) {
                return Optional.empty();
            }
        }

        private RbelMtomFacet buildMtomFacet(String reconstructedXml) {
            return new RbelMtomFacet(RbelElement.wrap(this.parentNode, this.rootPart.getMessageHeader().get("Content-Type")), this.converter.convertElement(reconstructedXml, this.parentNode), this.createMtomDataPartsElement());
        }

        @Nullable
        private RbelElement createMtomDataPartsElement() {
            if (this.dataParts.isEmpty()) {
                return null;
            }
            RbelElement dataPartsElement = new RbelElement(null, this.parentNode);
            RbelListFacet dataListFacet = new RbelListFacet(this.dataParts.entrySet().stream().map(dataEntry -> this.buildDataEntry((String)dataEntry.getValue(), (String)dataEntry.getKey(), dataPartsElement)).toList());
            dataPartsElement.addFacet(dataListFacet);
            return dataPartsElement;
        }

        private RbelElement buildDataEntry(String content, String xpath, RbelElement parentNode) {
            RbelElement result = new RbelElement(null, parentNode);
            RbelElement contentElement = this.converter.convertElement(content, result);
            contentElement.addFacet(new RbelBinaryFacet());
            result.addFacet(new RbelMtomDataPartFacet(contentElement, RbelElement.wrap(result, xpath)));
            return result;
        }

        private Optional<Node> parseAsXml(String text) {
            try {
                return Optional.ofNullable(DocumentHelper.parseText((String)text).getRootElement());
            }
            catch (DocumentException e) {
                return Optional.empty();
            }
        }

        private Optional<String> extractContentIdFromInclude(Object includeNode) {
            try {
                return Optional.ofNullable(new URI(((Element)includeNode).attribute("href").getValue()).getSchemeSpecificPart());
            }
            catch (URISyntaxException e) {
                return Optional.empty();
            }
        }

        private List<MtomPart> divideMessageIntoMtomParts(RbelElement rbelElement, MediaType mediaType) {
            ImmutableList boundary = mediaType.parameters().get((Object)"boundary");
            if (boundary.isEmpty()) {
                return List.of();
            }
            return Stream.of(rbelElement.getRawStringContent().split("(\r\n|\n)--" + Pattern.quote((String)boundary.get(0)))).map(MtomPart::new).filter(mtomPart -> mtomPart.getMessageHeader().size() > 0).toList();
        }

        private Optional<MediaType> getVauContentType(RbelElement rbelElement) {
            return Optional.ofNullable(rbelElement.getParentNode()).flatMap(el -> el.getFirst("additionalHeaders")).flatMap(this::extractContentType);
        }

        private Optional<MediaType> getMtomContentType(RbelElement rbelElement) {
            return Optional.ofNullable(rbelElement.getParentNode()).flatMap(el -> el.getFacet(RbelHttpMessageFacet.class)).map(RbelHttpMessageFacet::getHeader).flatMap(this::extractContentType);
        }

        private Optional<MediaType> extractContentType(RbelElement rbelElement) {
            return rbelElement.getFacet(RbelHttpHeaderFacet.class).stream().flatMap(header -> header.getCaseInsensitiveMatches("content-type")).map(RbelElement::getRawStringContent).filter(Objects::nonNull).map(String::trim).map(value -> {
                try {
                    return MediaType.parse((String)value);
                }
                catch (Exception e) {
                    return null;
                }
            }).filter(Objects::nonNull).findAny();
        }

        @ConstructorProperties(value={"parentNode", "converter"})
        @Generated
        public RbelMtomConverterExecutor(RbelElement parentNode, RbelConverter converter) {
            this.parentNode = parentNode;
            this.converter = converter;
        }
    }
}

